/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item.field.reader;

import com.liferay.info.display.contributor.field.InfoDisplayContributorField;
import com.liferay.info.display.contributor.field.InfoDisplayContributorFieldType;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.type.ImageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.item.field.reader.InfoItemFieldReader;
import com.liferay.info.item.field.reader.InfoItemFieldReaderRegistry;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.GenericUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={InfoItemFieldReaderRegistry.class})
public class InfoItemFieldReaderRegistryImpl
implements InfoItemFieldReaderRegistry {
    private final Map<String, List<InfoItemFieldReader>> _infoItemFieldReaderWrappersMap = new ConcurrentHashMap<String, List<InfoItemFieldReader>>();
    private ServiceTrackerMap<String, List<InfoItemFieldReader>> _itemInfoItemFieldReaderServiceTrackerMap;

    public List<InfoItemFieldReader> getInfoItemFieldReaders(String itemClassName) {
        List<Object> infoItemFieldReaderWrappers;
        List infoItemFieldReaders = (List)this._itemInfoItemFieldReaderServiceTrackerMap.getService((Object)itemClassName);
        if (infoItemFieldReaders == null) {
            infoItemFieldReaders = Collections.emptyList();
        }
        if ((infoItemFieldReaderWrappers = this._infoItemFieldReaderWrappersMap.get(itemClassName)) == null) {
            infoItemFieldReaderWrappers = Collections.emptyList();
        }
        return ListUtil.concat((List[])new List[]{infoItemFieldReaders, infoItemFieldReaderWrappers});
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._itemInfoItemFieldReaderServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, InfoItemFieldReader.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (infoItemFieldReader, emitter) -> emitter.emit((Object)GenericUtil.getGenericClassName((Object)infoItemFieldReader))), Collections.reverseOrder(new PropertyServiceReferenceComparator("info.item.field.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._itemInfoItemFieldReaderServiceTrackerMap.close();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setInfoItemFieldReaderWrapper(InfoDisplayContributorField<Object> infoDisplayContributorField, Map<String, Object> properties) {
        String className = (String)properties.get("model.class.name");
        if (Validator.isNull((String)className)) {
            return;
        }
        List infoItemFieldReaderWrappers = this._infoItemFieldReaderWrappersMap.computeIfAbsent(className, itemClass -> new ArrayList());
        infoItemFieldReaderWrappers.add(new InfoItemFieldReaderWrapper(infoDisplayContributorField));
    }

    protected void unsetInfoItemFieldReaderWrapper(InfoDisplayContributorField<?> infoDisplayContributorField, Map<String, Object> properties) {
        String className = (String)properties.get("model.class.name");
        if (Validator.isNull((String)className)) {
            return;
        }
        List<InfoItemFieldReader> infoItemFieldReaderWrappers = this._infoItemFieldReaderWrappersMap.get(className);
        if (infoItemFieldReaderWrappers != null) {
            for (InfoItemFieldReader infoItemFieldReader : infoItemFieldReaderWrappers) {
                InfoItemFieldReaderWrapper infoItemFieldReaderWrapper = (InfoItemFieldReaderWrapper)infoItemFieldReader;
                InfoDisplayContributorField<?> existingInfoDisplayContributorField = infoItemFieldReaderWrapper.getInfoDisplayContributorField();
                if (existingInfoDisplayContributorField != infoDisplayContributorField) continue;
                infoItemFieldReaderWrappers.remove(infoDisplayContributorField);
            }
        }
    }

    private class InfoItemFieldReaderWrapper
    implements InfoItemFieldReader {
        private final InfoDisplayContributorField<Object> _infoDisplayContributorField;

        public InfoItemFieldReaderWrapper(InfoDisplayContributorField<Object> infoDisplayContributorField) {
            this._infoDisplayContributorField = infoDisplayContributorField;
        }

        public InfoDisplayContributorField<?> getInfoDisplayContributorField() {
            return this._infoDisplayContributorField;
        }

        public InfoField<?> getInfoField() {
            TextInfoFieldType infoFieldType = TextInfoFieldType.INSTANCE;
            InfoDisplayContributorFieldType infoDisplayContributorFieldType = this._infoDisplayContributorField.getType();
            if (infoDisplayContributorFieldType == InfoDisplayContributorFieldType.IMAGE) {
                infoFieldType = ImageInfoFieldType.INSTANCE;
            } else if (infoDisplayContributorFieldType == InfoDisplayContributorFieldType.URL) {
                infoFieldType = URLInfoFieldType.INSTANCE;
            }
            return InfoField.builder().infoFieldType((InfoFieldType)infoFieldType).namespace(InfoDisplayContributorField.class.getSimpleName()).name(this.getKey()).labelInfoLocalizedValue(InfoLocalizedValue.function(locale -> this._infoDisplayContributorField.getLabel(locale))).build();
        }

        public String getKey() {
            return this._infoDisplayContributorField.getKey();
        }

        public Object getValue(Object model) {
            return InfoLocalizedValue.function(locale -> this._infoDisplayContributorField.getValue(model, locale));
        }
    }
}

