/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item;

import com.liferay.info.exception.CapabilityVerificationException;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.InfoItemServiceVerifier;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoItemServiceVerifier.class})
public class InfoItemServiceVerifierImpl
implements InfoItemServiceVerifier {
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;

    public List<Class<?>> getMissingServiceClasses(Class<?>[] requiredInfoItemServiceClasses, String itemClassName) throws CapabilityVerificationException {
        ArrayList missingServiceClasses = new ArrayList();
        for (Class<?> serviceClass : requiredInfoItemServiceClasses) {
            Object infoItemService = this._infoItemServiceRegistry.getFirstInfoItemService(serviceClass, itemClassName);
            if (infoItemService != null) continue;
            missingServiceClasses.add(serviceClass);
        }
        return missingServiceClasses;
    }
}

