/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item;

import com.liferay.friendly.url.info.item.provider.InfoItemFriendlyURLProvider;
import com.liferay.friendly.url.info.item.updater.InfoItemFriendlyURLUpdater;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.exception.CapabilityVerificationException;
import com.liferay.info.exception.InfoPermissionException;
import com.liferay.info.filter.InfoFilterProvider;
import com.liferay.info.filter.InfoRequestItemProvider;
import com.liferay.info.formatter.InfoCollectionTextFormatter;
import com.liferay.info.formatter.InfoTextFormatter;
import com.liferay.info.internal.util.ItemClassNameServiceReferenceMapper;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.capability.InfoItemCapability;
import com.liferay.info.item.creator.InfoItemCreator;
import com.liferay.info.item.provider.InfoItemCapabilitiesProvider;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.provider.InfoItemObjectVariationProvider;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.info.item.provider.InfoItemWorkflowProvider;
import com.liferay.info.item.provider.filter.InfoItemServiceFilter;
import com.liferay.info.item.provider.filter.OptionalPropertyInfoItemServiceFilter;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.translator.InfoItemIdentifierTranslator;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.info.list.renderer.InfoListRenderer;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.permission.provider.InfoPermissionProvider;
import com.liferay.info.type.Keyed;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.info.item.provider.InfoItemLanguagesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={InfoItemServiceRegistry.class})
public class InfoItemServiceRegistryImpl
implements InfoItemServiceRegistry {
    private static final Log _log = LogFactoryUtil.getLog(InfoItemServiceRegistryImpl.class);
    private static final Set<Class<?>> _validInfoClasses = new HashSet<Class>(Arrays.asList(InfoCollectionProvider.class, InfoCollectionTextFormatter.class, InfoFilterProvider.class, InfoItemCapabilitiesProvider.class, InfoItemCreator.class, InfoItemDetailsProvider.class, InfoItemFieldValuesProvider.class, InfoItemFieldValuesUpdater.class, InfoItemFormProvider.class, InfoItemFormVariationsProvider.class, InfoItemFriendlyURLProvider.class, InfoItemFriendlyURLUpdater.class, InfoItemIdentifierTranslator.class, InfoItemLanguagesProvider.class, InfoItemObjectProvider.class, InfoItemObjectVariationProvider.class, InfoItemPermissionProvider.class, InfoItemRenderer.class, InfoItemWorkflowProvider.class, InfoListRenderer.class, InfoPermissionProvider.class, InfoRequestItemProvider.class, InfoTextFormatter.class, RelatedInfoItemCollectionProvider.class));
    private BundleContext _bundleContext;
    private ServiceTrackerMap<String, InfoItemCapability> _infoItemCapabilityServiceTrackerMap;
    private final Map<Class<?>, ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>>> _itemClassNameInfoItemServiceTrackerMap = new ConcurrentHashMap();
    private final Map<Class<?>, ServiceTrackerMap<String, ?>> _keyedInfoItemServiceTrackerMap = new ConcurrentHashMap();

    public <P> List<P> getAllInfoItemServices(Class<P> serviceClass) {
        ServiceTrackerMap<String, ?> serviceTrackerMap = this._getKeyedInfoItemServiceTrackerMap(serviceClass);
        return new ArrayList(serviceTrackerMap.values());
    }

    public <P> List<P> getAllInfoItemServices(Class<P> serviceClass, String itemClassName, InfoItemServiceFilter infoItemServiceFilter) {
        ServiceTrackerMap<String, ?> infoItemServiceTrackerMap = this._getItemClassNameInfoItemServiceTrackerMap(serviceClass);
        List<ServiceReferenceServiceTuple<P, P>> serviceReferenceServiceTuples = (List<ServiceReferenceServiceTuple<P, P>>)infoItemServiceTrackerMap.getService((Object)itemClassName);
        if (serviceReferenceServiceTuples != null) {
            serviceReferenceServiceTuples = this._filterServiceReferenceServiceTuples((InfoItemServiceFilter)new OptionalPropertyInfoItemServiceFilter("company.id", String.valueOf(CompanyThreadLocal.getCompanyId())), serviceReferenceServiceTuples);
            if (infoItemServiceFilter != null) {
                serviceReferenceServiceTuples = this._filterServiceReferenceServiceTuples(infoItemServiceFilter, serviceReferenceServiceTuples);
            }
            return ListUtil.toList(serviceReferenceServiceTuples, ServiceReferenceServiceTuple::getService);
        }
        return Collections.emptyList();
    }

    public <P> P getFirstInfoItemService(Class<P> serviceClass, String itemClassName, InfoItemServiceFilter infoItemServiceFilter) {
        List<P> infoItemServices = this.getAllInfoItemServices(serviceClass, itemClassName, infoItemServiceFilter);
        if (ListUtil.isEmpty(infoItemServices)) {
            return null;
        }
        return infoItemServices.get(0);
    }

    public List<InfoItemCapability> getInfoItemCapabilities(String itemClassName) {
        InfoItemCapabilitiesProvider infoItemCapabilitiesProvider = this.getFirstInfoItemService(InfoItemCapabilitiesProvider.class, itemClassName, null);
        if (infoItemCapabilitiesProvider == null) {
            return null;
        }
        return infoItemCapabilitiesProvider.getInfoItemCapabilities();
    }

    public InfoItemCapability getInfoItemCapability(String infoItemCapabilityKey) {
        ServiceTrackerMap<String, InfoItemCapability> infoItemCapabilityServiceTrackerMap = this._getInfoItemCapabilityServiceTrackerMap();
        return (InfoItemCapability)infoItemCapabilityServiceTrackerMap.getService((Object)infoItemCapabilityKey);
    }

    public <P> List<InfoItemClassDetails> getInfoItemClassDetails(Class<P> serviceClass) {
        List<String> infoItemClassNames = this.getInfoItemClassNames(serviceClass);
        Stream infoItemClassNamesStream = infoItemClassNames.stream();
        return infoItemClassNamesStream.map(itemClassName -> this._getInfoItemClassDetails((String)itemClassName)).collect(Collectors.toList());
    }

    public List<InfoItemClassDetails> getInfoItemClassDetails(InfoItemCapability infoItemCapability) throws CapabilityVerificationException {
        ArrayList<InfoItemClassDetails> infoItemClassDetailsList = new ArrayList<InfoItemClassDetails>();
        for (InfoItemClassDetails curInfoItemClassDetails : this.getInfoItemClassDetails(InfoItemCapabilitiesProvider.class)) {
            List infoItemCapabilities;
            InfoItemCapabilitiesProvider infoItemCapabilitiesProvider = this.getFirstInfoItemService(InfoItemCapabilitiesProvider.class, curInfoItemClassDetails.getClassName(), null);
            if (infoItemCapabilitiesProvider == null || !(infoItemCapabilities = infoItemCapabilitiesProvider.getInfoItemCapabilities()).contains(infoItemCapability)) continue;
            infoItemCapability.verify(curInfoItemClassDetails.getClassName());
            infoItemClassDetailsList.add(curInfoItemClassDetails);
        }
        return infoItemClassDetailsList;
    }

    public List<InfoItemClassDetails> getInfoItemClassDetails(long groupId, String itemCapabilityKey, PermissionChecker permissionChecker) throws CapabilityVerificationException {
        ArrayList<InfoItemClassDetails> infoItemClassDetails = new ArrayList<InfoItemClassDetails>();
        for (InfoItemClassDetails infoItemClassDetail : this.getInfoItemClassDetails(itemCapabilityKey)) {
            InfoPermissionProvider infoPermissionProvider = (InfoPermissionProvider)this.getFirstInfoItemService(InfoPermissionProvider.class, infoItemClassDetail.getClassName());
            if (infoPermissionProvider == null) {
                infoItemClassDetails.add(infoItemClassDetail);
                continue;
            }
            try {
                if (!infoPermissionProvider.hasViewPermission(permissionChecker)) continue;
                infoItemClassDetails.add(infoItemClassDetail);
            }
            catch (InfoPermissionException infoPermissionException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)infoPermissionException);
            }
        }
        return infoItemClassDetails;
    }

    public List<InfoItemClassDetails> getInfoItemClassDetails(String infoItemCapabilityKey) throws CapabilityVerificationException {
        ServiceTrackerMap<String, InfoItemCapability> infoItemCapabilityServiceTrackerMap = this._getInfoItemCapabilityServiceTrackerMap();
        InfoItemCapability infoItemCapability = (InfoItemCapability)infoItemCapabilityServiceTrackerMap.getService((Object)infoItemCapabilityKey);
        if (infoItemCapability == null) {
            throw new RuntimeException("Unable to find info item capability with key " + infoItemCapabilityKey);
        }
        return this.getInfoItemClassDetails(infoItemCapability);
    }

    public <P> List<String> getInfoItemClassNames(Class<P> serviceClass) {
        ServiceTrackerMap<String, ?> infoItemServiceTrackerMap = this._getItemClassNameInfoItemServiceTrackerMap(serviceClass);
        return new ArrayList<String>(infoItemServiceTrackerMap.keySet());
    }

    public <P> P getInfoItemService(Class<P> serviceClass, String serviceKey) {
        if (Validator.isNull((String)serviceKey)) {
            return null;
        }
        ServiceTrackerMap<String, ?> infoItemServiceTrackerMap = this._getKeyedInfoItemServiceTrackerMap(serviceClass);
        return (P)infoItemServiceTrackerMap.getService((Object)serviceKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        if (this._infoItemCapabilityServiceTrackerMap != null) {
            this._infoItemCapabilityServiceTrackerMap.close();
        }
        for (ServiceTrackerMap<String, List<ServiceReferenceServiceTuple<Object, Object>>> serviceTrackerMap : this._itemClassNameInfoItemServiceTrackerMap.values()) {
            serviceTrackerMap.close();
        }
        for (ServiceTrackerMap serviceTrackerMap : this._keyedInfoItemServiceTrackerMap.values()) {
            serviceTrackerMap.close();
        }
    }

    private <P> List<ServiceReferenceServiceTuple<P, P>> _filterServiceReferenceServiceTuples(InfoItemServiceFilter infoItemServiceFilter, List<ServiceReferenceServiceTuple<P, P>> serviceReferenceTuples) {
        try {
            Filter filter = FrameworkUtil.createFilter((String)infoItemServiceFilter.getFilterString());
            return ListUtil.filter(serviceReferenceTuples, serviceReferenceTuple -> filter.match(serviceReferenceTuple.getServiceReference()));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException("Invalid filter string", invalidSyntaxException);
        }
    }

    private ServiceTrackerMap<String, InfoItemCapability> _getInfoItemCapabilityServiceTrackerMap() {
        if (this._infoItemCapabilityServiceTrackerMap == null) {
            this._infoItemCapabilityServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, InfoItemCapability.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)this._bundleContext, (service, emitter) -> emitter.emit((Object)service.getKey())));
        }
        return this._infoItemCapabilityServiceTrackerMap;
    }

    private InfoItemClassDetails _getInfoItemClassDetails(String itemClassName) {
        InfoItemDetailsProvider infoItemDetailsProvider = this.getFirstInfoItemService(InfoItemDetailsProvider.class, itemClassName, null);
        if (infoItemDetailsProvider != null) {
            return infoItemDetailsProvider.getInfoItemClassDetails();
        }
        return new InfoItemClassDetails(itemClassName, InfoLocalizedValue.modelResource((String)itemClassName));
    }

    private ServiceTrackerMap<String, ?> _getItemClassNameInfoItemServiceTrackerMap(Class<?> clazz) {
        if (!_validInfoClasses.contains(clazz)) {
            return null;
        }
        return this._itemClassNameInfoItemServiceTrackerMap.computeIfAbsent(clazz, keyClass -> ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, (Class)keyClass, null, (ServiceReferenceMapper)new ItemClassNameServiceReferenceMapper(this._bundleContext), (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceReferenceServiceTuple((BundleContext)this._bundleContext)));
    }

    private ServiceTrackerMap<String, ?> _getKeyedInfoItemServiceTrackerMap(Class<?> clazz) {
        if (!_validInfoClasses.contains(clazz)) {
            return null;
        }
        return this._keyedInfoItemServiceTrackerMap.computeIfAbsent(clazz, keyClass -> ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, (Class)keyClass, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)this._bundleContext, (service, emitter) -> {
            String key = keyClass.getName();
            if (service instanceof Keyed) {
                Keyed keyedService = (Keyed)service;
                key = keyedService.getKey();
            }
            emitter.emit((Object)key);
        }), (Comparator)new PropertyServiceReferenceComparator("service.ranking")));
    }
}

