/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item.field.reader;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.item.field.reader.InfoItemFieldReader;
import com.liferay.info.item.field.reader.InfoItemFieldReaderFieldSetProvider;
import com.liferay.info.item.field.reader.InfoItemFieldReaderTracker;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoItemFieldReaderFieldSetProvider.class})
public class InfoItemFieldReaderFieldSetProviderImpl
implements InfoItemFieldReaderFieldSetProvider {
    @Reference
    private InfoItemFieldReaderTracker _infoItemFieldReaderTracker;

    public InfoFieldSet getInfoFieldSet(String className) {
        return InfoFieldSet.builder().infoFieldSetEntry(consumer -> {
            List infoItemFieldReaders = this._infoItemFieldReaderTracker.getInfoItemFieldReaders(className);
            for (InfoItemFieldReader infoItemFieldReader : infoItemFieldReaders) {
                consumer.accept((Object)infoItemFieldReader.getField());
            }
        }).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"fields")).name("fields").build();
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(String className, Object itemObject) {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        List infoItemFieldReaders = this._infoItemFieldReaderTracker.getInfoItemFieldReaders(className);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (InfoItemFieldReader infoItemFieldReader : infoItemFieldReaders) {
            InfoField infoField = infoItemFieldReader.getField();
            Object value = infoItemFieldReader.getValue(itemObject);
            if (serviceContext != null && infoField.getInfoFieldType() != URLInfoFieldType.INSTANCE && value instanceof String) {
                try {
                    value = SanitizerUtil.sanitize((long)serviceContext.getCompanyId(), (long)serviceContext.getScopeGroupId(), (long)serviceContext.getUserId(), (String)className, (long)0L, (String)"text/html", (String)"ALL", (String)((String)value), null);
                }
                catch (SanitizerException sanitizerException) {
                    throw new RuntimeException(sanitizerException);
                }
            }
            infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(infoField, value));
        }
        return infoFieldValues;
    }
}

