/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.display.field;

import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeField;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.field.ClassTypesInfoDisplayFieldProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ClassTypesInfoDisplayFieldProvider.class})
public class ClassTypesInfoDisplayFieldProviderImpl
implements ClassTypesInfoDisplayFieldProvider {
    @Reference
    private Portal _portal;

    public List<InfoDisplayField> getClassTypeInfoDisplayFields(ClassType classType, Locale locale) throws PortalException {
        if (classType == null) {
            return Collections.emptyList();
        }
        ArrayList<InfoDisplayField> classTypeInfoDisplayFields = new ArrayList<InfoDisplayField>();
        for (ClassTypeField classTypeField : classType.getClassTypeFields()) {
            classTypeInfoDisplayFields.add(new InfoDisplayField(classTypeField.getName(), LanguageUtil.get((Locale)locale, (String)classTypeField.getLabel()), classTypeField.getType()));
        }
        return classTypeInfoDisplayFields;
    }

    public List<ClassType> getClassTypes(long groupId, ClassTypeReader classTypeReader, Locale locale) throws PortalException {
        return classTypeReader.getAvailableClassTypes(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), locale);
    }
}

