/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.display.contributor;

import com.liferay.asset.info.item.provider.AssetEntryInfoItemFieldSetProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.info.display.contributor.field.InfoDisplayContributorFieldType;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.ImageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.GroupUrlTitleInfoItemIdentifier;
import com.liferay.info.item.InfoItemClassDetails;
import com.liferay.info.item.InfoItemDetails;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.capability.InfoItemCapability;
import com.liferay.info.item.provider.InfoItemCapabilitiesProvider;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InfoDisplayContributorWrapper
implements InfoItemCapabilitiesProvider<Object>,
InfoItemDetailsProvider<Object>,
InfoItemFieldValuesProvider<Object>,
InfoItemFormProvider<Object>,
InfoItemFormVariationsProvider<Object>,
InfoItemObjectProvider<Object> {
    private final AssetEntryInfoItemFieldSetProvider _assetEntryInfoItemFieldSetProvider;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final InfoDisplayContributor<Object> _infoDisplayContributor;
    private final List<InfoItemCapability> _infoItemCapabilities;

    public InfoDisplayContributorWrapper(AssetEntryInfoItemFieldSetProvider assetEntryInfoItemFieldSetProvider, AssetEntryLocalService assetEntryLocalService, InfoDisplayContributor<Object> infoDisplayContributor, List<InfoItemCapability> infoItemCapabilities) {
        this._assetEntryInfoItemFieldSetProvider = assetEntryInfoItemFieldSetProvider;
        this._assetEntryLocalService = assetEntryLocalService;
        this._infoDisplayContributor = infoDisplayContributor;
        this._infoItemCapabilities = infoItemCapabilities;
    }

    public InfoForm getInfoForm() {
        Locale locale = this._getLocale();
        try {
            return this._convertToInfoForm(this._infoDisplayContributor.getInfoDisplayFields(0L, locale), this._infoDisplayContributor.getClassName(), null);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    public InfoForm getInfoForm(long itemClassTypeId) {
        Locale locale = this._getLocale();
        try {
            return this._convertToInfoForm(this._infoDisplayContributor.getInfoDisplayFields(itemClassTypeId, locale), this._infoDisplayContributor.getClassName(), null);
        }
        catch (PortalException portalException) {
            throw new RuntimeException("Unable to get info form with item class type ID " + itemClassTypeId, portalException);
        }
    }

    public InfoForm getInfoForm(Object itemObject) {
        Locale locale = this._getLocale();
        try {
            return this._convertToInfoForm(this._infoDisplayContributor.getInfoDisplayFields(itemObject, locale), this._infoDisplayContributor.getClassName(), itemObject);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    public Object getInfoItem(InfoItemIdentifier infoItemIdentifier) throws NoSuchInfoItemException {
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier) && !(infoItemIdentifier instanceof GroupUrlTitleInfoItemIdentifier)) {
            throw new NoSuchInfoItemException("Unsupported info item identifier type " + infoItemIdentifier);
        }
        InfoDisplayObjectProvider infoDisplayObjectProvider = null;
        try {
            if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
                ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
                infoDisplayObjectProvider = this._infoDisplayContributor.getInfoDisplayObjectProvider(classPKInfoItemIdentifier.getClassPK());
            } else if (infoItemIdentifier instanceof GroupUrlTitleInfoItemIdentifier) {
                GroupUrlTitleInfoItemIdentifier groupURLTitleInfoItemIdentifier = (GroupUrlTitleInfoItemIdentifier)infoItemIdentifier;
                infoDisplayObjectProvider = this._infoDisplayContributor.getInfoDisplayObjectProvider(groupURLTitleInfoItemIdentifier.getGroupId(), groupURLTitleInfoItemIdentifier.getUrlTitle());
            }
            return infoDisplayObjectProvider.getDisplayObject();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    public Object getInfoItem(long classPK) throws NoSuchInfoItemException {
        ClassPKInfoItemIdentifier infoItemIdentifier = new ClassPKInfoItemIdentifier(classPK);
        return this.getInfoItem((InfoItemIdentifier)infoItemIdentifier);
    }

    public List<InfoItemCapability> getInfoItemCapabilities() {
        return this._infoItemCapabilities;
    }

    public InfoItemClassDetails getInfoItemClassDetails() {
        return new InfoItemClassDetails(this._infoDisplayContributor.getClassName(), InfoLocalizedValue.function(locale -> this._infoDisplayContributor.getLabel(locale)));
    }

    public InfoItemDetails getInfoItemDetails(Object itemObject) {
        return new InfoItemDetails(this.getInfoItemClassDetails(), new InfoItemReference(this._infoDisplayContributor.getClassName(), this._infoDisplayContributor.getInfoDisplayObjectClassPK(itemObject)));
    }

    public InfoItemFieldValues getInfoItemFieldValues(Object itemObject) {
        Locale locale = this._getLocale();
        try {
            return this._convertToInfoItemFieldValues(this._infoDisplayContributor.getInfoDisplayFieldsValues(itemObject, locale), new InfoItemReference(this._infoDisplayContributor.getClassName(), this._infoDisplayContributor.getInfoDisplayObjectClassPK(itemObject)));
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    public Collection<InfoItemFormVariation> getInfoItemFormVariations(long groupId) {
        HashSet<InfoItemFormVariation> itemFormVariations = new HashSet<InfoItemFormVariation>();
        try {
            List classTypes = this._infoDisplayContributor.getClassTypes(groupId, this._getLocale());
            if (classTypes == null) {
                return itemFormVariations;
            }
            for (ClassType classType : classTypes) {
                itemFormVariations.add(new InfoItemFormVariation(String.valueOf(classType.getClassTypeId()), InfoLocalizedValue.singleValue((String)classType.getName())));
            }
        }
        catch (PortalException portalException) {
            throw new RuntimeException("Unable to get item form variations for class " + this._infoDisplayContributor.getClassName(), portalException);
        }
        return itemFormVariations;
    }

    private InfoForm _convertToInfoForm(Set<InfoDisplayField> infoDisplayFields, String name, Object object) {
        Set availableLocales = LanguageUtil.getAvailableLocales();
        InfoLocalizedValue.Builder infoLocalizedValueBuilder = InfoLocalizedValue.builder();
        for (Locale locale : availableLocales) {
            infoLocalizedValueBuilder.value(locale, (Object)ResourceActionsUtil.getModelResource((Locale)locale, (String)name));
        }
        InfoForm.Builder infoFormBuilder = InfoForm.builder().infoFieldSetEntry(consumer -> {
            for (InfoDisplayField infoDisplayField : infoDisplayFields) {
                consumer.accept((Object)InfoField.builder().infoFieldType(this._getInfoFieldTypeType(infoDisplayField.getType())).name(infoDisplayField.getKey()).labelInfoLocalizedValue(InfoLocalizedValue.builder().value(this._getLocale(), (Object)infoDisplayField.getLabel()).build()).build());
            }
        }).labelInfoLocalizedValue(infoLocalizedValueBuilder.build()).name(name);
        if (Objects.equals(name, FileEntry.class.getName())) {
            long classPK = this._infoDisplayContributor.getInfoDisplayObjectClassPK(object);
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(DLFileEntry.class.getName(), classPK);
            if (assetEntry != null) {
                infoFormBuilder.infoFieldSetEntry(this._assetEntryInfoItemFieldSetProvider.getInfoFieldSet(assetEntry));
            }
        }
        return infoFormBuilder.build();
    }

    private InfoItemFieldValues _convertToInfoItemFieldValues(Map<String, Object> infoDisplayFieldsValues, InfoItemReference infoItemReference) {
        InfoItemFieldValues.Builder infoItemFieldValuesBuilder = InfoItemFieldValues.builder().infoFieldValue(consumer -> {
            for (Map.Entry entry : infoDisplayFieldsValues.entrySet()) {
                String fieldName = (String)entry.getKey();
                InfoLocalizedValue fieldLabelLocalizedValue = InfoLocalizedValue.builder().value(this._getLocale(), (Object)fieldName).build();
                InfoField infoField = InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).name(fieldName).labelInfoLocalizedValue(fieldLabelLocalizedValue).build();
                consumer.accept((Object)new InfoFieldValue(infoField, entry.getValue()));
            }
        });
        if (Objects.equals(infoItemReference.getClassName(), FileEntry.class.getName())) {
            try {
                infoItemFieldValuesBuilder.infoFieldValues(this._assetEntryInfoItemFieldSetProvider.getInfoFieldValues(DLFileEntry.class.getName(), infoItemReference.getClassPK()));
            }
            catch (NoSuchInfoItemException noSuchInfoItemException) {
                throw new RuntimeException("Caught unexpected exception", noSuchInfoItemException);
            }
        }
        return infoItemFieldValuesBuilder.infoItemReference(infoItemReference).build();
    }

    private InfoFieldType _getInfoFieldTypeType(String infoDisplayFieldType) {
        if (Objects.equals(infoDisplayFieldType, InfoDisplayContributorFieldType.IMAGE.getValue()) || Objects.equals(infoDisplayFieldType, "ddm-image")) {
            return ImageInfoFieldType.INSTANCE;
        }
        if (Objects.equals(infoDisplayFieldType, InfoDisplayContributorFieldType.URL.getValue())) {
            return URLInfoFieldType.INSTANCE;
        }
        return TextInfoFieldType.INSTANCE;
    }

    private Locale _getLocale() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }
}

