/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.list.renderer;

import com.liferay.info.internal.util.GenericsUtil;
import com.liferay.info.list.renderer.InfoListRenderer;
import com.liferay.info.list.renderer.InfoListRendererTracker;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={InfoListRendererTracker.class})
public class InfoListRendererTrackerImpl
implements InfoListRendererTracker {
    private final Map<String, InfoListRenderer> _infoListRenderers = new ConcurrentHashMap<String, InfoListRenderer>();
    private final Map<String, List<InfoListRenderer>> _itemClassNameInfoListRenderers = new ConcurrentHashMap<String, List<InfoListRenderer>>();

    public InfoListRenderer getInfoListRenderer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return this._infoListRenderers.get(key);
    }

    public List<InfoListRenderer> getInfoListRenderers() {
        return new ArrayList<InfoListRenderer>(this._infoListRenderers.values());
    }

    public List<InfoListRenderer> getInfoListRenderers(String itemClassName) {
        List<InfoListRenderer> infoListRenderers = this._itemClassNameInfoListRenderers.get(itemClassName);
        if (infoListRenderers != null) {
            return new ArrayList<InfoListRenderer>(infoListRenderers);
        }
        return Collections.emptyList();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setInfoListRenderer(InfoListRenderer infoListRenderer) {
        this._infoListRenderers.put(infoListRenderer.getKey(), infoListRenderer);
        List itemClassInfoListRenderers = this._itemClassNameInfoListRenderers.computeIfAbsent(GenericsUtil.getItemClassName(infoListRenderer), itemClass -> new ArrayList());
        itemClassInfoListRenderers.add(infoListRenderer);
    }

    protected void unsetInfoListRenderer(InfoListRenderer infoListRenderer) {
        this._infoListRenderers.remove(infoListRenderer.getKey());
        List<InfoListRenderer> itemClassInfoListRenderers = this._itemClassNameInfoListRenderers.get(GenericsUtil.getItemClassName(infoListRenderer));
        if (itemClassInfoListRenderers != null) {
            itemClassInfoListRenderers.remove(infoListRenderer);
        }
    }
}

