/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.list.provider;

import com.liferay.info.internal.util.GenericsUtil;
import com.liferay.info.list.provider.InfoListProvider;
import com.liferay.info.list.provider.InfoListProviderTracker;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={InfoListProviderTracker.class})
public class InfoListProviderTrackerImpl
implements InfoListProviderTracker {
    private final Map<String, InfoListProvider> _infoListProviders = new ConcurrentHashMap<String, InfoListProvider>();
    private final Map<Class, List<InfoListProvider>> _itemClassInfoListProviders = new ConcurrentHashMap<Class, List<InfoListProvider>>();

    public InfoListProvider getInfoListProvider(String className) {
        if (Validator.isNull((String)className)) {
            return null;
        }
        return this._infoListProviders.get(className);
    }

    public List<InfoListProvider> getInfoListProviders() {
        return new ArrayList<InfoListProvider>(this._infoListProviders.values());
    }

    public List<InfoListProvider> getInfoListProviders(Class<?> itemClass) {
        List<InfoListProvider> infoListProviders = this._itemClassInfoListProviders.get(itemClass);
        if (infoListProviders != null) {
            return new ArrayList<InfoListProvider>(infoListProviders);
        }
        return Collections.emptyList();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setInfoListProvider(InfoListProvider infoListProvider) {
        Class<?> clazz = infoListProvider.getClass();
        this._infoListProviders.put(clazz.getName(), infoListProvider);
        List itemClassInfoListProviders = this._itemClassInfoListProviders.computeIfAbsent(GenericsUtil.getItemClass(infoListProvider), itemClass -> new ArrayList());
        itemClassInfoListProviders.add(infoListProvider);
    }

    protected void unsetInfoListProvider(InfoListProvider infoListProvider) {
        Class<?> clazz = infoListProvider.getClass();
        this._infoListProviders.remove(clazz.getName());
        List<InfoListProvider> itemClassInfoListProviders = this._itemClassInfoListProviders.get(GenericsUtil.getItemClass(infoListProvider));
        if (itemClassInfoListProviders != null) {
            itemClassInfoListProviders.remove(infoListProvider);
        }
    }
}

