/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item.selector;

import com.liferay.info.internal.util.GenericsUtil;
import com.liferay.info.item.selector.InfoItemSelector;
import com.liferay.info.item.selector.InfoItemSelectorTracker;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={InfoItemSelectorTracker.class})
public class InfoItemSelectorTrackerImpl
implements InfoItemSelectorTracker {
    private final Map<String, InfoItemSelector> _infoItemSelectors = new ConcurrentHashMap<String, InfoItemSelector>();
    private final Map<String, List<InfoItemSelector>> _itemClassNameInfoItemSelectors = new ConcurrentHashMap<String, List<InfoItemSelector>>();

    public InfoItemSelector getInfoItemSelector(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return this._infoItemSelectors.get(key);
    }

    public List<InfoItemSelector> getInfoItemSelectors() {
        return new ArrayList<InfoItemSelector>(this._infoItemSelectors.values());
    }

    public List<InfoItemSelector> getInfoItemSelectors(String itemClassName) {
        List<InfoItemSelector> infoItemSelectors = this._itemClassNameInfoItemSelectors.get(itemClassName);
        if (infoItemSelectors != null) {
            return new ArrayList<InfoItemSelector>(infoItemSelectors);
        }
        return Collections.emptyList();
    }

    public Set<String> getInfoItemSelectorsClassNames() {
        return this._itemClassNameInfoItemSelectors.keySet();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setInfoItemSelector(InfoItemSelector infoItemSelector) {
        this._infoItemSelectors.put(infoItemSelector.getKey(), infoItemSelector);
        List itemClassInfoItemSelectors = this._itemClassNameInfoItemSelectors.computeIfAbsent(GenericsUtil.getItemClassName(infoItemSelector), itemClass -> new ArrayList());
        itemClassInfoItemSelectors.add(infoItemSelector);
    }

    protected void unsetInfoItemSelector(InfoItemSelector infoItemSelector) {
        this._infoItemSelectors.remove(infoItemSelector.getKey());
        List<InfoItemSelector> itemClassInfoItemSelectors = this._itemClassNameInfoItemSelectors.get(GenericsUtil.getItemClassName(infoItemSelector));
        if (itemClassInfoItemSelectors != null) {
            itemClassInfoItemSelectors.remove(infoItemSelector);
        }
    }
}

