/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.item.renderer;

import com.liferay.info.internal.util.GenericsUtil;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.info.item.renderer.InfoItemRendererTracker;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={InfoItemRendererTracker.class})
public class InfoItemRendererTrackerImpl
implements InfoItemRendererTracker {
    private ServiceTrackerMap<String, InfoItemRenderer> _infoItemRenderersServiceTrackerMap;
    private ServiceTrackerMap<String, List<InfoItemRenderer>> _itemClassNameInfoItemRendererServiceTrackerMap;

    public InfoItemRenderer getInfoItemRenderer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return (InfoItemRenderer)this._infoItemRenderersServiceTrackerMap.getService((Object)key);
    }

    public List<InfoItemRenderer> getInfoItemRenderers() {
        return new ArrayList<InfoItemRenderer>(this._infoItemRenderersServiceTrackerMap.values());
    }

    public List<InfoItemRenderer> getInfoItemRenderers(String itemClassName) {
        List infoItemRenderers = (List)this._itemClassNameInfoItemRendererServiceTrackerMap.getService((Object)itemClassName);
        if (infoItemRenderers != null) {
            return new ArrayList<InfoItemRenderer>(infoItemRenderers);
        }
        return Collections.emptyList();
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._itemClassNameInfoItemRendererServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, InfoItemRenderer.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, InfoItemRenderer>(){

            public void map(ServiceReference<InfoItemRenderer> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
                InfoItemRenderer infoItemRenderer = (InfoItemRenderer)bundleContext.getService(serviceReference);
                String className = GenericsUtil.getItemClassName(infoItemRenderer);
                emitter.emit((Object)className);
            }
        }, Collections.reverseOrder(new PropertyServiceReferenceComparator("service.ranking")));
        this._infoItemRenderersServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, InfoItemRenderer.class, null, (serviceReference, emitter) -> {
            InfoItemRenderer infoItemRenderer = (InfoItemRenderer)bundleContext.getService(serviceReference);
            emitter.emit((Object)infoItemRenderer.getKey());
        });
    }

    @Deactivate
    protected void deactivate() {
        this._itemClassNameInfoItemRendererServiceTrackerMap.close();
    }
}

