/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.renderer;

import com.liferay.info.internal.util.GenericsUtil;
import com.liferay.info.renderer.InfoItemRenderer;
import com.liferay.info.renderer.InfoItemRendererTracker;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={InfoItemRendererTracker.class})
public class InfoItemRendererTrackerImpl
implements InfoItemRendererTracker {
    private final Map<String, InfoItemRenderer> _infoItemRenderers = new ConcurrentHashMap<String, InfoItemRenderer>();
    private final Map<String, List<InfoItemRenderer>> _itemClassNameInfoItemRenderers = new ConcurrentHashMap<String, List<InfoItemRenderer>>();

    public InfoItemRenderer getInfoItemRenderer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        return this._infoItemRenderers.get(key);
    }

    public List<InfoItemRenderer> getInfoItemRenderers() {
        return new ArrayList<InfoItemRenderer>(this._infoItemRenderers.values());
    }

    public List<InfoItemRenderer> getInfoItemRenderers(String itemClassName) {
        List<InfoItemRenderer> infoItemRenderers = this._itemClassNameInfoItemRenderers.get(itemClassName);
        if (infoItemRenderers != null) {
            return new ArrayList<InfoItemRenderer>(infoItemRenderers);
        }
        return Collections.emptyList();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setInfoItemRenderer(InfoItemRenderer infoItemRenderer) {
        this._infoItemRenderers.put(infoItemRenderer.getKey(), infoItemRenderer);
        List itemClassInfoItemRenderers = this._itemClassNameInfoItemRenderers.computeIfAbsent(GenericsUtil.getItemClassName(infoItemRenderer), itemClass -> new ArrayList());
        itemClassInfoItemRenderers.add(infoItemRenderer);
    }

    protected void unsetInfoItemRenderer(InfoItemRenderer infoItemRenderer) {
        this._infoItemRenderers.remove(infoItemRenderer.getKey());
        List<InfoItemRenderer> itemClassInfoItemRenderers = this._itemClassNameInfoItemRenderers.get(GenericsUtil.getItemClass(infoItemRenderer));
        if (itemClassInfoItemRenderers != null) {
            this._itemClassNameInfoItemRenderers.remove(infoItemRenderer);
        }
    }
}

