/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.localized.bundle;

import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleInfoLocalizedValue
implements InfoLocalizedValue<String> {
    private static final Log _log = LogFactoryUtil.getLog(ResourceBundleInfoLocalizedValue.class);
    private final Class<?> _class;
    private final String _symbolicName;
    private final String _valueKey;

    public ResourceBundleInfoLocalizedValue(Class<?> clazz, String valueKey) {
        this._class = clazz;
        this._valueKey = valueKey;
        this._symbolicName = null;
    }

    public ResourceBundleInfoLocalizedValue(String symbolicName, String valueKey) {
        this._symbolicName = symbolicName;
        this._valueKey = valueKey;
        this._class = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourceBundleInfoLocalizedValue)) {
            return false;
        }
        ResourceBundleInfoLocalizedValue resourceBundleInfoLocalizedValue = (ResourceBundleInfoLocalizedValue)object;
        return Objects.equals(resourceBundleInfoLocalizedValue._valueKey, this._valueKey);
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return LanguageUtil.getAvailableLocales();
    }

    @Override
    public Locale getDefaultLocale() {
        return LocaleUtil.getDefault();
    }

    @Override
    public String getValue() {
        return this.getValue(this.getDefaultLocale());
    }

    @Override
    public String getValue(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this._class != null ? ResourceBundleUtil.getBundle((Locale)locale, this._class) : ResourceBundleUtil.getBundle((Locale)locale, (String)this._symbolicName);
        }
        catch (MissingResourceException missingResourceException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reverting to default resource bundle because no resource bundle could be found with " + locale), (Throwable)missingResourceException);
            }
            return LanguageUtil.get((Locale)locale, (String)this._valueKey);
        }
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)this._valueKey);
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this._valueKey);
    }
}

