/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.display.contributor.field;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoConverterUtil;
import com.liferay.info.display.contributor.field.InfoDisplayContributorField;
import com.liferay.info.display.contributor.field.InfoDisplayContributorFieldType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class ExpandoInfoDisplayContributorField
implements InfoDisplayContributorField<Object> {
    private static final String _CUSTOM_FIELD_PREFIX = "_CUSTOM_FIELD_";
    private static final Log _log = LogFactoryUtil.getLog(ExpandoInfoDisplayContributorField.class);
    private final String _attributeName;
    private final ExpandoBridge _expandoBridge;

    public ExpandoInfoDisplayContributorField(String attributeName, ExpandoBridge expandoBridge) {
        this._attributeName = attributeName;
        this._expandoBridge = expandoBridge;
    }

    @Override
    public String getKey() {
        return _CUSTOM_FIELD_PREFIX + this._attributeName.replaceAll("\\W", "_");
    }

    @Override
    public String getLabel(Locale locale) {
        return this._attributeName;
    }

    @Override
    public InfoDisplayContributorFieldType getType() {
        return InfoDisplayContributorFieldType.TEXT;
    }

    @Override
    public Object getValue(Object model, Locale locale) {
        if (!(model instanceof ClassedModel)) {
            return this._expandoBridge.getAttributeDefault(this._attributeName);
        }
        ClassedModel classedModel = (ClassedModel)model;
        this._expandoBridge.setClassPK(GetterUtil.getLong((Object)classedModel.getPrimaryKeyObj()));
        Object attributeValue = this._expandoBridge.getAttribute(this._attributeName, false);
        if (Validator.isNull((Object)attributeValue)) {
            return this._expandoBridge.getAttributeDefault(this._attributeName);
        }
        int attributeType = this._expandoBridge.getAttributeType(this._attributeName);
        if (attributeType == 2) {
            return StringUtil.merge((Object[])ArrayUtil.toStringArray((boolean[])((boolean[])attributeValue)), (String)", ");
        }
        if (attributeType == 3) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, locale);
            return dateFormat.format((Date)attributeValue);
        }
        if (attributeType == 6) {
            return StringUtil.merge((Object[])ArrayUtil.toStringArray((double[])((double[])attributeValue)), (String)", ");
        }
        if (attributeType == 8) {
            return StringUtil.merge((Object[])ArrayUtil.toStringArray((float[])((float[])attributeValue)), (String)", ");
        }
        if (attributeType == 21) {
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)attributeValue.toString());
                StringBundler sb = new StringBundler(3);
                sb.append(jsonObject.get("latitude"));
                sb.append(", ");
                sb.append(jsonObject.get("longitude"));
                attributeValue = sb.toString();
            }
            catch (JSONException jsonException) {
                _log.error((Object)"Unable to parse geolocation JSON", (Throwable)jsonException);
            }
        } else {
            if (attributeType == 10) {
                return StringUtil.merge((Object[])ArrayUtil.toStringArray((int[])((int[])attributeValue)), (String)", ");
            }
            if (attributeType == 12) {
                return StringUtil.merge((Object[])ArrayUtil.toStringArray((long[])((long[])attributeValue)), (String)", ");
            }
            if (attributeType == 18) {
                return StringUtil.merge((Object[])ArrayUtil.toStringArray((double[])((double[])attributeValue)), (String)", ");
            }
            if (attributeType == 14) {
                return StringUtil.merge((Object[])ArrayUtil.toStringArray((short[])((short[])attributeValue)), (String)", ");
            }
            if (attributeType == 16) {
                return StringUtil.merge((Object[])ArrayUtil.toStringArray((Object[])((String[])attributeValue)), (String)", ");
            }
            if (attributeType == 19) {
                Map values = (Map)attributeValue;
                Map defaultValues = (Map)((Object)this._expandoBridge.getAttributeDefault(this._attributeName));
                attributeValue = (Serializable)values.getOrDefault(locale, defaultValues.get(locale));
            } else if (attributeType == 20) {
                Map values = (Map)attributeValue;
                Map defaultValues = (Map)((Object)this._expandoBridge.getAttributeDefault(this._attributeName));
                if ((attributeValue = (Serializable)values.getOrDefault(locale, defaultValues.get(locale))) == null) {
                    return "";
                }
                return attributeValue;
            }
        }
        return ExpandoConverterUtil.getStringFromAttribute((int)attributeType, (Serializable)attributeValue);
    }
}

