/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.pagination;

import com.liferay.info.pagination.Pagination;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class InfoPage<T> {
    private final List<? extends T> _pageItems;
    private final Pagination _pagination;
    private final Supplier<Integer> _totalCountSupplier;

    public static <T> InfoPage<T> of(List<? extends T> pageItems) {
        return new InfoPage<T>(pageItems);
    }

    public static <T> InfoPage<T> of(List<? extends T> pageItems, Pagination pagination, int totalCount) {
        return new InfoPage<T>(pageItems, pagination, totalCount);
    }

    public static <T> InfoPage<T> of(List<? extends T> pageItems, Pagination pagination, Supplier<Integer> totalCountSupplier) {
        return new InfoPage<T>(pageItems, pagination, totalCountSupplier);
    }

    public List<? extends T> getPageItems() {
        return this._pageItems;
    }

    public int getTotalCount() {
        return this._totalCountSupplier.get();
    }

    public boolean hasNext() {
        return this._pagination.getEnd() < this.getTotalCount();
    }

    public boolean hasPrevious() {
        return this._pagination.getStart() > 1;
    }

    private InfoPage(List<? extends T> pageItems) {
        this(pageItems, Pagination.of(0, pageItems.size()), pageItems::size);
    }

    private InfoPage(List<? extends T> pageItems, Pagination pagination, int totalCount) {
        this(pageItems, pagination, () -> totalCount);
    }

    private InfoPage(List<? extends T> pageItems, Pagination pagination, Supplier<Integer> totalCountSupplier) {
        this._pageItems = pageItems;
        this._pagination = pagination;
        this._totalCountSupplier = this._getCachedSupplier(totalCountSupplier);
    }

    private Supplier<Integer> _getCachedSupplier(Supplier<Integer> supplier) {
        AtomicReference atomicReference = new AtomicReference();
        return () -> {
            if (atomicReference.get() != null) {
                return (Integer)atomicReference.get();
            }
            Integer result = (Integer)supplier.get();
            atomicReference.set(result);
            return result;
        };
    }
}

