/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.localized;

import com.liferay.info.localized.SingleValueInfoLocalizedValue;
import com.liferay.info.localized.bundle.FunctionInfoLocalizedValue;
import com.liferay.info.localized.bundle.ModelResourceLocalizedValue;
import com.liferay.info.localized.bundle.ResourceBundleInfoLocalizedValue;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public interface InfoLocalizedValue<T> {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static InfoLocalizedValue<?> function(Function<Locale, ?> function) {
        return new FunctionInfoLocalizedValue(function);
    }

    public static InfoLocalizedValue<String> localize(Class<?> clazz, String valueKey) {
        return new ResourceBundleInfoLocalizedValue(clazz, valueKey);
    }

    public static InfoLocalizedValue<String> localize(String symbolicName, String valueKey) {
        return new ResourceBundleInfoLocalizedValue(symbolicName, valueKey);
    }

    public static InfoLocalizedValue<String> modelResource(String name) {
        return new ModelResourceLocalizedValue(name);
    }

    public static InfoLocalizedValue<String> singleValue(String value) {
        return new SingleValueInfoLocalizedValue<String>(value);
    }

    public Set<Locale> getAvailableLocales();

    public Locale getDefaultLocale();

    public T getValue();

    public T getValue(Locale var1);

    public static class BuilderInfoLocalizedValue<T>
    implements InfoLocalizedValue<T> {
        private final Builder<T> _builder;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BuilderInfoLocalizedValue)) {
                return false;
            }
            BuilderInfoLocalizedValue builderInfoLocalizedValue = (BuilderInfoLocalizedValue)object;
            return Objects.equals(((Builder)this._builder)._defaultLocale, ((Builder)builderInfoLocalizedValue._builder)._defaultLocale) && Objects.equals(((Builder)this._builder)._values, ((Builder)builderInfoLocalizedValue._builder)._values);
        }

        @Override
        public Set<Locale> getAvailableLocales() {
            return ((Builder)this._builder)._values.keySet();
        }

        @Override
        public Locale getDefaultLocale() {
            if (((Builder)this._builder)._defaultLocale == null) {
                return LocaleUtil.getSiteDefault();
            }
            return ((Builder)this._builder)._defaultLocale;
        }

        @Override
        public T getValue() {
            return (T)((Builder)this._builder)._values.get(this.getDefaultLocale());
        }

        @Override
        public T getValue(Locale locale) {
            Object value = ((Builder)this._builder)._values.get(locale);
            if (value == null) {
                value = ((Builder)this._builder)._values.get(this.getDefaultLocale());
            }
            if (value instanceof String) {
                value = LanguageUtil.get((Locale)locale, (String)((String)value));
            }
            return (T)value;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)((Builder)this._builder)._defaultLocale);
            return HashUtil.hash((int)hash, (Object)((Builder)this._builder)._values);
        }

        private BuilderInfoLocalizedValue(Builder<T> builder) {
            this._builder = builder;
        }
    }

    public static class Builder<T> {
        private Locale _defaultLocale;
        private final Map<Locale, T> _values = new HashMap<Locale, T>();

        public InfoLocalizedValue<T> build() {
            return new BuilderInfoLocalizedValue(this);
        }

        public Builder<T> defaultLocale(Locale locale) {
            this._defaultLocale = locale;
            return this;
        }

        public Builder<T> value(Locale locale, T value) {
            this._values.put(locale, value);
            return this;
        }

        public <E extends Throwable> Builder<T> value(UnsafeConsumer<UnsafeBiConsumer<Locale, T, E>, E> biConsumer) throws E {
            biConsumer.accept(this::value);
            return this;
        }

        public Builder<T> values(Map<Locale, T> values) {
            this._values.putAll(values);
            return this;
        }

        private Builder() {
        }
    }
}

