/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.info.field.type;

/**
 * @author Eudaldo Alonso
 */
public class FileInfoFieldType implements InfoFieldType {

	public static final Attribute<FileInfoFieldType, String>
		ALLOWED_FILE_EXTENSIONS = new Attribute<>();

	public static final Attribute<FileInfoFieldType, FileSourceType>
		FILE_SOURCE = new Attribute<>();

	public static final FileInfoFieldType INSTANCE = new FileInfoFieldType();

	public static final Attribute<FileInfoFieldType, Long> MAX_FILE_SIZE =
		new Attribute<>();

	@Override
	public String getName() {
		return "file";
	}

	public enum FileSourceType {

		DOCUMENTS_AND_MEDIA, USER_COMPUTER

	}

	private FileInfoFieldType() {
	}

}