/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.item;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemReference;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InfoItemFieldValues {
    private final Builder _builder;

    public static Builder builder() {
        return new Builder();
    }

    public InfoFieldValue<Object> getInfoFieldValue(String infoFieldName) {
        Iterator iterator;
        Collection infoFieldValues = this._builder._infoFieldValuesByIdMap.getOrDefault(infoFieldName, Collections.emptyList());
        if (infoFieldValues.isEmpty()) {
            infoFieldValues = this._builder._infoFieldValuesByNameMap.getOrDefault(infoFieldName, Collections.emptyList());
        }
        if (infoFieldValues != null && (iterator = infoFieldValues.iterator()).hasNext()) {
            return (InfoFieldValue)iterator.next();
        }
        return null;
    }

    public Collection<InfoFieldValue<Object>> getInfoFieldValues() {
        return this._builder._infoFieldValues;
    }

    public Collection<InfoFieldValue<Object>> getInfoFieldValues(String infoFieldName) {
        Collection infoFieldValues = this._builder._infoFieldValuesByIdMap.getOrDefault(infoFieldName, Collections.emptyList());
        if (!infoFieldValues.isEmpty()) {
            return infoFieldValues;
        }
        return this._builder._infoFieldValuesByNameMap.getOrDefault(infoFieldName, Collections.emptyList());
    }

    public InfoItemReference getInfoItemReference() {
        return this._builder._infoItemReference;
    }

    public Map<String, Object> getMap(Locale locale) {
        HashMap<String, Object> map = new HashMap<String, Object>(this._builder._infoFieldValues.size());
        for (InfoFieldValue infoFieldValue : this._builder._infoFieldValues) {
            InfoField infoField = infoFieldValue.getInfoField();
            map.put(infoField.getName(), infoFieldValue.getValue(locale));
            map.put(infoField.getUniqueId(), infoFieldValue.getValue(locale));
        }
        return map;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{infoFieldValues: ", this._builder._infoFieldValues, "}"});
    }

    private InfoItemFieldValues(Builder builder) {
        this._builder = builder;
    }

    public static class Builder {
        private final Collection<InfoFieldValue<Object>> _infoFieldValues = new LinkedHashSet<InfoFieldValue<Object>>();
        private final Map<String, Collection<InfoFieldValue<Object>>> _infoFieldValuesByIdMap = new HashMap<String, Collection<InfoFieldValue<Object>>>();
        private final Map<String, Collection<InfoFieldValue<Object>>> _infoFieldValuesByNameMap = new HashMap<String, Collection<InfoFieldValue<Object>>>();
        private InfoItemReference _infoItemReference;

        public InfoItemFieldValues build() {
            return new InfoItemFieldValues(this);
        }

        public Builder infoFieldValue(InfoFieldValue<Object> infoFieldValue) {
            if (infoFieldValue == null) {
                return this;
            }
            this._infoFieldValues.add(infoFieldValue);
            InfoField infoField = infoFieldValue.getInfoField();
            Collection infoFieldValues = this._infoFieldValuesByNameMap.computeIfAbsent(infoField.getName(), key -> new ArrayList());
            infoFieldValues.add(infoFieldValue);
            infoFieldValues = this._infoFieldValuesByIdMap.computeIfAbsent(infoField.getUniqueId(), key -> new ArrayList());
            infoFieldValues.add(infoFieldValue);
            return this;
        }

        public <T extends Throwable> Builder infoFieldValue(UnsafeConsumer<UnsafeConsumer<InfoFieldValue<Object>, T>, T> unsafeConsumer) throws T {
            unsafeConsumer.accept(this::infoFieldValue);
            return this;
        }

        public Builder infoFieldValues(List<InfoFieldValue<Object>> infoFieldValues) {
            for (InfoFieldValue<Object> infoFieldValue : infoFieldValues) {
                this.infoFieldValue(infoFieldValue);
            }
            return this;
        }

        public Builder infoItemReference(InfoItemReference infoItemReference) {
            this._infoItemReference = infoItemReference;
            return this;
        }
    }
}

