/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.form;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class InfoForm {
    private final Builder _builder;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InfoForm)) {
            return false;
        }
        InfoForm infoForm = (InfoForm)object;
        return Objects.equals(this._builder._descriptionInfoLocalizedValue, infoForm._builder._descriptionInfoLocalizedValue) && Objects.equals(this._builder._labelInfoLocalizedValue, infoForm._builder._labelInfoLocalizedValue) && Objects.equals(this._builder._name, infoForm._builder._name);
    }

    public List<InfoField<?>> getAllInfoFields() {
        return new ArrayList(this._builder._infoFieldsByUniqueId.values());
    }

    public InfoLocalizedValue<String> getDescriptionInfoLocalizedValue() {
        return this._builder._descriptionInfoLocalizedValue;
    }

    public InfoField<?> getInfoField(String name) {
        InfoField infoField = (InfoField)this._builder._infoFieldsByUniqueId.get(name);
        if (infoField != null) {
            return infoField;
        }
        return (InfoField)this._builder._infoFieldsByName.get(name);
    }

    public List<InfoFieldSetEntry> getInfoFieldSetEntries() {
        return new ArrayList<InfoFieldSetEntry>(this._builder._infoFieldSetEntriesByName.values());
    }

    public InfoFieldSetEntry getInfoFieldSetEntry(String name) {
        return (InfoFieldSetEntry)this._builder._infoFieldSetEntriesByName.get(name);
    }

    public String getLabel(Locale locale) {
        if (this._builder._labelInfoLocalizedValue == null) {
            return this._builder._name;
        }
        return (String)this._builder._labelInfoLocalizedValue.getValue(locale);
    }

    public InfoLocalizedValue<String> getLabelInfoLocalizedValue() {
        return this._builder._labelInfoLocalizedValue;
    }

    public String getName() {
        return this._builder._name;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._builder._descriptionInfoLocalizedValue);
        hash = HashUtil.hash((int)hash, (Object)this._builder._labelInfoLocalizedValue);
        return HashUtil.hash((int)hash, (Object)this._builder._name);
    }

    public String toString() {
        return StringBundler.concat((String[])new String[]{"{_infoFieldSetEntriesByName: ", MapUtil.toString((Map)this._builder._infoFieldSetEntriesByName), ", name: ", this._builder._name, "}"});
    }

    private InfoForm(Builder builder) {
        this._builder = builder;
    }

    public static class Builder {
        private InfoLocalizedValue<String> _descriptionInfoLocalizedValue;
        private final Map<String, InfoField<?>> _infoFieldsByName = new LinkedHashMap();
        private final Map<String, InfoField<?>> _infoFieldsByUniqueId = new LinkedHashMap();
        private final Map<String, InfoFieldSetEntry> _infoFieldSetEntriesByName = new LinkedHashMap<String, InfoFieldSetEntry>();
        private InfoLocalizedValue<String> _labelInfoLocalizedValue;
        private String _name;

        public InfoForm build() {
            return new InfoForm(this);
        }

        public Builder descriptionInfoLocalizedValue(InfoLocalizedValue<String> descriptionInfoLocalizedValue) {
            this._descriptionInfoLocalizedValue = descriptionInfoLocalizedValue;
            return this;
        }

        public Builder infoFieldSetEntries(Collection<InfoFieldSetEntry> infoFieldSetEntries) {
            for (InfoFieldSetEntry infoFieldSetEntry : infoFieldSetEntries) {
                this.infoFieldSetEntry(infoFieldSetEntry);
            }
            return this;
        }

        public Builder infoFieldSetEntry(InfoFieldSet infoFieldSet) {
            InfoFieldSetEntry existingInfoFieldSetEntry = this._infoFieldSetEntriesByName.get(infoFieldSet.getName());
            if (existingInfoFieldSetEntry instanceof InfoFieldSet) {
                InfoFieldSet existingInfoFieldSet = (InfoFieldSet)existingInfoFieldSetEntry;
                this._infoFieldSetEntriesByName.put(infoFieldSet.getName(), InfoFieldSet.builder().infoFieldSetEntries(existingInfoFieldSet.getInfoFieldSetEntries()).infoFieldSetEntries(infoFieldSet.getInfoFieldSetEntries()).labelInfoLocalizedValue(existingInfoFieldSet.getLabelInfoLocalizedValue()).name(existingInfoFieldSet.getName()).build());
            } else {
                this._infoFieldSetEntriesByName.put(infoFieldSet.getName(), infoFieldSet);
            }
            this._populateInfoFieldsMaps(infoFieldSet);
            return this;
        }

        public Builder infoFieldSetEntry(InfoFieldSetEntry infoFieldSetEntry) {
            this._infoFieldSetEntriesByName.put(infoFieldSetEntry.getName(), infoFieldSetEntry);
            this._populateInfoFieldsMaps(infoFieldSetEntry);
            return this;
        }

        public <T extends Throwable> Builder infoFieldSetEntry(UnsafeConsumer<UnsafeConsumer<InfoFieldSetEntry, T>, T> unsafeConsumer) throws T {
            unsafeConsumer.accept(this::infoFieldSetEntry);
            return this;
        }

        public Builder labelInfoLocalizedValue(InfoLocalizedValue<String> labelInfoLocalizedValue) {
            this._labelInfoLocalizedValue = labelInfoLocalizedValue;
            return this;
        }

        public Builder name(String name) {
            this._name = name;
            return this;
        }

        private void _populateInfoFieldsMaps(InfoFieldSetEntry infoFieldSetEntry) {
            if (infoFieldSetEntry == null) {
                return;
            }
            if (infoFieldSetEntry instanceof InfoField) {
                this._infoFieldsByName.put(infoFieldSetEntry.getName(), (InfoField)infoFieldSetEntry);
                this._infoFieldsByUniqueId.put(infoFieldSetEntry.getUniqueId(), (InfoField)infoFieldSetEntry);
                return;
            }
            InfoFieldSet infoFieldSet = (InfoFieldSet)infoFieldSetEntry;
            for (InfoField<?> infoField : infoFieldSet.getAllInfoFields()) {
                this._infoFieldsByName.put(infoField.getName(), infoField);
                this._infoFieldsByUniqueId.put(infoField.getUniqueId(), infoField);
            }
        }
    }
}

