/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.exception;

import com.liferay.info.exception.InfoFormException;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;

public class InfoFormValidationException
extends InfoFormException {
    private final String _infoFieldUniqueId;

    public InfoFormValidationException() {
        this._infoFieldUniqueId = "";
    }

    public InfoFormValidationException(String infoFieldUniqueId) {
        this._infoFieldUniqueId = infoFieldUniqueId;
    }

    public String getInfoFieldUniqueId() {
        return this._infoFieldUniqueId;
    }

    public String getLocalizedMessage(String fieldLabel, Locale locale) {
        return LanguageUtil.format((Locale)locale, (String)"x-an-error-occurred", (Object)fieldLabel, (boolean)false);
    }

    public static class RequiredInfoField
    extends InfoFormValidationException {
        public RequiredInfoField(String infoFieldUniqueId) {
            super(infoFieldUniqueId);
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"this-field-is-required");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"the-x-is-required", (Object)fieldLabel, (boolean)false);
        }
    }

    public static class InvalidInfoFieldValue
    extends InfoFormValidationException {
        public InvalidInfoFieldValue(String infoFieldUniqueId) {
            super(infoFieldUniqueId);
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"this-field-is-invalid");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"the-x-is-invalid", (Object)fieldLabel, (boolean)false);
        }
    }

    public static class InvalidFileExtension
    extends InfoFormValidationException {
        private final String _validFileExtensions;

        public InvalidFileExtension(String infoFieldUniqueId, String validFileExtensions) {
            super(infoFieldUniqueId);
            this._validFileExtensions = validFileExtensions;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"please-enter-a-file-with-a-valid-extension-x", (Object)this._validFileExtensions);
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"x-please-enter-a-file-with-a-valid-extension-x", (Object[])new String[]{fieldLabel, this._validFileExtensions}, (boolean)false);
        }

        public String getValidFileExtensions() {
            return this._validFileExtensions;
        }
    }

    public static class InvalidCaptcha
    extends InfoFormValidationException {
        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"captcha-verification-failed");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return this.getLocalizedMessage(locale);
        }
    }

    public static class FileSize
    extends InfoFormValidationException {
        private final String _maximumSizeAllowed;

        public FileSize(String infoFieldUniqueId, String maximumSizeAllowed) {
            super(infoFieldUniqueId);
            this._maximumSizeAllowed = maximumSizeAllowed;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"file-size-is-larger-than-the-allowed-overall-maximum-upload-request-size-x", (Object)this._maximumSizeAllowed);
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"x-file-size-is-larger-than-the-allowed-maximum-upload-size-x", (Object[])new String[]{fieldLabel, this._maximumSizeAllowed}, (boolean)false);
        }

        public String getMaximumSizeAllowed() {
            return this._maximumSizeAllowed;
        }
    }

    public static class ExceedsMinValue
    extends InvalidInfoFieldValue {
        private final long _minValue;

        public ExceedsMinValue(String infoFieldUniqueId, long minValue) {
            super(infoFieldUniqueId);
            this._minValue = minValue;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"value-falls-bellow-the-minimum-value-of-x");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"value-falls-bellow-the-minimum-value-of-x-for-field-x", (Object[])new String[]{String.valueOf(this._minValue), fieldLabel}, (boolean)false);
        }
    }

    public static class ExceedsMaxValue
    extends InvalidInfoFieldValue {
        private final long _maxValue;

        public ExceedsMaxValue(String infoFieldUniqueId, long maxValue) {
            super(infoFieldUniqueId);
            this._maxValue = maxValue;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"value-exceeds-maximum-value-of-x");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"value-exceeds-maximum-value-of-x-for-field-x", (Object[])new String[]{String.valueOf(this._maxValue), fieldLabel}, (boolean)false);
        }
    }

    public static class ExceedsMaxLength
    extends InvalidInfoFieldValue {
        private final int _maxLength;

        public ExceedsMaxLength(String infoFieldUniqueId, int maxLength) {
            super(infoFieldUniqueId);
            this._maxLength = maxLength;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            return LanguageUtil.get((Locale)locale, (String)"value-exceeds-maximum-length-of-x");
        }

        @Override
        public String getLocalizedMessage(String fieldLabel, Locale locale) {
            return LanguageUtil.format((Locale)locale, (String)"value-exceeds-maximum-length-of-x-for-field-x", (Object[])new String[]{String.valueOf(this._maxLength), fieldLabel}, (boolean)false);
        }
    }

    public static class CustomValidation
    extends InfoFormValidationException {
        private final String _message;

        public CustomValidation(String message) {
            this._message = message;
        }

        @Override
        public String getLocalizedMessage(Locale locale) {
            if (this._message != null) {
                return this._message;
            }
            return super.getLocalizedMessage(locale);
        }
    }
}

