/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.field;

import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InfoField<T extends InfoFieldType>
implements InfoFieldSetEntry {
    private final Builder _builder;

    public static Builder builder() {
        return new Builder();
    }

    public static NamespacedBuilder builder(String namespace) {
        return new NamespacedBuilder(namespace);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InfoField)) {
            return false;
        }
        InfoField infoField = (InfoField)object;
        return Objects.equals(this._builder._infoFieldType, infoField._builder._infoFieldType) && Objects.equals(this._builder._labelInfoLocalizedValue, infoField._builder._labelInfoLocalizedValue) && Objects.equals(this._builder._name, infoField._builder._name);
    }

    public <V> Optional<V> getAttributeOptional(InfoFieldType.Attribute<T, V> attribute) {
        return Optional.ofNullable(this._builder._attributes.get(attribute));
    }

    public InfoFieldType getInfoFieldType() {
        return this._builder._infoFieldType;
    }

    @Override
    public String getLabel(Locale locale) {
        return (String)this._builder._labelInfoLocalizedValue.getValue(locale);
    }

    @Override
    public InfoLocalizedValue<String> getLabelInfoLocalizedValue() {
        return this._builder._labelInfoLocalizedValue;
    }

    @Override
    public String getName() {
        return this._builder._name;
    }

    @Override
    public String getUniqueId() {
        return this._builder._uniqueId;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (Object)this._builder._infoFieldType);
        hash = HashUtil.hash((int)hash, (Object)this._builder._labelInfoLocalizedValue);
        return HashUtil.hash((int)hash, (Object)this._builder._name);
    }

    public boolean isEditable() {
        return this._builder._editable;
    }

    public boolean isLocalizable() {
        return this._builder._localizable;
    }

    public boolean isMultivalued() {
        return this._builder._multivalued;
    }

    public boolean isRequired() {
        return this._builder._required;
    }

    public String toString() {
        return StringBundler.concat((String[])new String[]{"{name: ", this._builder._name, ", type: ", this._builder._infoFieldType.getName(), ", uniqueId: ", this._builder._uniqueId, "}"});
    }

    private InfoField(Builder builder) {
        this._builder = builder;
    }

    public static class NameStep<T extends InfoFieldType> {
        private final Builder _builder;

        public FinalStep<T> name(String name) {
            this._builder._name = name;
            if (Validator.isNull((String)this._builder._uniqueId)) {
                this._builder._uniqueId = this._builder._namespace + "_" + name;
            }
            return new FinalStep(this._builder);
        }

        private NameStep(Builder builder) {
            this._builder = builder;
        }
    }

    public static class NamespaceStep<T extends InfoFieldType> {
        private final Builder _builder;

        public NameStep<T> namespace(String namespace) {
            this._builder._namespace = namespace;
            return new NameStep(this._builder);
        }

        public NameStep<T> uniqueId(String uniqueId) {
            this._builder._uniqueId = uniqueId;
            return new NameStep(this._builder);
        }

        private NamespaceStep(Builder builder) {
            this._builder = builder;
        }
    }

    public static class NamespacedBuilder {
        private final String _namespace;

        public <T extends InfoFieldType> NameStep<T> infoFieldType(T infoFieldType) {
            Builder builder = new Builder();
            return builder.infoFieldType(infoFieldType).namespace(this._namespace);
        }

        private NamespacedBuilder(String namespace) {
            this._namespace = namespace;
        }
    }

    public static class FinalStep<T extends InfoFieldType> {
        private final Builder _builder;

        public <V> FinalStep<T> attribute(InfoFieldType.Attribute<T, V> attribute, V value) {
            this._builder._attributes.put(attribute, value);
            return this;
        }

        public InfoField<T> build() {
            if (this._builder._labelInfoLocalizedValue == null) {
                this._builder._labelInfoLocalizedValue = InfoLocalizedValue.localize(InfoField.class, this._builder._name);
            }
            return new InfoField(this._builder);
        }

        public FinalStep<T> editable(boolean editable) {
            this._builder._editable = editable;
            return this;
        }

        public FinalStep<T> labelInfoLocalizedValue(InfoLocalizedValue<String> labelInfoLocalizedValue) {
            this._builder._labelInfoLocalizedValue = labelInfoLocalizedValue;
            return this;
        }

        public FinalStep<T> localizable(boolean localizable) {
            this._builder._localizable = localizable;
            return this;
        }

        public FinalStep<T> multivalued(boolean multivalued) {
            this._builder._multivalued = multivalued;
            return this;
        }

        public FinalStep<T> required(boolean required) {
            this._builder._required = required;
            return this;
        }

        private FinalStep(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private final Map<InfoFieldType.Attribute<? extends InfoFieldType, ?>, Object> _attributes = new HashMap();
        private boolean _editable;
        private InfoFieldType _infoFieldType;
        private InfoLocalizedValue<String> _labelInfoLocalizedValue;
        private boolean _localizable;
        private boolean _multivalued;
        private String _name;
        private String _namespace;
        private boolean _required;
        private String _uniqueId;

        public <T extends InfoFieldType> NamespaceStep<T> infoFieldType(T infoFieldType) {
            this._infoFieldType = infoFieldType;
            return new NamespaceStep(this);
        }

        private Builder() {
        }
    }
}

