/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.image.uploader.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.image.uploader.web.internal.util.UploadImageUtil;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_image_uploader_web_portlet_ImageUploaderPortlet", "mvc.command.name=/image_uploader/view"}, service={MVCResourceCommand.class})
public class UploadImageMVCResourceCommand
extends BaseMVCResourceCommand {
    private static final Log _log = LogFactoryUtil.getLog(UploadImageMVCResourceCommand.class);

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
            if (cmd.equals("get_temp")) {
                FileEntry tempFileEntry = UploadImageUtil.getTempImageFileEntry((PortletRequest)resourceRequest);
                FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)tempFileEntry.getContentStream());
                if (flashMagicBytesUtilResult.isFlash()) {
                    return;
                }
                this.serveTempImageFile((MimeResponse)resourceResponse, flashMagicBytesUtilResult.getInputStream());
            }
        }
        catch (NoSuchFileEntryException nsfee) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to serve resource", (Throwable)e);
        }
    }

    protected void serveTempImageFile(MimeResponse mimeResponse, InputStream tempImageStream) throws Exception {
        ImageBag imageBag = ImageToolUtil.read((InputStream)tempImageStream);
        byte[] bytes = ImageToolUtil.getBytes((RenderedImage)imageBag.getRenderedImage(), (String)imageBag.getType());
        String contentType = MimeTypesUtil.getExtensionContentType((String)imageBag.getType());
        mimeResponse.setContentType(contentType);
        PortletResponseUtil.write((MimeResponse)mimeResponse, (byte[])bytes);
    }
}

