/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.iframe.web.internal.portlet.action;

import com.liferay.iframe.web.internal.util.IFrameUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_iframe_web_portlet_IFramePortlet"}, service={ConfigurationAction.class})
public class IFrameConfigurationAction
extends DefaultConfigurationAction {
    @Reference
    private Http _http;

    public String getJspPath(HttpServletRequest httpServletRequest) {
        return "/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] htmlAttributes;
        String src = this.getParameter((PortletRequest)actionRequest, "src");
        if (!(src.startsWith("/") || StringUtil.startsWith((String)src, (String)"http://") || StringUtil.startsWith((String)src, (String)"https://") || StringUtil.startsWith((String)src, (String)"mhtml://"))) {
            src = this._http.getProtocol(actionRequest) + "://" + src;
            this.setPreference((PortletRequest)actionRequest, "src", src);
        }
        for (String htmlAttribute : htmlAttributes = StringUtil.splitLines((String)this.getParameter((PortletRequest)actionRequest, "htmlAttributes"))) {
            int pos = htmlAttribute.indexOf(61);
            if (pos == -1) continue;
            String key = htmlAttribute.substring(0, pos);
            String value = htmlAttribute.substring(pos + 1);
            this.setPreference((PortletRequest)actionRequest, key, value);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.iframe.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void postProcess(long companyId, PortletRequest portletRequest, PortletPreferences portletPreferences) throws PortalException {
        String formPassword = portletPreferences.getValue("formPassword", "");
        if (Validator.isNotNull((String)formPassword) && formPassword.contains("@password@") && !IFrameUtil.isPasswordTokenEnabled(portletRequest)) {
            formPassword = formPassword.replaceAll("@password@", "");
            try {
                portletPreferences.setValue("formPassword", formPassword);
            }
            catch (ReadOnlyException roe) {
                throw new PortalException((Throwable)roe);
            }
        }
    }
}

