/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.iframe.web.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletRequest;

public class IFrameUtil {
    private static final Log _log = LogFactoryUtil.getLog(IFrameUtil.class);

    public static String getPassword(PortletRequest portletRequest, String password) throws PortalException {
        if (Validator.isNotNull((String)password) && password.equals("@password@") && IFrameUtil.isPasswordTokenResolutionEnabled(portletRequest)) {
            password = PortalUtil.getUserPassword((PortletRequest)portletRequest);
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    public static String getUserName(PortletRequest portletRequest, String userName) throws PortalException {
        User user = PortalUtil.getUser((PortletRequest)portletRequest);
        if (user == null) {
            return userName;
        }
        if (Validator.isNull((String)userName) || userName.equals("@user_id@")) {
            userName = portletRequest.getRemoteUser();
        } else if (userName.equals("@email_address@")) {
            userName = user.getEmailAddress();
        } else if (userName.equals("@screen_name@")) {
            userName = user.getScreenName();
        }
        return userName;
    }

    public static boolean isPasswordTokenEnabled(PortletRequest portletRequest) throws PortalException {
        block6: {
            if (!PropsValues.SESSION_STORE_PASSWORD) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            Group layoutGroup = layout.getGroup();
            String roleName = PropsValues.IFRAME_PASSWORD_PASSWORD_TOKEN_ROLE;
            if (layout.isPrivateLayout() && layoutGroup.isUser() && themeDisplay.getRealUserId() == layoutGroup.getClassPK()) {
                return true;
            }
            if (Validator.isNull((String)roleName)) {
                return false;
            }
            try {
                Role role = RoleLocalServiceUtil.getRole((long)themeDisplay.getCompanyId(), (String)roleName);
                if (UserLocalServiceUtil.hasRoleUser((long)role.getRoleId(), (long)themeDisplay.getUserId())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Error getting role ", roleName, ". The password token will be disabled."}));
            }
        }
        return false;
    }

    public static boolean isPasswordTokenResolutionEnabled(PortletRequest portletRequest) throws PortalException {
        if (!PropsValues.SESSION_STORE_PASSWORD) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        Group layoutGroup = layout.getGroup();
        return !layout.isPrivateLayout() || !layoutGroup.isUser() || themeDisplay.getRealUserId() == layoutGroup.getClassPK();
    }
}

