/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.iframe.web.internal.display.context;

import com.liferay.iframe.web.configuration.IFramePortletInstanceConfiguration;
import com.liferay.iframe.web.internal.util.IFrameUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;

public class IFrameDisplayContext {
    private static final String _IFRAME_PREFIX = "iframe_";
    private String _authType;
    private String _formMethod;
    private String _height;
    private String _hiddenVariables;
    private String _iFrameBaseSrc;
    private final IFramePortletInstanceConfiguration _iFramePortletInstanceConfiguration;
    private String _iFrameSrc;
    private String _password;
    private final PortletRequest _request;
    private final ThemeDisplay _themeDisplay;
    private String _userName;

    public IFrameDisplayContext(PortletRequest request) throws ConfigurationException {
        this._request = request;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        this._iFramePortletInstanceConfiguration = (IFramePortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(IFramePortletInstanceConfiguration.class);
    }

    public String getAuthType() {
        if (this._authType != null) {
            return this._authType;
        }
        this._authType = this._iFramePortletInstanceConfiguration.authType();
        return this._authType;
    }

    public String getFormMethod() {
        if (this._formMethod != null) {
            return this._formMethod;
        }
        this._formMethod = this._iFramePortletInstanceConfiguration.formMethod();
        return this._formMethod;
    }

    public String getHeight() {
        if (this._height != null) {
            return this._height;
        }
        String windowState = String.valueOf(this._request.getWindowState());
        this._height = windowState.equals(WindowState.MAXIMIZED) ? this._iFramePortletInstanceConfiguration.heightMaximized() : this._iFramePortletInstanceConfiguration.heightNormal();
        return this._height;
    }

    public List<KeyValuePair> getHiddenVariableKVPs() {
        ArrayList<KeyValuePair> hiddenVariableKVPs = new ArrayList<KeyValuePair>();
        List hiddenVariables = ListUtil.toList((Object[])StringUtil.split((String)this.getHiddenVariables(), (char)';'));
        hiddenVariables.addAll(this.getIFrameVariables());
        for (String hiddenVariable : hiddenVariables) {
            String key = "";
            String value = "";
            int pos = hiddenVariable.indexOf("=");
            if (pos != -1) {
                key = hiddenVariable.substring(0, pos);
                value = hiddenVariable.substring(pos + 1);
            }
            hiddenVariableKVPs.add(new KeyValuePair(key, value));
        }
        return hiddenVariableKVPs;
    }

    public String getHiddenVariables() {
        if (this._hiddenVariables != null) {
            return this._hiddenVariables;
        }
        this._hiddenVariables = StringUtil.merge((Object[])this._iFramePortletInstanceConfiguration.hiddenVariables(), (String)"|");
        return this._hiddenVariables;
    }

    public String getIframeBaseSrc() {
        String s;
        if (this._iFrameBaseSrc != null) {
            return this._iFrameBaseSrc;
        }
        this._iFrameBaseSrc = this.getIframeSrc();
        int index = 0;
        if (this._iFrameBaseSrc.length() > 6 && (index = (s = this._iFrameBaseSrc.substring(7)).lastIndexOf("/")) != -1) {
            this._iFrameBaseSrc = this._iFrameBaseSrc.substring(0, index + 8);
        }
        return this._iFrameBaseSrc;
    }

    public IFramePortletInstanceConfiguration getIFramePortletInstanceConfiguration() {
        return this._iFramePortletInstanceConfiguration;
    }

    public String getIframeSrc() {
        if (this._iFrameSrc != null) {
            return this._iFrameSrc;
        }
        this._iFrameSrc = "";
        if (this._iFramePortletInstanceConfiguration.relative()) {
            this._iFrameSrc = this._themeDisplay.getPathContext();
        }
        this._iFrameSrc = this._iFrameSrc + (String)this._request.getAttribute("IFRAME_SRC");
        if (!ListUtil.isEmpty(this.getIFrameVariables())) {
            this._iFrameSrc = this._iFrameSrc.contains("?") ? this._iFrameSrc + "&" : this._iFrameSrc + "?";
            this._iFrameSrc = this._iFrameSrc + StringUtil.merge(this.getIFrameVariables(), (String)"&");
        }
        return this._iFrameSrc;
    }

    public List<String> getIFrameVariables() {
        ArrayList<String> iFrameVariables = new ArrayList<String>();
        Enumeration enu = this._request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(_IFRAME_PREFIX)) continue;
            iFrameVariables.add(name.substring(_IFRAME_PREFIX.length()) + "=" + this._request.getParameter(name));
        }
        return iFrameVariables;
    }

    public String getPassword() throws PortalException {
        int pos;
        if (this._password != null) {
            return this._password;
        }
        String authType = this.getAuthType();
        this._password = authType.equals("basic") ? this._iFramePortletInstanceConfiguration.basicPassword() : this._iFramePortletInstanceConfiguration.formPassword();
        if (Validator.isNull((String)this._password)) {
            return "";
        }
        String passwordField = this._iFramePortletInstanceConfiguration.passwordField();
        if (Validator.isNull((String)passwordField) && (pos = this._password.indexOf("=")) != -1) {
            String fieldValuePair = this._password;
            passwordField = fieldValuePair.substring(0, pos);
            this._password = fieldValuePair.substring(pos + 1);
        }
        if (Validator.isNotNull((String)passwordField)) {
            this._password = IFrameUtil.getPassword(this._request, this._password);
        }
        return this._password;
    }

    public String getUserName() throws PortalException {
        int pos;
        if (this._userName != null) {
            return this._userName;
        }
        String authType = this.getAuthType();
        this._userName = authType.equals("basic") ? this._iFramePortletInstanceConfiguration.basicUserName() : this._iFramePortletInstanceConfiguration.formUserName();
        if (Validator.isNull((String)this._userName)) {
            return "";
        }
        String userNameField = this._iFramePortletInstanceConfiguration.userNameField();
        if (Validator.isNull((String)userNameField) && (pos = this._userName.indexOf("=")) != -1) {
            String fieldValuePair = this._userName;
            userNameField = fieldValuePair.substring(0, pos);
            this._userName = fieldValuePair.substring(pos + 1);
        }
        if (Validator.isNotNull((String)userNameField)) {
            this._userName = IFrameUtil.getUserName(this._request, this._userName);
        }
        return this._userName;
    }
}

