/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.html.preview.service.persistence.impl;

import com.liferay.html.preview.exception.NoSuchHtmlPreviewEntryException;
import com.liferay.html.preview.model.HtmlPreviewEntry;
import com.liferay.html.preview.model.impl.HtmlPreviewEntryImpl;
import com.liferay.html.preview.model.impl.HtmlPreviewEntryModelImpl;
import com.liferay.html.preview.service.persistence.HtmlPreviewEntryPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class HtmlPreviewEntryPersistenceImpl
extends BasePersistenceImpl<HtmlPreviewEntry>
implements HtmlPreviewEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = HtmlPreviewEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByG_C_C;
    private FinderPath _finderPathCountByG_C_C;
    private static final String _FINDER_COLUMN_G_C_C_GROUPID_2 = "htmlPreviewEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_C_CLASSNAMEID_2 = "htmlPreviewEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_C_CLASSPK_2 = "htmlPreviewEntry.classPK = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_HTMLPREVIEWENTRY = "SELECT htmlPreviewEntry FROM HtmlPreviewEntry htmlPreviewEntry";
    private static final String _SQL_SELECT_HTMLPREVIEWENTRY_WHERE = "SELECT htmlPreviewEntry FROM HtmlPreviewEntry htmlPreviewEntry WHERE ";
    private static final String _SQL_COUNT_HTMLPREVIEWENTRY = "SELECT COUNT(htmlPreviewEntry) FROM HtmlPreviewEntry htmlPreviewEntry";
    private static final String _SQL_COUNT_HTMLPREVIEWENTRY_WHERE = "SELECT COUNT(htmlPreviewEntry) FROM HtmlPreviewEntry htmlPreviewEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "htmlPreviewEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No HtmlPreviewEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No HtmlPreviewEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(HtmlPreviewEntryPersistenceImpl.class);

    public HtmlPreviewEntry findByG_C_C(long groupId, long classNameId, long classPK) throws NoSuchHtmlPreviewEntryException {
        HtmlPreviewEntry htmlPreviewEntry = this.fetchByG_C_C(groupId, classNameId, classPK);
        if (htmlPreviewEntry == null) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", classNameId=");
            msg.append(classNameId);
            msg.append(", classPK=");
            msg.append(classPK);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchHtmlPreviewEntryException(msg.toString());
        }
        return htmlPreviewEntry;
    }

    public HtmlPreviewEntry fetchByG_C_C(long groupId, long classNameId, long classPK) {
        return this.fetchByG_C_C(groupId, classNameId, classPK, true);
    }

    public HtmlPreviewEntry fetchByG_C_C(long groupId, long classNameId, long classPK, boolean retrieveFromCache) {
        HtmlPreviewEntry htmlPreviewEntry;
        Object[] finderArgs = new Object[]{groupId, classNameId, classPK};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_C_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof HtmlPreviewEntry && (groupId != (htmlPreviewEntry = (HtmlPreviewEntry)result).getGroupId() || classNameId != htmlPreviewEntry.getClassNameId() || classPK != htmlPreviewEntry.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_SELECT_HTMLPREVIEWENTRY_WHERE);
            query.append(_FINDER_COLUMN_G_C_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_G_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(classNameId);
                qPos.add(classPK);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByG_C_C, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("HtmlPreviewEntryPersistenceImpl.fetchByG_C_C(long, long, long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    HtmlPreviewEntry htmlPreviewEntry2 = (HtmlPreviewEntry)list.get(0);
                    result = htmlPreviewEntry2;
                    this.cacheResult(htmlPreviewEntry2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByG_C_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (HtmlPreviewEntry)result;
    }

    public HtmlPreviewEntry removeByG_C_C(long groupId, long classNameId, long classPK) throws NoSuchHtmlPreviewEntryException {
        HtmlPreviewEntry htmlPreviewEntry = this.findByG_C_C(groupId, classNameId, classPK);
        return (HtmlPreviewEntry)this.remove((BaseModel)htmlPreviewEntry);
    }

    public int countByG_C_C(long groupId, long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByG_C_C;
        Object[] finderArgs = new Object[]{groupId, classNameId, classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_HTMLPREVIEWENTRY_WHERE);
            query.append(_FINDER_COLUMN_G_C_C_GROUPID_2);
            query.append(_FINDER_COLUMN_G_C_C_CLASSNAMEID_2);
            query.append(_FINDER_COLUMN_G_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public HtmlPreviewEntryPersistenceImpl() {
        this.setModelClass(HtmlPreviewEntry.class);
        this.setModelImplClass(HtmlPreviewEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED);
    }

    public void cacheResult(HtmlPreviewEntry htmlPreviewEntry) {
        this.entityCache.putResult(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryImpl.class, (Serializable)Long.valueOf(htmlPreviewEntry.getPrimaryKey()), (Serializable)htmlPreviewEntry);
        this.finderCache.putResult(this._finderPathFetchByG_C_C, new Object[]{htmlPreviewEntry.getGroupId(), htmlPreviewEntry.getClassNameId(), htmlPreviewEntry.getClassPK()}, (Object)htmlPreviewEntry);
        htmlPreviewEntry.resetOriginalValues();
    }

    public void cacheResult(List<HtmlPreviewEntry> htmlPreviewEntries) {
        for (HtmlPreviewEntry htmlPreviewEntry : htmlPreviewEntries) {
            if (this.entityCache.getResult(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryImpl.class, (Serializable)Long.valueOf(htmlPreviewEntry.getPrimaryKey())) == null) {
                this.cacheResult(htmlPreviewEntry);
                continue;
            }
            htmlPreviewEntry.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(HtmlPreviewEntryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(HtmlPreviewEntry htmlPreviewEntry) {
        this.entityCache.removeResult(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryImpl.class, (Serializable)Long.valueOf(htmlPreviewEntry.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((HtmlPreviewEntryModelImpl)htmlPreviewEntry, true);
    }

    public void clearCache(List<HtmlPreviewEntry> htmlPreviewEntries) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (HtmlPreviewEntry htmlPreviewEntry : htmlPreviewEntries) {
            this.entityCache.removeResult(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryImpl.class, (Serializable)Long.valueOf(htmlPreviewEntry.getPrimaryKey()));
            this.clearUniqueFindersCache((HtmlPreviewEntryModelImpl)htmlPreviewEntry, true);
        }
    }

    protected void cacheUniqueFindersCache(HtmlPreviewEntryModelImpl htmlPreviewEntryModelImpl) {
        Object[] args = new Object[]{htmlPreviewEntryModelImpl.getGroupId(), htmlPreviewEntryModelImpl.getClassNameId(), htmlPreviewEntryModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByG_C_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByG_C_C, args, (Object)htmlPreviewEntryModelImpl, false);
    }

    protected void clearUniqueFindersCache(HtmlPreviewEntryModelImpl htmlPreviewEntryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{htmlPreviewEntryModelImpl.getGroupId(), htmlPreviewEntryModelImpl.getClassNameId(), htmlPreviewEntryModelImpl.getClassPK()};
            this.finderCache.removeResult(this._finderPathCountByG_C_C, args);
            this.finderCache.removeResult(this._finderPathFetchByG_C_C, args);
        }
        if ((htmlPreviewEntryModelImpl.getColumnBitmask() & this._finderPathFetchByG_C_C.getColumnBitmask()) != 0L) {
            args = new Object[]{htmlPreviewEntryModelImpl.getOriginalGroupId(), htmlPreviewEntryModelImpl.getOriginalClassNameId(), htmlPreviewEntryModelImpl.getOriginalClassPK()};
            this.finderCache.removeResult(this._finderPathCountByG_C_C, args);
            this.finderCache.removeResult(this._finderPathFetchByG_C_C, args);
        }
    }

    public HtmlPreviewEntry create(long htmlPreviewEntryId) {
        HtmlPreviewEntryImpl htmlPreviewEntry = new HtmlPreviewEntryImpl();
        htmlPreviewEntry.setNew(true);
        htmlPreviewEntry.setPrimaryKey(htmlPreviewEntryId);
        htmlPreviewEntry.setCompanyId(this.companyProvider.getCompanyId());
        return htmlPreviewEntry;
    }

    public HtmlPreviewEntry remove(long htmlPreviewEntryId) throws NoSuchHtmlPreviewEntryException {
        return this.remove(Long.valueOf(htmlPreviewEntryId));
    }

    public HtmlPreviewEntry remove(Serializable primaryKey) throws NoSuchHtmlPreviewEntryException {
        Session session = null;
        try {
            session = this.openSession();
            HtmlPreviewEntry htmlPreviewEntry = (HtmlPreviewEntry)session.get(HtmlPreviewEntryImpl.class, primaryKey);
            if (htmlPreviewEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchHtmlPreviewEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            HtmlPreviewEntry htmlPreviewEntry2 = (HtmlPreviewEntry)this.remove((BaseModel)htmlPreviewEntry);
            return htmlPreviewEntry2;
        }
        catch (NoSuchHtmlPreviewEntryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected HtmlPreviewEntry removeImpl(HtmlPreviewEntry htmlPreviewEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)htmlPreviewEntry)) {
                htmlPreviewEntry = (HtmlPreviewEntry)session.get(HtmlPreviewEntryImpl.class, htmlPreviewEntry.getPrimaryKeyObj());
            }
            if (htmlPreviewEntry != null) {
                session.delete((Object)htmlPreviewEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (htmlPreviewEntry != null) {
            this.clearCache(htmlPreviewEntry);
        }
        return htmlPreviewEntry;
    }

    public HtmlPreviewEntry updateImpl(HtmlPreviewEntry htmlPreviewEntry) {
        boolean isNew = htmlPreviewEntry.isNew();
        if (!(htmlPreviewEntry instanceof HtmlPreviewEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(htmlPreviewEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)htmlPreviewEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in htmlPreviewEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom HtmlPreviewEntry implementation " + htmlPreviewEntry.getClass());
        }
        HtmlPreviewEntryModelImpl htmlPreviewEntryModelImpl = (HtmlPreviewEntryModelImpl)htmlPreviewEntry;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && htmlPreviewEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                htmlPreviewEntry.setCreateDate(now);
            } else {
                htmlPreviewEntry.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!htmlPreviewEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                htmlPreviewEntry.setModifiedDate(now);
            } else {
                htmlPreviewEntry.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (htmlPreviewEntry.isNew()) {
                session.save((Object)htmlPreviewEntry);
                htmlPreviewEntry.setNew(false);
            } else {
                htmlPreviewEntry = (HtmlPreviewEntry)session.merge((Object)htmlPreviewEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!HtmlPreviewEntryModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        this.entityCache.putResult(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryImpl.class, (Serializable)Long.valueOf(htmlPreviewEntry.getPrimaryKey()), (Serializable)htmlPreviewEntry, false);
        this.clearUniqueFindersCache(htmlPreviewEntryModelImpl, false);
        this.cacheUniqueFindersCache(htmlPreviewEntryModelImpl);
        htmlPreviewEntry.resetOriginalValues();
        return htmlPreviewEntry;
    }

    public HtmlPreviewEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchHtmlPreviewEntryException {
        HtmlPreviewEntry htmlPreviewEntry = (HtmlPreviewEntry)this.fetchByPrimaryKey(primaryKey);
        if (htmlPreviewEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchHtmlPreviewEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return htmlPreviewEntry;
    }

    public HtmlPreviewEntry findByPrimaryKey(long htmlPreviewEntryId) throws NoSuchHtmlPreviewEntryException {
        return this.findByPrimaryKey(Long.valueOf(htmlPreviewEntryId));
    }

    public HtmlPreviewEntry fetchByPrimaryKey(long htmlPreviewEntryId) {
        return (HtmlPreviewEntry)this.fetchByPrimaryKey(Long.valueOf(htmlPreviewEntryId));
    }

    public List<HtmlPreviewEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<HtmlPreviewEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<HtmlPreviewEntry> findAll(int start, int end, OrderByComparator<HtmlPreviewEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<HtmlPreviewEntry> findAll(int start, int end, OrderByComparator<HtmlPreviewEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_HTMLPREVIEWENTRY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_HTMLPREVIEWENTRY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY htmlPreviewEntry.htmlPreviewEntryId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (HtmlPreviewEntry htmlPreviewEntry : this.findAll()) {
            this.remove((BaseModel)htmlPreviewEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_HTMLPREVIEWENTRY);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "htmlPreviewEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_HTMLPREVIEWENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return HtmlPreviewEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryModelImpl.FINDER_CACHE_ENABLED, HtmlPreviewEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryModelImpl.FINDER_CACHE_ENABLED, HtmlPreviewEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByG_C_C = new FinderPath(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryModelImpl.FINDER_CACHE_ENABLED, HtmlPreviewEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, 7L);
        this._finderPathCountByG_C_C = new FinderPath(HtmlPreviewEntryModelImpl.ENTITY_CACHE_ENABLED, HtmlPreviewEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(HtmlPreviewEntryImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

