/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.html.preview.service.impl;

import com.liferay.html.preview.exception.InvalidHtmlPreviewEntryMimeTypeException;
import com.liferay.html.preview.model.HtmlPreviewEntry;
import com.liferay.html.preview.processor.HtmlPreviewProcessor;
import com.liferay.html.preview.processor.HtmlPreviewProcessorTracker;
import com.liferay.html.preview.service.base.HtmlPreviewEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.util.Date;

public class HtmlPreviewEntryLocalServiceImpl
extends HtmlPreviewEntryLocalServiceBaseImpl {
    @ServiceReference(type=HtmlPreviewProcessorTracker.class)
    private HtmlPreviewProcessorTracker _htmlPreviewProcessorTracker;

    public HtmlPreviewEntry addHtmlPreviewEntry(long userId, long groupId, long classNameId, long classPK, String content, String mimeType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long htmlPreviewEntryId = this.counterLocalService.increment();
        HtmlPreviewEntry htmlPreviewEntry = this.htmlPreviewEntryPersistence.create(htmlPreviewEntryId);
        htmlPreviewEntry.setGroupId(groupId);
        htmlPreviewEntry.setCompanyId(user.getCompanyId());
        htmlPreviewEntry.setUserId(user.getUserId());
        htmlPreviewEntry.setUserName(user.getFullName());
        htmlPreviewEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        htmlPreviewEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        htmlPreviewEntry.setClassNameId(classNameId);
        htmlPreviewEntry.setClassPK(classPK);
        FileEntry fileEntry = this._getFileEntry(htmlPreviewEntry.getUserId(), htmlPreviewEntry.getGroupId(), htmlPreviewEntryId, content, mimeType);
        if (fileEntry != null) {
            htmlPreviewEntry.setFileEntryId(fileEntry.getFileEntryId());
        }
        this.htmlPreviewEntryPersistence.update((BaseModel)htmlPreviewEntry);
        return htmlPreviewEntry;
    }

    @Override
    public HtmlPreviewEntry deleteHtmlPreviewEntry(HtmlPreviewEntry htmlPreviewEntry) throws PortalException {
        this.htmlPreviewEntryPersistence.remove((BaseModel)htmlPreviewEntry);
        if (htmlPreviewEntry.getFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)htmlPreviewEntry.getFileEntryId());
        }
        return htmlPreviewEntry;
    }

    @Override
    public HtmlPreviewEntry deleteHtmlPreviewEntry(long htmlPreviewEntryId) throws PortalException {
        HtmlPreviewEntry htmlPreviewEntry = this.htmlPreviewEntryPersistence.fetchByPrimaryKey(htmlPreviewEntryId);
        return this.deleteHtmlPreviewEntry(htmlPreviewEntry);
    }

    public HtmlPreviewEntry updateHtmlPreviewEntry(long htmlPreviewEntryId, String content, String mimeType, ServiceContext serviceContext) throws PortalException {
        HtmlPreviewEntry htmlPreviewEntry = this.htmlPreviewEntryPersistence.fetchByPrimaryKey(htmlPreviewEntryId);
        htmlPreviewEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        FileEntry fileEntry = this._getFileEntry(htmlPreviewEntry.getUserId(), htmlPreviewEntry.getGroupId(), htmlPreviewEntryId, content, mimeType);
        if (fileEntry != null) {
            htmlPreviewEntry.setFileEntryId(fileEntry.getFileEntryId());
        }
        this.htmlPreviewEntryPersistence.update((BaseModel)htmlPreviewEntry);
        return htmlPreviewEntry;
    }

    private FileEntry _getFileEntry(long userId, long groupId, long htmlPreviewEntryId, String content, String mimeType) throws PortalException {
        FileEntry fileEntry;
        HtmlPreviewProcessor htmlPreviewProcessor = this._htmlPreviewProcessorTracker.getHtmlPreviewProcessor(mimeType);
        if (htmlPreviewProcessor == null) {
            throw new InvalidHtmlPreviewEntryMimeTypeException("No HTML preview processor available for MIME type " + mimeType);
        }
        File file = htmlPreviewProcessor.generateContentHtmlPreview(content);
        if (file == null) {
            return null;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)groupId, (String)HtmlPreviewEntry.class.getName());
        if (repository != null && (fileEntry = PortletFileRepositoryUtil.fetchPortletFileEntry((long)groupId, (long)repository.getDlFolderId(), (String)String.valueOf(htmlPreviewEntryId))) != null) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)groupId, (long)repository.getDlFolderId(), (String)String.valueOf(htmlPreviewEntryId));
        }
        return PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)HtmlPreviewEntry.class.getName(), (long)htmlPreviewEntryId, (String)HtmlPreviewEntry.class.getName(), (long)0L, (File)file, (String)String.valueOf(htmlPreviewEntryId), (String)mimeType, (boolean)false);
    }
}

