/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.internal.resource.v1_0;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.headless.form.dto.v1_0.Form;
import com.liferay.headless.form.dto.v1_0.FormContext;
import com.liferay.headless.form.dto.v1_0.FormDocument;
import com.liferay.headless.form.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.form.internal.dto.v1_0.util.FormContextUtil;
import com.liferay.headless.form.internal.dto.v1_0.util.FormDocumentUtil;
import com.liferay.headless.form.internal.dto.v1_0.util.StructureUtil;
import com.liferay.headless.form.internal.resource.v1_0.BaseFormResourceImpl;
import com.liferay.headless.form.resource.v1_0.FormResource;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/form.properties"}, scope=ServiceScope.PROTOTYPE, service={FormResource.class})
public class FormResourceImpl
extends BaseFormResourceImpl {
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLURLHelper _dlurlHelper;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Form getForm(Long formId) throws Exception {
        return this._toForm(this._ddmFormInstanceService.getFormInstance(formId.longValue()));
    }

    @Override
    public Page<Form> getSiteFormsPage(Long siteId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._ddmFormInstanceService.getFormInstances(this.contextCompany.getCompanyId(), siteId.longValue(), pagination.getStartPosition(), pagination.getEndPosition()), this::_toForm), (Pagination)pagination, (long)this._ddmFormInstanceService.getFormInstancesCount(this.contextCompany.getCompanyId(), siteId.longValue()));
    }

    @Override
    public FormContext postFormEvaluateContext(Long formId, FormContext formContext) throws Exception {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(formId.longValue());
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setGroupId(ddmFormInstance.getGroupId());
        ddmFormRenderingContext.setHttpServletRequest(this._httpServletRequest);
        return FormContextUtil.evaluateContext(ddmFormInstance, ddmFormRenderingContext, this._ddmFormTemplateContextFactory, formContext.getFormFieldValues(), this.contextAcceptLanguage.getPreferredLocale());
    }

    @Override
    public FormDocument postFormFormDocument(Long formId, MultipartBody multipartBody) throws Exception {
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(formId.longValue());
        FormDocument formDocument = (FormDocument)multipartBody.getValueAsInstance("formDocument", FormDocument.class);
        long folderId = Optional.ofNullable(formDocument.getFolderId()).orElse(0L);
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        return FormDocumentUtil.toFormDocument(this._dlurlHelper, this._dlAppService.addFileEntry(ddmFormInstance.getGroupId(), folderId, binaryFile.getFileName(), binaryFile.getContentType(), formDocument.getTitle(), formDocument.getDescription(), null, binaryFile.getInputStream(), binaryFile.getSize(), new ServiceContext()));
    }

    private Form _toForm(final DDMFormInstance ddmFormInstance) throws Exception {
        if (ddmFormInstance == null) {
            return null;
        }
        return new Form(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmFormInstance.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(FormResourceImpl.this._portal, FormResourceImpl.this._userLocalService.getUser(ddmFormInstance.getUserId()));
                this.dateCreated = ddmFormInstance.getCreateDate();
                this.dateModified = ddmFormInstance.getModifiedDate();
                this.datePublished = ddmFormInstance.getLastPublishDate();
                this.defaultLanguage = ddmFormInstance.getDefaultLanguageId();
                this.description = ddmFormInstance.getDescription(FormResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = ddmFormInstance.getFormInstanceId();
                this.name = ddmFormInstance.getName(FormResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.structure = StructureUtil.toFormStructure(ddmFormInstance.getStructure(), FormResourceImpl.this.contextAcceptLanguage.getPreferredLocale(), FormResourceImpl.this._portal, FormResourceImpl.this._userLocalService);
            }
        };
    }
}

