/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.form.dto.v1_0.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.headless.form.dto.v1_0.FormField;
import com.liferay.headless.form.dto.v1_0.FormFieldOption;
import com.liferay.headless.form.dto.v1_0.FormPage;
import com.liferay.headless.form.dto.v1_0.FormStructure;
import com.liferay.headless.form.dto.v1_0.FormSuccessPage;
import com.liferay.headless.form.dto.v1_0.Grid;
import com.liferay.headless.form.dto.v1_0.Validation;
import com.liferay.headless.form.dto.v1_0.util.CreatorUtil;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StructureUtil {
    public static FormStructure toFormStructure(final boolean acceptAllLanguages, final DDMStructure ddmStructure, final Locale locale, final Portal portal, final UserLocalService userLocalService) throws PortalException {
        final DDMFormLayout ddmFormLayout = ddmStructure.getDDMFormLayout();
        DDMForm ddmForm = ddmStructure.getDDMForm();
        final DDMFormSuccessPageSettings ddmFormSuccessPageSettings = ddmForm.getDDMFormSuccessPageSettings();
        return new FormStructure(){
            {
                this.availableLanguages = LocaleUtil.toW3cLanguageIds((String[])ddmStructure.getAvailableLanguageIds());
                this.creator = CreatorUtil.toCreator(portal, userLocalService.fetchUser(ddmStructure.getUserId()));
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.description = ddmStructure.getDescription(locale);
                this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getDescriptionMap());
                this.formPages = (FormPage[])TransformUtil.transformToArray((Collection)ddmFormLayout.getDDMFormLayoutPages(), ddmFormLayoutPage -> StructureUtil._toFormPage(acceptAllLanguages, ddmFormLayoutPage, ddmStructure, locale), FormPage.class);
                this.id = ddmStructure.getStructureId();
                this.name = ddmStructure.getName(locale);
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)ddmStructure.getNameMap());
                this.siteId = ddmStructure.getGroupId();
                this.setFormSuccessPage((UnsafeSupplier<FormSuccessPage, Exception>)((UnsafeSupplier)() -> {
                    if (!ddmFormSuccessPageSettings.isEnabled()) {
                        return null;
                    }
                    final LocalizedValue bodyLocalizedValue = ddmFormSuccessPageSettings.getBody();
                    final LocalizedValue titleLocalizedValue = ddmFormSuccessPageSettings.getTitle();
                    return new FormSuccessPage(){
                        {
                            this.description = StructureUtil._toString(locale, bodyLocalizedValue);
                            this.description_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)bodyLocalizedValue.getValues());
                            this.headline = StructureUtil._toString(locale, titleLocalizedValue);
                            this.headline_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)titleLocalizedValue.getValues());
                        }
                    };
                }));
            }
        };
    }

    private static List<String> _getNestedDDMFormFieldNames(List<String> ddmFormFieldNames, DDMStructure ddmStructure) {
        List ddmFormFields = ddmStructure.getDDMFormFields(true);
        Stream stream = ddmFormFields.stream();
        return stream.filter(ddmFormField -> ddmFormFieldNames.contains(ddmFormField.getName())).map(ddmFormField -> TransformUtil.transform((Collection)ddmFormField.getNestedDDMFormFields(), DDMFormField::getName)).map(nestedDDMFormFieldNames -> StructureUtil._getNestedDDMFormFieldNames(nestedDDMFormFieldNames, ddmStructure)).peek(nestedDDMFormFieldNames -> nestedDDMFormFieldNames.addAll(ddmFormFieldNames)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static FormField _toFormField(final boolean acceptAllLanguages, final DDMFormField ddmFormField, final Locale locale) {
        final LocalizedValue labelLocalizedValue = ddmFormField.getLabel();
        final LocalizedValue predefinedLocalizedValue = ddmFormField.getPredefinedValue();
        final String type = ddmFormField.getType();
        return new FormField(){
            {
                this.displayStyle = GetterUtil.getString((Object)ddmFormField.getProperty("displayStyle"));
                this.formFieldOptions = (FormFieldOption[])Optional.ofNullable(ddmFormField.getDDMFormFieldOptions()).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).map(entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale)).toArray(FormFieldOption[]::new);
                this.immutable = ddmFormField.isTransient();
                this.inputControl = type;
                this.label = StructureUtil._toString(locale, labelLocalizedValue);
                this.label_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)labelLocalizedValue.getValues());
                this.localizable = ddmFormField.isLocalizable();
                this.multiple = ddmFormField.isMultiple();
                this.name = ddmFormField.getName();
                this.placeholder = StructureUtil._toString(locale, (LocalizedValue)ddmFormField.getProperty("placeholder"));
                this.predefinedValue = StructureUtil._toString(locale, predefinedLocalizedValue);
                this.predefinedValue_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)predefinedLocalizedValue.getValues());
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.tooltip = StructureUtil._toString(locale, (LocalizedValue)ddmFormField.getProperty("tip"));
                this.setDataType((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    if (Objects.equals("date", type)) {
                        return type;
                    }
                    if (Objects.equals("document_library", type)) {
                        return "document";
                    }
                    if (Objects.equals("paragraph", type)) {
                        return "string";
                    }
                    return ddmFormField.getDataType();
                }));
                this.setGrid((UnsafeSupplier<Grid, Exception>)((UnsafeSupplier)() -> {
                    if (!Objects.equals("grid", type)) {
                        return null;
                    }
                    return new Grid(){
                        {
                            this.columns = (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "columns"), entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale), FormFieldOption.class);
                            this.rows = (FormFieldOption[])TransformUtil.transform((Object[])StructureUtil._toMapEntry(ddmFormField, "rows"), entry -> StructureUtil._toFormFieldOption(acceptAllLanguages, entry, locale), FormFieldOption.class);
                        }
                    };
                }));
                this.setHasFormRules((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> {
                    DDMForm ddmForm = ddmFormField.getDDMForm();
                    List ddmFormRules = ddmForm.getDDMFormRules();
                    Stream stream = ddmFormRules.stream();
                    return stream.map(DDMFormRule::getCondition).anyMatch(condition -> condition.contains(ddmFormField.getName()));
                }));
                this.setShowAsSwitcher((UnsafeSupplier<Boolean, Exception>)((UnsafeSupplier)() -> {
                    if (!"checkbox".equals(type) && !"checkbox_multiple".equals(type)) {
                        return null;
                    }
                    return GetterUtil.getBoolean((Object)ddmFormField.getProperty("showAsSwitcher"));
                }));
                this.setText((UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("text");
                    if (!(object instanceof LocalizedValue)) {
                        return null;
                    }
                    return StructureUtil._toString(locale, (LocalizedValue)object);
                }));
                this.setText_i18n((UnsafeSupplier<Map<String, String>, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("text");
                    if (!(object instanceof LocalizedValue)) {
                        return null;
                    }
                    LocalizedValue localizedValue = (LocalizedValue)object;
                    return LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)localizedValue.getValues());
                }));
                this.setValidation((UnsafeSupplier<Validation, Exception>)((UnsafeSupplier)() -> {
                    Object object = ddmFormField.getProperty("validation");
                    if (!(object instanceof DDMFormFieldValidation)) {
                        return null;
                    }
                    final DDMFormFieldValidation ddmFormFieldValidation = (DDMFormFieldValidation)object;
                    final LocalizedValue errorMessageLocalizedValue = ddmFormFieldValidation.getErrorMessageLocalizedValue();
                    return new Validation(){
                        {
                            this.errorMessage = errorMessageLocalizedValue.getString(locale);
                            this.errorMessage_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)errorMessageLocalizedValue.getValues());
                            this.expression = ddmFormFieldValidation.getExpression();
                        }
                    };
                }));
            }
        };
    }

    private static FormFieldOption _toFormFieldOption(final boolean acceptAllLanguages, final Map.Entry<String, LocalizedValue> entry, final Locale locale) {
        final LocalizedValue localizedValue = entry.getValue();
        return new FormFieldOption(){
            {
                this.label = StructureUtil._toString(locale, localizedValue);
                this.label_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)localizedValue.getValues());
                this.value = (String)entry.getKey();
            }
        };
    }

    private static FormPage _toFormPage(final boolean acceptAllLanguages, final DDMFormLayoutPage ddmFormLayoutPage, DDMStructure ddmStructure, final Locale locale) {
        List ddmFormFieldNames = Stream.of(ddmFormLayoutPage.getDDMFormLayoutRows()).flatMap(Collection::stream).map(DDMFormLayoutRow::getDDMFormLayoutColumns).flatMap(Collection::stream).map(DDMFormLayoutColumn::getDDMFormFieldNames).map(nestedDDMFormFieldNames -> StructureUtil._getNestedDDMFormFieldNames(nestedDDMFormFieldNames, ddmStructure)).flatMap(Collection::stream).collect(Collectors.toList());
        List ddmFormFieldsList = ddmStructure.getDDMFormFields(true);
        Stream ddmFormFieldsStream = ddmFormFieldsList.stream();
        final DDMFormField[] ddmFormFields = (DDMFormField[])ddmFormFieldsStream.filter(ddmFormField -> ddmFormFieldNames.contains(ddmFormField.getName())).toArray(DDMFormField[]::new);
        final LocalizedValue titleLocalizedValue = ddmFormLayoutPage.getTitle();
        final LocalizedValue descriptionLocalizedValue = ddmFormLayoutPage.getDescription();
        return new FormPage(){
            {
                this.formFields = (FormField[])TransformUtil.transform((Object[])ddmFormFields, ddmFormField -> StructureUtil._toFormField(acceptAllLanguages, ddmFormField, locale), FormField.class);
                this.headline = StructureUtil._toString(locale, titleLocalizedValue);
                this.headline_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)titleLocalizedValue.getValues());
                this.text = StructureUtil._toString(locale, ddmFormLayoutPage.getDescription());
                this.text_i18n = LocalizedMapUtil.getI18nMap((boolean)acceptAllLanguages, (Map)descriptionLocalizedValue.getValues());
            }
        };
    }

    private static Map.Entry<String, LocalizedValue>[] _toMapEntry(DDMFormField ddmFormField, String name) {
        Object value = ddmFormField.getProperty(name);
        if (value == null) {
            return new Map.Entry[0];
        }
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)value;
        Map options = ddmFormFieldOptions.getOptions();
        Set set = options.entrySet();
        return set.toArray(new Map.Entry[0]);
    }

    private static String _toString(Locale locale, LocalizedValue localizedValue) {
        if (localizedValue == null) {
            return null;
        }
        return localizedValue.getString(locale);
    }
}

