/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.WikiPageDTOConverter;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.WikiPageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiPageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.WikiPageResource;
import com.liferay.headless.delivery.search.aggregation.AggregationUtil;
import com.liferay.headless.delivery.search.filter.FilterUtil;
import com.liferay.headless.delivery.search.sort.SortUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.WikiPageService;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-page.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiPageResource.class})
public class WikiPageResourceImpl
extends BaseWikiPageResourceImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private WikiNodeService _wikiNodeService;
    @Reference
    private WikiPageDTOConverter _wikiPageDTOConverter;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference
    private WikiPageService _wikiPageService;

    @Override
    public void deleteSiteWikiPageByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getLatestPageByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        this._wikiPageService.deletePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    public void deleteWikiPage(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPage(wikiPageId.longValue());
        this._wikiPageService.deletePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new WikiPageEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(WikiPage.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage getSiteWikiPageByExternalReferenceCode(Long siteId, String externalReferenceCode) throws Exception {
        return this._toWikiPage(this._wikiPageService.getLatestPageByExternalReferenceCode(siteId.longValue(), externalReferenceCode));
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiPage> getWikiNodeWikiPagesPage(Long wikiNodeId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        WikiNode wikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"add-page", this.addAction("ADD_PAGE", (GroupedModel)wikiNode, "postWikiNodeWikiPage")).put((Object)"createBatch", this.addAction("ADD_PAGE", (GroupedModel)wikiNode, "postWikiNodeWikiPageBatch")).put((Object)"get", this.addAction("VIEW", (GroupedModel)wikiNode, "getWikiNodeWikiPagesPage")).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("nodeId", String.valueOf(wikiNodeId)), BooleanClauseOccur.MUST);
        }, (Filter)FilterUtil.processFilter((DDMIndexer)this._ddmIndexer, (Filter)filter), (String)WikiPage.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            AggregationUtil.processVulcanAggregation((Aggregations)this._aggregations, (DDMIndexer)this._ddmIndexer, (Queries)this._queries, (SearchRequestBuilder)searchRequestBuilder, (Aggregation)aggregation);
            SortUtil.processSorts((DDMIndexer)this._ddmIndexer, (SearchRequestBuilder)searchRequestBuilder, (Sort[])searchContext.getSorts(), (Queries)this._queries, (Sorts)this._sorts);
        }, (Sort[])sorts, document -> this._toWikiPage(this._wikiPageService.getPage(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage getWikiPage(Long wikiPageId) throws Exception {
        return this._toWikiPage(this._wikiPageService.getPage(wikiPageId.longValue()));
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiPage> getWikiPageWikiPagesPage(Long parentWikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageService.getPage(parentWikiPageId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"add-page", this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "postWikiPageWikiPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"get", this.addAction("VIEW", wikiPage.getResourcePrimKey(), "getWikiPageWikiPagesPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).build(), this.transform(this._wikiPageService.getChildren(wikiPage.getGroupId(), wikiPage.getNodeId(), true, wikiPage.getTitle()), this::_toWikiPage));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage postWikiNodeWikiPage(Long wikiNodeId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiNode wikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        ServiceContext serviceContext = this._createServiceContext("add", wikiNode.getGroupId(), wikiPage);
        return this._toWikiPage(this._wikiPageService.addPage(wikiPage.getExternalReferenceCode(), wikiNodeId.longValue(), wikiPage.getHeadline(), wikiPage.getContent(), wikiPage.getHeadline(), true, this._toFormat(wikiPage.getEncodingFormat()), null, null, serviceContext));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage postWikiPageWikiPage(Long parentWikiPageId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiPage parentWikiPage = this._wikiPageService.getPage(parentWikiPageId.longValue());
        ServiceContext serviceContext = this._createServiceContext("add", parentWikiPage.getGroupId(), wikiPage);
        return this._toWikiPage(this._wikiPageService.addPage(wikiPage.getExternalReferenceCode(), parentWikiPage.getNodeId(), wikiPage.getHeadline(), 1.0, wikiPage.getContent(), wikiPage.getHeadline(), false, this._toFormat(wikiPage.getEncodingFormat()), false, parentWikiPage.getTitle(), null, serviceContext));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage putSiteWikiPageByExternalReferenceCode(Long siteId, String externalReferenceCode, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiPage serviceBuilderWikiPage = this._wikiPageLocalService.fetchLatestPageByExternalReferenceCode(siteId.longValue(), externalReferenceCode);
        if (serviceBuilderWikiPage != null) {
            return this._updateWikiPage(serviceBuilderWikiPage, wikiPage);
        }
        if (wikiPage.getWikiNodeId() == null) {
            throw new BadRequestException("WikiNode ID is null");
        }
        return this._toWikiPage(this._wikiPageService.addPage(externalReferenceCode, wikiPage.getWikiNodeId().longValue(), wikiPage.getHeadline(), wikiPage.getContent(), wikiPage.getDescription(), false, this._toFormat(wikiPage.getEncodingFormat()), null, null, this._createServiceContext("add", siteId, wikiPage)));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiPage putWikiPage(Long wikiPageId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        WikiPage serviceBuilderWikiPage = this._wikiPageService.getPage(wikiPageId.longValue());
        return this._updateWikiPage(serviceBuilderWikiPage, wikiPage);
    }

    @Override
    public void putWikiPageSubscribe(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPage(wikiPageId.longValue());
        this._wikiPageService.subscribePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    public void putWikiPageUnsubscribe(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPage(wikiPageId.longValue());
        this._wikiPageService.unsubscribePage(wikiPage.getNodeId(), wikiPage.getTitle());
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPage(((Long)id).longValue());
        return wikiPage.getGroupId();
    }

    @Override
    protected String getPermissionCheckerPortletName(Object id) {
        return "com.liferay.wiki";
    }

    @Override
    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPage(((Long)id).longValue());
        return wikiPage.getResourcePrimKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) {
        return WikiPage.class.getName();
    }

    private ServiceContext _createServiceContext(String command, Long groupId, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) {
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])wikiPage.getTaxonomyCategoryIds(), (String[])wikiPage.getKeywords(), this._getExpandoBridgeAttributes(wikiPage), (Long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)wikiPage.getViewableByAsString());
        serviceContext.setCommand(command);
        return serviceContext;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) {
        return CustomFieldsUtil.toMap((String)WikiPage.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])wikiPage.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
    }

    private String _toFormat(String encodingFormat) {
        if (encodingFormat.equals("text/x-wiki")) {
            return "creole";
        }
        if (encodingFormat.equals("text/html")) {
            return "html";
        }
        if (encodingFormat.equals("text/plain")) {
            return "plain_text";
        }
        return encodingFormat;
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiPage _toWikiPage(WikiPage wikiPage) throws Exception {
        return this._wikiPageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"add-page", this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "postWikiPageWikiPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"delete", this.addAction("DELETE", wikiPage.getResourcePrimKey(), "deleteWikiPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"deleteBatch", this.addAction("DELETE", "deleteWikiPageBatch", com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), null)).put((Object)"get", this.addAction("VIEW", wikiPage.getResourcePrimKey(), "getWikiPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"replace", this.addAction("UPDATE", wikiPage.getResourcePrimKey(), "putWikiPage", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", wikiPage.getResourcePrimKey(), "putWikiPageSubscribe", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", wikiPage.getResourcePrimKey(), "putWikiPageUnsubscribe", wikiPage.getUserId(), com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), wikiPage.getGroupId())).put((Object)"updateBatch", this.addAction("UPDATE", "putWikiPageBatch", com.liferay.headless.delivery.dto.v1_0.WikiPage.class.getName(), null)).build(), this._dtoConverterRegistry, (Object)wikiPage.getResourcePrimKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiPage _updateWikiPage(WikiPage serviceBuilderWikiPage, com.liferay.headless.delivery.dto.v1_0.WikiPage wikiPage) throws Exception {
        ServiceContext serviceContext = this._createServiceContext("update", serviceBuilderWikiPage.getGroupId(), wikiPage);
        return this._toWikiPage(this._wikiPageService.updatePage(serviceBuilderWikiPage.getNodeId(), wikiPage.getHeadline(), serviceBuilderWikiPage.getVersion(), wikiPage.getContent(), wikiPage.getDescription(), true, this._toFormat(wikiPage.getEncodingFormat()), serviceBuilderWikiPage.getParentTitle(), serviceBuilderWikiPage.getRedirectTitle(), serviceContext));
    }
}

