/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.headless.common.spi.odata.entity.CommentEntityModel;
import com.liferay.headless.delivery.dto.v1_0.Comment;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CommentUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseCommentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.CommentResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.message.boards.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/comment.properties"}, scope=ServiceScope.PROTOTYPE, service={CommentResource.class})
public class CommentResourceImpl
extends BaseCommentResourceImpl {
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteComment(Long commentId) throws Exception {
        this._deleteComment(commentId);
    }

    @Override
    public void deleteSiteBlogPostingByExternalReferenceCodeBlogPostingExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String blogPostingExternalReferenceCode, String externalReferenceCode) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getBlogsEntryByExternalReferenceCode(siteId.longValue(), blogPostingExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, BlogsEntry.class.getName(), blogsEntry.getEntryId());
        this._deleteComment(comment.getCommentId());
    }

    @Override
    public void deleteSiteCommentByExternalReferenceCodeParentCommentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String parentCommentExternalReferenceCode, String externalReferenceCode) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, parentCommentExternalReferenceCode, siteId);
        this._deleteComment(comment.getCommentId());
    }

    @Override
    public void deleteSiteDocumentByExternalReferenceCodeDocumentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String documentExternalReferenceCode, String externalReferenceCode) throws Exception {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntryByExternalReferenceCode(siteId.longValue(), documentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
        this._deleteComment(comment.getCommentId());
    }

    @Override
    public void deleteSiteStructuredContentByExternalReferenceCodeStructuredContentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String structuredContentExternalReferenceCode, String externalReferenceCode) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticleByExternalReferenceCode(siteId.longValue(), structuredContentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        this._deleteComment(comment.getCommentId());
    }

    @Override
    public Page<Comment> getBlogPostingCommentsPage(Long blogPostingId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(blogsEntry.getUserId(), blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", blogPostingId, "postBlogPostingComment", blogsEntry.getUserId(), BlogsEntry.class.getName(), blogsEntry.getGroupId())).put((Object)"createBatch", this.addAction("ADD_DISCUSSION", blogPostingId, "postBlogPostingCommentBatch", blogsEntry.getUserId(), BlogsEntry.class.getName(), blogsEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", blogPostingId, "getBlogPostingCommentsPage", blogsEntry.getUserId(), BlogsEntry.class.getName(), blogsEntry.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Comment getComment(Long commentId) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._commentManager.fetchComment(commentId.longValue());
        if (comment == null) {
            throw new NoSuchModelException("No comment exists with comment ID " + commentId);
        }
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return CommentUtil.toComment(comment, this._commentManager, this._portal);
    }

    @Override
    public Page<Comment> getCommentCommentsPage(Long parentCommentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getComments(HashMapBuilder.put((Object)"deleteBatch", this.addAction("DELETE", "deleteCommentBatch", Comment.class.getName(), null)).put((Object)"updateBatch", this.addAction("UPDATE", "putCommentBatch", Comment.class.getName(), null)).build(), parentCommentId, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Page<Comment> getDocumentCommentsPage(Long documentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(dlFileEntry.getUserId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), documentId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", documentId, "postDocumentComment", dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getGroupId())).put((Object)"createBatch", this.addAction("ADD_DISCUSSION", documentId, "postDocumentCommentBatch", dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", documentId, "getDocumentCommentsPage", dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new CommentEntityModel();
    }

    @Override
    public Comment getSiteBlogPostingByExternalReferenceCodeBlogPostingExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String blogPostingExternalReferenceCode, String externalReferenceCode) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getBlogsEntryByExternalReferenceCode(siteId.longValue(), blogPostingExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, BlogsEntry.class.getName(), blogsEntry.getEntryId());
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return CommentUtil.toComment(comment, this._commentManager, this._portal);
    }

    @Override
    public Comment getSiteCommentByExternalReferenceCodeParentCommentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String parentCommentExternalReferenceCode, String externalReferenceCode) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, parentCommentExternalReferenceCode, siteId);
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return CommentUtil.toComment(comment, this._commentManager, this._portal);
    }

    @Override
    public Comment getSiteDocumentByExternalReferenceCodeDocumentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String documentExternalReferenceCode, String externalReferenceCode) throws Exception {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntryByExternalReferenceCode(siteId.longValue(), documentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return CommentUtil.toComment(comment, this._commentManager, this._portal);
    }

    @Override
    public Comment getSiteStructuredContentByExternalReferenceCodeStructuredContentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String structuredContentExternalReferenceCode, String externalReferenceCode) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticleByExternalReferenceCode(siteId.longValue(), structuredContentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return CommentUtil.toComment(comment, this._commentManager, this._portal);
    }

    @Override
    public Page<Comment> getStructuredContentCommentsPage(Long structuredContentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        Discussion discussion = this._commentManager.getDiscussion(journalArticle.getUserId(), journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId.longValue(), this._createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        return this._getComments(HashMapBuilder.put((Object)"add-discussion", this.addAction("ADD_DISCUSSION", structuredContentId, "postStructuredContentComment", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"createBatch", this.addAction("ADD_DISCUSSION", structuredContentId, "postStructuredContentCommentBatch", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).put((Object)"get", this.addAction("VIEW", structuredContentId, "getStructuredContentCommentsPage", journalArticle.getUserId(), JournalArticle.class.getName(), journalArticle.getGroupId())).build(), rootDiscussionComment.getCommentId(), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Comment postBlogPostingComment(Long blogPostingId, Comment comment) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(blogPostingId.longValue());
        return this._postEntityComment(comment.getExternalReferenceCode(), blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogPostingId, comment.getText());
    }

    @Override
    public Comment postCommentComment(Long parentCommentId, Comment comment) throws Exception {
        com.liferay.portal.kernel.comment.Comment parentComment = this._commentManager.fetchComment(parentCommentId.longValue());
        if (parentComment == null) {
            throw new NotFoundException();
        }
        return this._postParentCommentComment(comment.getExternalReferenceCode(), parentComment.getGroupId(), parentComment.getCommentId(), parentComment.getClassName(), parentComment.getClassPK(), comment.getText());
    }

    @Override
    public Comment postDocumentComment(Long documentId, Comment comment) throws Exception {
        DLFileEntry fileEntry = this._dlFileEntryService.getFileEntry(documentId.longValue());
        return this._postEntityComment(comment.getExternalReferenceCode(), fileEntry.getGroupId(), DLFileEntry.class.getName(), documentId, comment.getText());
    }

    @Override
    public Comment postStructuredContentComment(Long structuredContentId, Comment comment) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticle(structuredContentId.longValue());
        return this._postEntityComment(comment.getExternalReferenceCode(), journalArticle.getGroupId(), JournalArticle.class.getName(), structuredContentId, comment.getText());
    }

    @Override
    public Comment putComment(Long commentId, Comment comment) throws Exception {
        return this._updateComment(this._commentManager.fetchComment(commentId.longValue()), commentId, comment.getText());
    }

    @Override
    public Comment putSiteBlogPostingByExternalReferenceCodeBlogPostingExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String blogPostingExternalReferenceCode, String externalReferenceCode, Comment comment) throws Exception {
        BlogsEntry blogsEntry = this._blogsEntryService.getBlogsEntryByExternalReferenceCode(siteId.longValue(), blogPostingExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment existingComment = this._fetchComment(externalReferenceCode, siteId, BlogsEntry.class.getName(), blogsEntry.getEntryId());
        if (existingComment != null) {
            return this._updateComment(existingComment, existingComment.getCommentId(), comment.getText());
        }
        return this._postEntityComment(externalReferenceCode, blogsEntry.getGroupId(), BlogsEntry.class.getName(), blogsEntry.getEntryId(), comment.getText());
    }

    @Override
    public Comment putSiteCommentByExternalReferenceCodeParentCommentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String parentCommentExternalReferenceCode, String externalReferenceCode, Comment comment) throws Exception {
        com.liferay.portal.kernel.comment.Comment parentComment = this._getComment(parentCommentExternalReferenceCode, siteId);
        com.liferay.portal.kernel.comment.Comment existingComment = this._fetchComment(externalReferenceCode, siteId, parentComment.getClassName(), parentComment.getClassPK());
        if (existingComment != null && parentComment.getCommentId() == existingComment.getParentCommentId()) {
            return this._updateComment(existingComment, existingComment.getCommentId(), comment.getText());
        }
        return this._postParentCommentComment(externalReferenceCode, parentComment.getGroupId(), parentComment.getCommentId(), parentComment.getClassName(), parentComment.getClassPK(), comment.getText());
    }

    @Override
    public Comment putSiteDocumentByExternalReferenceCodeDocumentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String documentExternalReferenceCode, String externalReferenceCode, Comment comment) throws Exception {
        DLFileEntry dlFileEntry = this._dlFileEntryService.getFileEntryByExternalReferenceCode(siteId.longValue(), documentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment existingComment = this._fetchComment(externalReferenceCode, siteId, DLFileEntry.class.getName(), dlFileEntry.getFileEntryId());
        if (existingComment != null) {
            return this._updateComment(existingComment, existingComment.getCommentId(), comment.getText());
        }
        return this._postEntityComment(externalReferenceCode, dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), comment.getText());
    }

    @Override
    public Comment putSiteStructuredContentByExternalReferenceCodeStructuredContentExternalReferenceCodeCommentByExternalReferenceCode(Long siteId, String structuredContentExternalReferenceCode, String externalReferenceCode, Comment comment) throws Exception {
        JournalArticle journalArticle = this._journalArticleService.getLatestArticleByExternalReferenceCode(siteId.longValue(), structuredContentExternalReferenceCode);
        com.liferay.portal.kernel.comment.Comment existingComment = this._fetchComment(externalReferenceCode, siteId, JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (existingComment != null) {
            return this._updateComment(existingComment, existingComment.getCommentId(), comment.getText());
        }
        return this._postEntityComment(externalReferenceCode, journalArticle.getGroupId(), JournalArticle.class.getName(), journalArticle.getResourcePrimKey(), comment.getText());
    }

    private Function<String, ServiceContext> _createServiceContextFunction() {
        return className -> {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setWorkflowAction(1);
            return serviceContext;
        };
    }

    private void _deleteComment(Long commentId) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkDeletePermission(commentId.longValue());
        this._commentManager.deleteComment(commentId.longValue());
    }

    private com.liferay.portal.kernel.comment.Comment _fetchComment(String externalReferenceCode, long siteId, String className, long classPK) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._commentManager.fetchComment(siteId, externalReferenceCode);
        if (comment != null && this._isAssociated(className, classPK, comment)) {
            return comment;
        }
        return null;
    }

    private com.liferay.portal.kernel.comment.Comment _getComment(String externalReferenceCode, long siteId, String className, long classPK) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._commentManager.getComment(siteId, externalReferenceCode);
        if (!this._isAssociated(className, classPK, comment)) {
            StringBundler sb = new StringBundler(5);
            sb.append("A comment with external reference code ");
            sb.append(externalReferenceCode);
            sb.append(" and site ID ");
            sb.append(siteId);
            sb.append(" is associated to another entity");
            throw new NoSuchCommentException(sb.toString());
        }
        return comment;
    }

    private com.liferay.portal.kernel.comment.Comment _getComment(String externalReferenceCode, Long siteId) throws Exception {
        com.liferay.portal.kernel.comment.Comment comment = this._commentManager.getComment(siteId.longValue(), externalReferenceCode);
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkViewPermission(this.contextCompany.getCompanyId(), comment.getGroupId(), comment.getClassName(), comment.getClassPK());
        return comment;
    }

    private com.liferay.portal.kernel.comment.Comment _getComment(String externalReferenceCode, String parentExternalReferenceCode, Long siteId) throws Exception {
        com.liferay.portal.kernel.comment.Comment parentComment = this._getComment(parentExternalReferenceCode, siteId);
        com.liferay.portal.kernel.comment.Comment comment = this._getComment(externalReferenceCode, siteId, parentComment.getClassName(), parentComment.getClassPK());
        if (parentComment.getCommentId() != comment.getParentCommentId()) {
            StringBundler sb = new StringBundler(6);
            sb.append("No comment exists with external reference code ");
            sb.append(externalReferenceCode);
            sb.append(", site ID ");
            sb.append(parentComment.getGroupId());
            sb.append(", and parent comment with external reference code ");
            sb.append(parentExternalReferenceCode);
            throw new NotFoundException(sb.toString());
        }
        return comment;
    }

    private Page<Comment> _getComments(Map<String, Map<String, String>> actions, Long commentId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(commentId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)MBMessage.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
            searchContext.setAttribute("searchPermissionContext", (Serializable)((Object)""));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setVulcanCheckPermissions(false);
        }, (Sort[])sorts, document -> CommentUtil.toComment(this._commentManager.fetchComment(GetterUtil.getLong((String)document.get("entryClassPK"))), this._commentManager, this._portal));
    }

    private DiscussionPermission _getDiscussionPermission() {
        return this._commentManager.getDiscussionPermission(PermissionThreadLocal.getPermissionChecker());
    }

    private long _getUserId() {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return permissionChecker.getUserId();
    }

    private boolean _isAssociated(String className, long classPK, com.liferay.portal.kernel.comment.Comment comment) {
        return className.equals(comment.getClassName()) && classPK == comment.getClassPK();
    }

    private Comment _postComment(UnsafeSupplier<Long, ? extends Exception> addCommentUnsafeSupplier, String className, long classPK, long groupId) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkAddPermission(this.contextCompany.getCompanyId(), groupId, className, classPK);
        try {
            long commentId = (Long)addCommentUnsafeSupplier.get();
            return CommentUtil.toComment(this._commentManager.fetchComment(commentId), this._commentManager, this._portal);
        }
        catch (DiscussionMaxCommentsException discussionMaxCommentsException) {
            throw new ClientErrorException("Maximum number of comments has been reached", 422, (Throwable)discussionMaxCommentsException);
        }
        catch (DuplicateCommentException duplicateCommentException) {
            throw new ClientErrorException("A comment with the same text already exists", 409, (Throwable)duplicateCommentException);
        }
        catch (MessageSubjectException messageSubjectException) {
            throw new ClientErrorException("Comment text is null", 422, (Throwable)messageSubjectException);
        }
    }

    private Comment _postEntityComment(String externalReferenceCode, long groupId, String className, long classPK, String text) throws Exception {
        return this._postComment((UnsafeSupplier<Long, ? extends Exception>)((UnsafeSupplier)() -> this._commentManager.addComment(externalReferenceCode, this._getUserId(), groupId, className, classPK, "", "", StringBundler.concat((String[])new String[]{"<p>", text, "</p>"}), this._createServiceContextFunction())), className, classPK, groupId);
    }

    private Comment _postParentCommentComment(String externalReferenceCode, long groupId, long parentCommentId, String className, long classPK, String text) throws Exception {
        return this._postComment((UnsafeSupplier<Long, ? extends Exception>)((UnsafeSupplier)() -> this._commentManager.addComment(externalReferenceCode, this._getUserId(), className, classPK, "", parentCommentId, "", StringBundler.concat((String[])new String[]{"<p>", text, "</p>"}), this._createServiceContextFunction())), className, classPK, groupId);
    }

    private Comment _updateComment(com.liferay.portal.kernel.comment.Comment comment, long commentId, String text) throws Exception {
        DiscussionPermission discussionPermission = this._getDiscussionPermission();
        discussionPermission.checkUpdatePermission(commentId);
        try {
            this._commentManager.updateComment(comment.getUserId(), comment.getClassName(), comment.getClassPK(), comment.getCommentId(), "", StringBundler.concat((String[])new String[]{"<p>", text, "</p>"}), this._createServiceContextFunction());
            return CommentUtil.toComment(this._commentManager.fetchComment(comment.getCommentId()), this._commentManager, this._portal);
        }
        catch (MessageSubjectException messageSubjectException) {
            throw new ClientErrorException("Comment text is null", 422, (Throwable)messageSubjectException);
        }
    }
}

