/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardThread;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardThreadResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardThreadResourceImpl
implements EntityModelResource,
MessageBoardThreadResource,
VulcanBatchEngineTaskItemDelegate<MessageBoardThread> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<MessageBoardThread>, UnsafeConsumer<MessageBoardThread, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseMessageBoardThreadResourceImpl.class);

    @Operation(description="Retrieves the message board section's threads. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/message-board-sections/{messageBoardSectionId}/message-board-threads")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardThread> getMessageBoardSectionMessageBoardThreadsPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardSectionId") Long messageBoardSectionId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new message board thread inside a section.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-sections/{messageBoardSectionId}/message-board-threads")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardThread postMessageBoardSectionMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardSectionId") Long messageBoardSectionId, MessageBoardThread messageBoardThread) throws Exception {
        return new MessageBoardThread();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json"})
    @Path(value="/message-board-sections/{messageBoardSectionId}/message-board-threads/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postMessageBoardSectionMessageBoardThreadBatch(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardSectionId") Long messageBoardSectionId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardThread.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="dateCreated"), @Parameter(in=ParameterIn.QUERY, name="dateModified"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="messageBoardSectionId"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/message-board-threads/ranked")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardThread> getMessageBoardThreadsRankedPage(@Parameter(hidden=true) @QueryParam(value="dateCreated") Date dateCreated, @Parameter(hidden=true) @QueryParam(value="dateModified") Date dateModified, @Parameter(hidden=true) @QueryParam(value="messageBoardSectionId") Long messageBoardSectionId, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Deletes the message board thread and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @DELETE
    @Path(value="/message-board-threads/{messageBoardThreadId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/message-board-threads/batch")
    @Produces(value={"application/json"})
    public Response deleteMessageBoardThreadBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(MessageBoardThread.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Retrieves the message board thread.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/message-board-threads/{messageBoardThreadId}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardThread getMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
        return new MessageBoardThread();
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/message-board-threads/{messageBoardThreadId}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardThread patchMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MessageBoardThread messageBoardThread) throws Exception {
        MessageBoardThread existingMessageBoardThread = this.getMessageBoardThread(messageBoardThreadId);
        if (messageBoardThread.getActions() != null) {
            existingMessageBoardThread.setActions(messageBoardThread.getActions());
        }
        if (messageBoardThread.getArticleBody() != null) {
            existingMessageBoardThread.setArticleBody(messageBoardThread.getArticleBody());
        }
        if (messageBoardThread.getDateCreated() != null) {
            existingMessageBoardThread.setDateCreated(messageBoardThread.getDateCreated());
        }
        if (messageBoardThread.getDateModified() != null) {
            existingMessageBoardThread.setDateModified(messageBoardThread.getDateModified());
        }
        if (messageBoardThread.getEncodingFormat() != null) {
            existingMessageBoardThread.setEncodingFormat(messageBoardThread.getEncodingFormat());
        }
        if (messageBoardThread.getFriendlyUrlPath() != null) {
            existingMessageBoardThread.setFriendlyUrlPath(messageBoardThread.getFriendlyUrlPath());
        }
        if (messageBoardThread.getHasValidAnswer() != null) {
            existingMessageBoardThread.setHasValidAnswer(messageBoardThread.getHasValidAnswer());
        }
        if (messageBoardThread.getHeadline() != null) {
            existingMessageBoardThread.setHeadline(messageBoardThread.getHeadline());
        }
        if (messageBoardThread.getKeywords() != null) {
            existingMessageBoardThread.setKeywords(messageBoardThread.getKeywords());
        }
        if (messageBoardThread.getLocked() != null) {
            existingMessageBoardThread.setLocked(messageBoardThread.getLocked());
        }
        if (messageBoardThread.getMessageBoardRootMessageId() != null) {
            existingMessageBoardThread.setMessageBoardRootMessageId(messageBoardThread.getMessageBoardRootMessageId());
        }
        if (messageBoardThread.getMessageBoardSectionId() != null) {
            existingMessageBoardThread.setMessageBoardSectionId(messageBoardThread.getMessageBoardSectionId());
        }
        if (messageBoardThread.getNumberOfMessageBoardAttachments() != null) {
            existingMessageBoardThread.setNumberOfMessageBoardAttachments(messageBoardThread.getNumberOfMessageBoardAttachments());
        }
        if (messageBoardThread.getNumberOfMessageBoardMessages() != null) {
            existingMessageBoardThread.setNumberOfMessageBoardMessages(messageBoardThread.getNumberOfMessageBoardMessages());
        }
        if (messageBoardThread.getSeen() != null) {
            existingMessageBoardThread.setSeen(messageBoardThread.getSeen());
        }
        if (messageBoardThread.getShowAsQuestion() != null) {
            existingMessageBoardThread.setShowAsQuestion(messageBoardThread.getShowAsQuestion());
        }
        if (messageBoardThread.getSiteId() != null) {
            existingMessageBoardThread.setSiteId(messageBoardThread.getSiteId());
        }
        if (messageBoardThread.getStatus() != null) {
            existingMessageBoardThread.setStatus(messageBoardThread.getStatus());
        }
        if (messageBoardThread.getSubscribed() != null) {
            existingMessageBoardThread.setSubscribed(messageBoardThread.getSubscribed());
        }
        if (messageBoardThread.getTaxonomyCategoryIds() != null) {
            existingMessageBoardThread.setTaxonomyCategoryIds(messageBoardThread.getTaxonomyCategoryIds());
        }
        if (messageBoardThread.getThreadType() != null) {
            existingMessageBoardThread.setThreadType(messageBoardThread.getThreadType());
        }
        if (messageBoardThread.getViewCount() != null) {
            existingMessageBoardThread.setViewCount(messageBoardThread.getViewCount());
        }
        if (messageBoardThread.getViewableBy() != null) {
            existingMessageBoardThread.setViewableBy(messageBoardThread.getViewableBy());
        }
        this.preparePatch(messageBoardThread, existingMessageBoardThread);
        return this.putMessageBoardThread(messageBoardThreadId, existingMessageBoardThread);
    }

    @Operation(description="Replaces the message board thread with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-threads/{messageBoardThreadId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public MessageBoardThread putMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MessageBoardThread messageBoardThread) throws Exception {
        return new MessageBoardThread();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json"})
    @Path(value="/message-board-threads/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putMessageBoardThreadBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(MessageBoardThread.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the message board thread's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @DELETE
    @Path(value="/message-board-threads/{messageBoardThreadId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public void deleteMessageBoardThreadMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
    }

    @Operation(description="Retrieves the message board thread's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/message-board-threads/{messageBoardThreadId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    public Rating getMessageBoardThreadMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
        return new Rating();
    }

    @Operation(description="Creates the message board thread's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-threads/{messageBoardThreadId}/my-rating")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Rating postMessageBoardThreadMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, Rating rating) throws Exception {
        return new Rating();
    }

    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/message-board-threads/{messageBoardThreadId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Rating putMessageBoardThreadMyRating(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, Rating rating) throws Exception {
        return new Rating();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/message-board-threads/{messageBoardThreadId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getMessageBoardThreadPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(messageBoardThreadId);
        Long resourceId = this.getPermissionCheckerResourceId(messageBoardThreadId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(messageBoardThreadId));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getMessageBoardThreadPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putMessageBoardThreadPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putMessageBoardThreadPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(messageBoardThreadId);
        Long resourceId = this.getPermissionCheckerResourceId(messageBoardThreadId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)resourceId, (Long)this.getPermissionCheckerGroupId(messageBoardThreadId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(messageBoardThreadId).longValue(), resourceName, String.valueOf(resourceId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getMessageBoardThreadPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putMessageBoardThreadPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putMessageBoardThreadSubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public void putMessageBoardThreadUnsubscribe(@Parameter(hidden=true) @NotNull @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
    }

    @Operation(description="Retrieves the site's message board threads. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/sites/{siteId}/message-board-threads")
    @Produces(value={"application/json", "application/xml"})
    public Page<MessageBoardThread> getSiteMessageBoardThreadsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Creates a new message board thread.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteId}/message-board-threads")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardThread postSiteMessageBoardThread(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, MessageBoardThread messageBoardThread) throws Exception {
        return new MessageBoardThread();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteId}/message-board-threads/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteMessageBoardThreadBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardThread.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="friendlyUrlPath"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/sites/{siteId}/message-board-threads/by-friendly-url-path/{friendlyUrlPath}")
    @Produces(value={"application/json", "application/xml"})
    public MessageBoardThread getSiteMessageBoardThreadByFriendlyUrlPath(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @NotNull @PathParam(value="friendlyUrlPath") String friendlyUrlPath) throws Exception {
        return new MessageBoardThread();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @GET
    @Path(value="/sites/{siteId}/message-board-threads/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteMessageBoardThreadPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteMessageBoardThreadPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteMessageBoardThreadPermissionsPage", portletName, siteId)).build(), siteId, portletName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="MessageBoardThread")})
    @Path(value="/sites/{siteId}/message-board-threads/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteMessageBoardThreadPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getSiteMessageBoardThreadPermissionsPage", portletName, siteId)).put((Object)"replace", this.addAction("PERMISSIONS", "putSiteMessageBoardThreadPermissionsPage", portletName, siteId)).build(), siteId, portletName, null);
    }

    public void create(Collection<MessageBoardThread> messageBoardThreads, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer messageBoardThreadUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            if (parameters.containsKey("messageBoardSectionId")) {
                messageBoardThreadUnsafeConsumer = messageBoardThread -> this.postMessageBoardSectionMessageBoardThread(Long.parseLong((String)parameters.get("messageBoardSectionId")), (MessageBoardThread)messageBoardThread);
            } else if (parameters.containsKey("siteId")) {
                messageBoardThreadUnsafeConsumer = messageBoardThread -> this.postSiteMessageBoardThread((Long)parameters.get("siteId"), (MessageBoardThread)messageBoardThread);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [messageBoardSectionId, siteId]");
            }
        }
        if (messageBoardThreadUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for MessageBoardThread");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(messageBoardThreads, (Object)messageBoardThreadUnsafeConsumer);
        } else {
            for (MessageBoardThread messageBoardThread2 : messageBoardThreads) {
                messageBoardThreadUnsafeConsumer.accept((Object)messageBoardThread2);
            }
        }
    }

    public void delete(Collection<MessageBoardThread> messageBoardThreads, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardThread messageBoardThread : messageBoardThreads) {
            this.deleteMessageBoardThread(messageBoardThread.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<MessageBoardThread> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteId")) {
            return this.getSiteMessageBoardThreadsPage((Long)parameters.get("siteId"), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        if (parameters.containsKey("messageBoardSectionId")) {
            return this.getMessageBoardSectionMessageBoardThreadsPage(Long.parseLong((String)((Object)parameters.get("messageBoardSectionId"))), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId, messageBoardSectionId]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<MessageBoardThread> messageBoardThreads, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer messageBoardThreadUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            messageBoardThreadUnsafeConsumer = messageBoardThread -> this.patchMessageBoardThread(messageBoardThread.getId() != null ? messageBoardThread.getId() : Long.parseLong((String)parameters.get("messageBoardThreadId")), (MessageBoardThread)messageBoardThread);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            messageBoardThreadUnsafeConsumer = messageBoardThread -> this.putMessageBoardThread(messageBoardThread.getId() != null ? messageBoardThread.getId() : Long.parseLong((String)parameters.get("messageBoardThreadId")), (MessageBoardThread)messageBoardThread);
        }
        if (messageBoardThreadUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for MessageBoardThread");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(messageBoardThreads, (Object)messageBoardThreadUnsafeConsumer);
        } else {
            for (MessageBoardThread messageBoardThread2 : messageBoardThreads) {
                messageBoardThreadUnsafeConsumer.accept((Object)messageBoardThread2);
            }
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)id, (List)resourceActions, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
        }
        return Page.of(actions, this.transform(PermissionUtil.getResourcePermissions((long)this.contextCompany.getCompanyId(), (long)id, (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService), resourcePermission -> PermissionUtil.toPermission((List)resourceActions, (ResourcePermission)resourcePermission, (Role)this.roleLocalService.getRole(resourcePermission.getRoleId()))));
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<MessageBoardThread>, UnsafeConsumer<MessageBoardThread, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(MessageBoardThread messageBoardThread, MessageBoardThread existingMessageBoardThread) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

