/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.UriInfo;

public class TaxonomyCategoryBriefUtil {
    public static TaxonomyCategoryBrief toTaxonomyCategoryBrief(final AssetCategory assetCategory, final DTOConverterContext dtoConverterContext) throws Exception {
        return new TaxonomyCategoryBrief(){
            {
                this.embeddedTaxonomyCategory = TaxonomyCategoryBriefUtil._toTaxonomyCategory(assetCategory.getCategoryId(), dtoConverterContext);
                this.taxonomyCategoryId = assetCategory.getCategoryId();
                this.taxonomyCategoryName = assetCategory.getTitle(dtoConverterContext.getLocale());
                this.taxonomyCategoryName_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)assetCategory.getTitleMap());
            }
        };
    }

    private static Object _toTaxonomyCategory(long categoryId, DTOConverterContext dtoConverterContext) throws Exception {
        Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
        if (uriInfoOptional.map(UriInfo::getQueryParameters).map(queryParameters -> (String)queryParameters.getFirst((Object)"nestedFields")).map(nestedFields -> nestedFields.contains("embeddedTaxonomyCategory")).orElse(false).booleanValue()) {
            DTOConverterRegistry dtoConverterRegistry = dtoConverterContext.getDTOConverterRegistry();
            DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter(AssetCategory.class.getName());
            if (dtoConverter == null) {
                return null;
            }
            return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), Collections.emptyMap(), dtoConverterRegistry, dtoConverterContext.getHttpServletRequest(), (Object)categoryId, dtoConverterContext.getLocale(), (UriInfo)uriInfoOptional.orElse(null), dtoConverterContext.getUser()));
        }
        return null;
    }
}

