/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.headless.delivery.dto.v1_0.ClassPKReference;
import com.liferay.headless.delivery.dto.v1_0.Fragment;
import com.liferay.headless.delivery.dto.v1_0.FragmentField;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldBackgroundImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldHTML;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldText;
import com.liferay.headless.delivery.dto.v1_0.FragmentImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentImageClassPKReference;
import com.liferay.headless.delivery.dto.v1_0.FragmentImageConfiguration;
import com.liferay.headless.delivery.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.FragmentLinkValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentMappedValue;
import com.liferay.headless.delivery.dto.v1_0.FragmentStyle;
import com.liferay.headless.delivery.dto.v1_0.FragmentViewport;
import com.liferay.headless.delivery.dto.v1_0.Mapping;
import com.liferay.headless.delivery.dto.v1_0.PageFragmentInstanceDefinition;
import com.liferay.headless.delivery.dto.v1_0.WidgetInstance;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.WidgetInstanceMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.FragmentMappedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.LocalizedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.StyledLayoutStructureItemUtil;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PageFragmentInstanceDefinitionMapper.class})
public class PageFragmentInstanceDefinitionMapper {
    private static final Log _log = LogFactoryUtil.getLog(PageFragmentInstanceDefinitionMapper.class);
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private WidgetInstanceMapper _widgetInstanceMapper;

    public PageFragmentInstanceDefinition getPageFragmentInstanceDefinition(final FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem, final FragmentStyle pageFragmentInstanceDefinitionFragmentStyle, final FragmentViewport[] pageFragmentInstanceDefinitionFragmentViewports, final boolean saveInlineContent, final boolean saveMapping) {
        final FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            return null;
        }
        final String rendererKey = fragmentEntryLink.getRendererKey();
        final FragmentEntry fragmentEntry = this._getFragmentEntry(this._fragmentCollectionContributorRegistry, fragmentEntryLink.getFragmentEntryId(), rendererKey);
        return new PageFragmentInstanceDefinition(){
            {
                this.cssClasses = StyledLayoutStructureItemUtil.getCssClasses((StyledLayoutStructureItem)fragmentStyledLayoutStructureItem);
                this.customCSS = StyledLayoutStructureItemUtil.getCustomCSS((StyledLayoutStructureItem)fragmentStyledLayoutStructureItem);
                this.customCSSViewports = StyledLayoutStructureItemUtil.getCustomCSSViewports((StyledLayoutStructureItem)fragmentStyledLayoutStructureItem);
                this.fragment = new Fragment(){
                    {
                        this.key = PageFragmentInstanceDefinitionMapper.this._getFragmentKey(fragmentEntry, rendererKey);
                        this.setSiteKey(() -> {
                            if (fragmentEntry == null || fragmentEntry.getGroupId() == 0L) {
                                return null;
                            }
                            Group group = PageFragmentInstanceDefinitionMapper.this._groupLocalService.fetchGroup(fragmentEntry.getGroupId());
                            if (group == null) {
                                return null;
                            }
                            return group.getGroupKey();
                        });
                    }
                };
                this.fragmentConfig = PageFragmentInstanceDefinitionMapper.this._getFragmentConfig(fragmentEntryLink);
                this.fragmentFields = PageFragmentInstanceDefinitionMapper.this._getFragmentFields(fragmentEntryLink, saveInlineContent, saveMapping);
                this.fragmentStyle = pageFragmentInstanceDefinitionFragmentStyle;
                this.fragmentViewports = pageFragmentInstanceDefinitionFragmentViewports;
                this.indexed = fragmentStyledLayoutStructureItem.isIndexed();
                this.widgetInstances = PageFragmentInstanceDefinitionMapper.this._getWidgetInstances(fragmentEntryLink);
                this.setName(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getName());
            }
        };
    }

    private List<FragmentField> _getBackgroundImageFragmentFields(JSONObject jsonObject, final boolean saveMapping) {
        if (jsonObject == null) {
            return Collections.emptyList();
        }
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>();
        Set backgroundImageIds = jsonObject.keySet();
        for (final String backgroundImageId : backgroundImageIds) {
            final JSONObject imageJSONObject = jsonObject.getJSONObject(backgroundImageId);
            final Map<String, String> localizedValues = LocalizedValueUtil.toLocalizedValues(imageJSONObject);
            fragmentFields.add(new FragmentField(){
                {
                    this.id = backgroundImageId;
                    this.value = PageFragmentInstanceDefinitionMapper.this._toFragmentFieldBackgroundImage(imageJSONObject, localizedValues, saveMapping);
                }
            });
        }
        return fragmentFields;
    }

    private Map<String, Object> _getFragmentConfig(final FragmentEntryLink fragmentEntryLink) {
        try {
            JSONObject editableValuesJSONObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
            JSONObject configJSONObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
            if (configJSONObject == null && (configJSONObject = this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(fragmentEntryLink.getConfiguration())) == null) {
                return Collections.emptyMap();
            }
            final JSONObject jsonObject = configJSONObject;
            return new HashMap<String, Object>(){
                {
                    for (String key : jsonObject.keySet()) {
                        JSONObject valueJSONObject;
                        Object value = PageFragmentInstanceDefinitionMapper.this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), LocaleUtil.getMostRelevantLocale(), key);
                        if (value == null) {
                            value = jsonObject.get(key);
                        }
                        if (value instanceof JSONObject && (valueJSONObject = (JSONObject)value).has("color")) {
                            value = valueJSONObject.getString("color");
                        }
                        if (value instanceof JSONArray || value instanceof JSONObject) {
                            JSONDeserializer jsonDeserializer = PageFragmentInstanceDefinitionMapper.this._jsonFactory.createJSONDeserializer();
                            value = jsonDeserializer.deserialize(value.toString());
                        }
                        this.put(key, value);
                    }
                }
            };
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return null;
        }
    }

    private FragmentEntry _getFragmentEntry(FragmentCollectionContributorRegistry fragmentCollectionContributorRegistry, long fragmentEntryId, String rendererKey) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        Map fragmentEntries = fragmentCollectionContributorRegistry.getFragmentEntries();
        return (FragmentEntry)fragmentEntries.get(rendererKey);
    }

    private FragmentField[] _getFragmentFields(FragmentEntryLink fragmentEntryLink, boolean saveInlineContent, boolean saveMapping) {
        if (!saveInlineContent && !saveMapping) {
            return new FragmentField[0];
        }
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = this._jsonFactory.createJSONObject(fragmentEntryLink.getEditableValues());
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return null;
        }
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>(this._getBackgroundImageFragmentFields(editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor"), saveMapping));
        JSONObject jsonObject = editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor");
        if (jsonObject != null) {
            fragmentFields.addAll(this._getTextFragmentFields(EditableFragmentEntryProcessorUtil.getEditableTypes((String)fragmentEntryLink.getHtml()), jsonObject, saveMapping));
        }
        return fragmentFields.toArray(new FragmentField[0]);
    }

    private String _getFragmentKey(FragmentEntry fragmentEntry, String rendererKey) {
        if (fragmentEntry != null) {
            return fragmentEntry.getFragmentEntryKey();
        }
        return rendererKey;
    }

    private Function<Object, String> _getImageURLTransformerFunction() {
        return object -> {
            if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                return jsonObject.getString("url");
            }
            return "";
        };
    }

    private List<FragmentField> _getTextFragmentFields(Map<String, String> editableTypes, JSONObject jsonObject, boolean saveMapping) {
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>();
        Set textIds = jsonObject.keySet();
        for (String textId : textIds) {
            fragmentFields.add(this._toFragmentField(editableTypes, jsonObject, saveMapping, textId));
        }
        return fragmentFields;
    }

    private WidgetInstance[] _getWidgetInstances(FragmentEntryLink fragmentEntryLink) {
        List fragmentEntryLinkPortletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        if (ListUtil.isNull((List)fragmentEntryLinkPortletIds)) {
            return null;
        }
        ArrayList<WidgetInstance> widgetInstances = new ArrayList<WidgetInstance>();
        for (String fragmentEntryLinkPortletId : fragmentEntryLinkPortletIds) {
            widgetInstances.add(this._widgetInstanceMapper.getWidgetInstance(fragmentEntryLink, fragmentEntryLinkPortletId));
        }
        return widgetInstances.toArray(new WidgetInstance[0]);
    }

    private Map<String, ClassPKReference> _toClassPKReferences(Map<String, JSONObject> localizedJSONObjects) {
        HashMap<String, ClassPKReference> classPKReferences = new HashMap<String, ClassPKReference>();
        for (Map.Entry<String, JSONObject> entry : localizedJSONObjects.entrySet()) {
            final JSONObject jsonObject = entry.getValue();
            classPKReferences.put(entry.getKey(), new ClassPKReference(){
                {
                    this.className = FileEntry.class.getName();
                    this.classPK = jsonObject.getLong("fileEntryId");
                }
            });
        }
        return classPKReferences;
    }

    private FragmentInlineValue _toDefaultMappingValue(JSONObject jsonObject, Function<Object, String> transformerFunction) {
        String className;
        block12: {
            long classNameId = jsonObject.getLong("classNameId");
            if (classNameId == 0L) {
                return null;
            }
            className = null;
            try {
                className = this._portal.getClassName(classNameId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)"Unable to get class name for default mapping value", (Throwable)exception);
            }
        }
        if (Validator.isNull((String)className)) {
            return null;
        }
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, className);
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className);
        if (infoItemFieldValuesProvider == null || infoItemObjectProvider == null) {
            return null;
        }
        long classPK = jsonObject.getLong("classPK");
        try {
            String valueString;
            Object infoItem = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (infoItem == null) {
                return null;
            }
            InfoFieldValue infoFieldValue = infoItemFieldValuesProvider.getInfoFieldValue(infoItem, jsonObject.getString("fieldId"));
            if (infoFieldValue == null) {
                return null;
            }
            Object infoFieldValueValue = infoFieldValue.getValue(LocaleUtil.getMostRelevantLocale());
            if (transformerFunction != null) {
                infoFieldValueValue = transformerFunction.apply(infoFieldValueValue);
            }
            if (Validator.isNull((String)(valueString = GetterUtil.getString((Object)infoFieldValueValue)))) {
                return null;
            }
            return new FragmentInlineValue(){
                {
                    this.value = valueString;
                }
            };
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get default mapped value", (Throwable)exception);
            }
            return null;
        }
    }

    private FragmentInlineValue _toDescriptionFragmentInlineValue(JSONObject jsonObject) {
        JSONObject configJSONObject = jsonObject.getJSONObject("config");
        if (configJSONObject == null) {
            return null;
        }
        final String alt = configJSONObject.getString("alt");
        if (Validator.isNull((String)alt)) {
            return null;
        }
        if (JSONUtil.isValid((String)alt)) {
            JSONObject localizedJSONObject = configJSONObject.getJSONObject("alt");
            final HashMap<String, String> localizedValues = new HashMap<String, String>();
            for (String key : localizedJSONObject.keySet()) {
                localizedValues.put(key, localizedJSONObject.getString(key));
            }
            return new FragmentInlineValue(){
                {
                    this.value_i18n = localizedValues;
                }
            };
        }
        return new FragmentInlineValue(){
            {
                this.value = alt;
            }
        };
    }

    private FragmentField _toFragmentField(final Map<String, String> editableTypes, JSONObject jsonObject, final boolean saveMapping, final String textId) {
        final JSONObject textJSONObject = jsonObject.getJSONObject(textId);
        return new FragmentField(){
            {
                this.id = textId;
                this.setValue(() -> {
                    String type = editableTypes.getOrDefault(textId, "text");
                    if (Objects.equals(type, "html")) {
                        return PageFragmentInstanceDefinitionMapper.this._toFragmentFieldHTML(textJSONObject, saveMapping);
                    }
                    if (Objects.equals(type, "image")) {
                        return PageFragmentInstanceDefinitionMapper.this._toFragmentFieldImage(textJSONObject, saveMapping);
                    }
                    return PageFragmentInstanceDefinitionMapper.this._toFragmentFieldText(textJSONObject, saveMapping);
                });
            }
        };
    }

    private FragmentFieldBackgroundImage _toFragmentFieldBackgroundImage(final JSONObject jsonObject, final Map<String, String> localizedValues, final boolean saveMapping) {
        return new FragmentFieldBackgroundImage(){
            {
                this.backgroundFragmentImage = new FragmentImage(){
                    {
                        this.title = PageFragmentInstanceDefinitionMapper.this._toTitleFragmentInlineValue(jsonObject, localizedValues);
                        this.setUrl(() -> {
                            if (FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping)) {
                                return PageFragmentInstanceDefinitionMapper.this._toFragmentMappedValue(PageFragmentInstanceDefinitionMapper.this._toDefaultMappingValue(jsonObject, PageFragmentInstanceDefinitionMapper.this._getImageURLTransformerFunction()), jsonObject);
                            }
                            return new FragmentInlineValue(){
                                {
                                    this.value_i18n = localizedValues;
                                }
                            };
                        });
                    }
                };
            }
        };
    }

    private FragmentFieldHTML _toFragmentFieldHTML(final JSONObject jsonObject, final boolean saveMapping) {
        return new FragmentFieldHTML(){
            {
                this.setHtml(() -> {
                    if (FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping)) {
                        return PageFragmentInstanceDefinitionMapper.this._toFragmentMappedValue(PageFragmentInstanceDefinitionMapper.this._toDefaultMappingValue(jsonObject, null), jsonObject);
                    }
                    return new FragmentInlineValue(){
                        {
                            this.value_i18n = LocalizedValueUtil.toLocalizedValues(jsonObject);
                        }
                    };
                });
            }
        };
    }

    private FragmentFieldImage _toFragmentFieldImage(final JSONObject jsonObject, final boolean saveMapping) {
        final Map<String, JSONObject> localizedJSONObjects = this._toLocalizedValueJSONObjects(jsonObject);
        final Map<String, String> localizedValues = LocalizedValueUtil.toLocalizedValues(jsonObject);
        final Map<String, String> localizedURLs = this._toLocalizedURLs(localizedJSONObjects, localizedValues);
        return new FragmentFieldImage(){
            {
                this.fragmentImage = new FragmentImage(){
                    {
                        this.description = PageFragmentInstanceDefinitionMapper.this._toDescriptionFragmentInlineValue(jsonObject);
                        this.title = PageFragmentInstanceDefinitionMapper.this._toTitleFragmentInlineValue(jsonObject, localizedValues);
                        this.setFragmentImageClassPKReference(() -> {
                            if (MapUtil.isEmpty((Map)localizedJSONObjects) || MapUtil.isNotEmpty((Map)localizedURLs)) {
                                return null;
                            }
                            return PageFragmentInstanceDefinitionMapper.this._toFragmentImageClassPKReference(jsonObject.getJSONObject("config"), localizedJSONObjects);
                        });
                        this.setUrl(() -> {
                            if (FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping)) {
                                return PageFragmentInstanceDefinitionMapper.this._toFragmentMappedValue(PageFragmentInstanceDefinitionMapper.this._toDefaultMappingValue(jsonObject, PageFragmentInstanceDefinitionMapper.this._getImageURLTransformerFunction()), jsonObject);
                            }
                            return new FragmentInlineValue(){
                                {
                                    this.value_i18n = localizedURLs;
                                }
                            };
                        });
                    }
                };
                this.fragmentLink = PageFragmentInstanceDefinitionMapper.this._toFragmentLink(jsonObject, saveMapping);
            }
        };
    }

    private FragmentFieldText _toFragmentFieldText(final JSONObject jsonObject, final boolean saveMapping) {
        return new FragmentFieldText(){
            {
                this.fragmentLink = PageFragmentInstanceDefinitionMapper.this._toFragmentLink(jsonObject, saveMapping);
                this.setText(() -> {
                    if (FragmentMappedValueUtil.isSaveFragmentMappedValue(jsonObject, saveMapping)) {
                        return PageFragmentInstanceDefinitionMapper.this._toFragmentMappedValue(PageFragmentInstanceDefinitionMapper.this._toDefaultMappingValue(jsonObject, null), jsonObject);
                    }
                    final Map<String, String> localizedValues = LocalizedValueUtil.toLocalizedValues(jsonObject);
                    if (MapUtil.isEmpty(localizedValues)) {
                        return null;
                    }
                    return new FragmentInlineValue(){
                        {
                            this.value_i18n = localizedValues;
                        }
                    };
                });
            }
        };
    }

    private FragmentImageClassPKReference _toFragmentImageClassPKReference(JSONObject configJSONObject, final Map<String, JSONObject> localizedJSONObjects) {
        final JSONObject imageConfigurationJSONObject = configJSONObject.getJSONObject("imageConfiguration");
        return new FragmentImageClassPKReference(){
            {
                this.classPKReferences = PageFragmentInstanceDefinitionMapper.this._toClassPKReferences(localizedJSONObjects);
                this.fragmentImageConfiguration = new FragmentImageConfiguration(){
                    {
                        this.setLandscapeMobile(() -> {
                            if (imageConfigurationJSONObject == null) {
                                return null;
                            }
                            return imageConfigurationJSONObject.getString("landscapeMobile", "auto");
                        });
                        this.setPortraitMobile(() -> {
                            if (imageConfigurationJSONObject == null) {
                                return null;
                            }
                            return imageConfigurationJSONObject.getString("portraitMobile", "auto");
                        });
                        this.setTablet(() -> {
                            if (imageConfigurationJSONObject == null) {
                                return null;
                            }
                            return imageConfigurationJSONObject.getString("tablet", "auto");
                        });
                    }
                };
            }
        };
    }

    private FragmentLink _toFragmentLink(JSONObject jsonObject, final boolean saveMapping) {
        final JSONObject configJSONObject = jsonObject.getJSONObject("config");
        if (configJSONObject == null) {
            return null;
        }
        return new FragmentLink(){
            {
                this.value = PageFragmentInstanceDefinitionMapper.this._toFragmentLinkValue(configJSONObject, saveMapping);
                this.value_i18n = PageFragmentInstanceDefinitionMapper.this._toLocalizedFragmentLinkValues(configJSONObject, saveMapping);
            }
        };
    }

    private FragmentLinkValue _toFragmentLinkValue(final JSONObject configJSONObject, boolean saveMapping) {
        final boolean saveFragmentMappedValue = FragmentMappedValueUtil.isSaveFragmentMappedValue(configJSONObject, saveMapping);
        if (configJSONObject == null || configJSONObject.isNull("href") && !saveFragmentMappedValue) {
            return null;
        }
        return new FragmentLinkValue(){
            {
                this.setHref(() -> {
                    if (saveFragmentMappedValue) {
                        return PageFragmentInstanceDefinitionMapper.this._toFragmentMappedValue(PageFragmentInstanceDefinitionMapper.this._toDefaultMappingValue(configJSONObject, null), configJSONObject);
                    }
                    return new FragmentInlineValue(){
                        {
                            this.setValue(() -> {
                                JSONObject hrefJSONObject = configJSONObject.getJSONObject("href");
                                if (hrefJSONObject != null) {
                                    return null;
                                }
                                return configJSONObject.getString("href");
                            });
                            this.setValue_i18n(() -> {
                                JSONObject hrefJSONObject = configJSONObject.getJSONObject("href");
                                if (hrefJSONObject != null) {
                                    return JSONUtil.toStringMap((JSONObject)hrefJSONObject);
                                }
                                return null;
                            });
                        }
                    };
                });
                this.setTarget(() -> {
                    String target = configJSONObject.getString("target");
                    if (Validator.isNull((String)target)) {
                        return null;
                    }
                    if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                        target = "_self";
                    }
                    return FragmentLinkValue.Target.create((String)StringUtil.upperCaseFirstLetter((String)target.substring(1)));
                });
            }
        };
    }

    private FragmentMappedValue _toFragmentMappedValue(final FragmentInlineValue fragmentInlineValue, final JSONObject jsonObject) {
        return new FragmentMappedValue(){
            {
                this.mapping = new Mapping(){
                    {
                        defaultFragmentInlineValue = fragmentInlineValue;
                        this.fieldKey = FragmentMappedValueUtil.getFieldKey(jsonObject);
                        this.itemReference = FragmentMappedValueUtil.toItemReference(jsonObject);
                    }
                };
            }
        };
    }

    private Map<String, FragmentLinkValue> _toLocalizedFragmentLinkValues(JSONObject configJSONObject, boolean saveMapping) {
        HashMap<String, FragmentLinkValue> fragmentLinkValues = new HashMap<String, FragmentLinkValue>();
        List<String> availableLanguageIds = LocalizedValueUtil.getAvailableLanguageIds();
        for (String languageId : availableLanguageIds) {
            JSONObject localizedJSONObject = configJSONObject.getJSONObject(languageId);
            FragmentLinkValue fragmentLinkValue = this._toFragmentLinkValue(localizedJSONObject, saveMapping);
            if (fragmentLinkValue == null) continue;
            fragmentLinkValues.put(languageId, fragmentLinkValue);
        }
        if (fragmentLinkValues.isEmpty()) {
            return null;
        }
        return fragmentLinkValues;
    }

    private Map<String, String> _toLocalizedURLs(final Map<String, JSONObject> localizedJSONObjects, Map<String, String> localizedValues) {
        HashMap<String, String> localizedURLs = new HashMap<String, String>(){
            {
                for (Map.Entry entry : localizedJSONObjects.entrySet()) {
                    JSONObject localizedJSONObject = (JSONObject)entry.getValue();
                    this.put(entry.getKey(), localizedJSONObject.getString("url"));
                }
            }
        };
        if (!localizedURLs.isEmpty()) {
            return localizedURLs;
        }
        return localizedValues;
    }

    private Map<String, JSONObject> _toLocalizedValueJSONObjects(final JSONObject jsonObject) {
        return new HashMap<String, JSONObject>(){
            {
                List<String> availableLanguageIds = LocalizedValueUtil.getAvailableLanguageIds();
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    JSONObject valueJSONObject = jsonObject.getJSONObject(key);
                    if (!availableLanguageIds.contains(key) || valueJSONObject == null) continue;
                    this.put(key, valueJSONObject);
                }
            }
        };
    }

    private FragmentInlineValue _toTitleFragmentInlineValue(JSONObject jsonObject, Map<String, String> localizedValues) {
        JSONObject configJSONObject = jsonObject.getJSONObject("config");
        if (configJSONObject == null) {
            return null;
        }
        final String imageTitle = configJSONObject.getString("imageTitle");
        if (Validator.isNull((String)imageTitle) || localizedValues.containsValue(imageTitle)) {
            return null;
        }
        return new FragmentInlineValue(){
            {
                this.value = imageTitle;
            }
        };
    }
}

