/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.mapper;

import com.liferay.headless.delivery.dto.v1_0.ClassTypeReference;
import com.liferay.headless.delivery.dto.v1_0.ContextReference;
import com.liferay.headless.delivery.dto.v1_0.FormConfig;
import com.liferay.headless.delivery.dto.v1_0.FragmentInlineValue;
import com.liferay.headless.delivery.dto.v1_0.Layout;
import com.liferay.headless.delivery.dto.v1_0.MessageFormSubmissionResult;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.PageFormDefinition;
import com.liferay.headless.delivery.dto.v1_0.SitePageFormSubmissionResult;
import com.liferay.headless.delivery.dto.v1_0.URLFormSubmissionResult;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.BaseStyledLayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.LayoutStructureItemMapper;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.FragmentMappedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.LocalizedValueUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.mapper.util.StyledLayoutStructureItemUtil;
import com.liferay.layout.converter.AlignConverter;
import com.liferay.layout.converter.ContentDisplayConverter;
import com.liferay.layout.converter.FlexWrapConverter;
import com.liferay.layout.converter.JustifyConverter;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemMapper.class})
public class FormLayoutStructureItemMapper
extends BaseStyledLayoutStructureItemMapper {
    @Reference
    private Portal _portal;

    @Override
    public String getClassName() {
        return FormStyledLayoutStructureItem.class.getName();
    }

    @Override
    public PageElement getPageElement(long groupId, LayoutStructureItem layoutStructureItem, final boolean saveInlineContent, final boolean saveMappingConfiguration) {
        final FormStyledLayoutStructureItem formStyledLayoutStructureItem = (FormStyledLayoutStructureItem)layoutStructureItem;
        return new PageElement(){
            {
                this.definition = new PageFormDefinition(){
                    {
                        this.cssClasses = StyledLayoutStructureItemUtil.getCssClasses((StyledLayoutStructureItem)formStyledLayoutStructureItem);
                        this.customCSS = StyledLayoutStructureItemUtil.getCustomCSS((StyledLayoutStructureItem)formStyledLayoutStructureItem);
                        this.customCSSViewports = StyledLayoutStructureItemUtil.getCustomCSSViewports((StyledLayoutStructureItem)formStyledLayoutStructureItem);
                        this.formConfig = new FormConfig(){
                            {
                                this.formReference = FormLayoutStructureItemMapper.this._toFormReference(formStyledLayoutStructureItem);
                                this.formSuccessSubmissionResult = FormLayoutStructureItemMapper.this._toFormSuccessSubmissionResult(saveInlineContent, saveMappingConfiguration, formStyledLayoutStructureItem);
                            }
                        };
                        this.indexed = formStyledLayoutStructureItem.isIndexed();
                        this.layout = FormLayoutStructureItemMapper.this._toLayout(formStyledLayoutStructureItem);
                        this.setFragmentStyle(() -> {
                            JSONObject itemConfigJSONObject = formStyledLayoutStructureItem.getItemConfigJSONObject();
                            return FormLayoutStructureItemMapper.this.toFragmentStyle(itemConfigJSONObject.getJSONObject("styles"), saveMappingConfiguration);
                        });
                        this.setFragmentViewports(() -> FormLayoutStructureItemMapper.this.getFragmentViewPorts(formStyledLayoutStructureItem.getItemConfigJSONObject()));
                        this.setName(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getName());
                    }
                };
                this.type = PageElement.Type.FORM;
            }
        };
    }

    private Object _toFormReference(final FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        if (formStyledLayoutStructureItem.getFormConfig() == 2) {
            return new ClassTypeReference(){
                {
                    this.className = FormLayoutStructureItemMapper.this._portal.getClassName(formStyledLayoutStructureItem.getClassNameId());
                    this.classType = formStyledLayoutStructureItem.getClassTypeId();
                }
            };
        }
        return new ContextReference(){
            {
                this.contextSource = ContextReference.ContextSource.DISPLAY_PAGE_ITEM;
            }
        };
    }

    private Object _toFormSuccessSubmissionResult(boolean saveInlineContent, boolean saveMappingConfiguration, FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        final JSONObject successMessageJSONObject = formStyledLayoutStructureItem.getSuccessMessageJSONObject();
        if (successMessageJSONObject == null) {
            return null;
        }
        if (saveInlineContent && successMessageJSONObject.has("message")) {
            return new MessageFormSubmissionResult(){
                {
                    this.message = FormLayoutStructureItemMapper.this._toFragmentInlineValue(successMessageJSONObject.getJSONObject("message"));
                }
            };
        }
        if (saveInlineContent && successMessageJSONObject.has("url")) {
            return new URLFormSubmissionResult(){
                {
                    this.url = FormLayoutStructureItemMapper.this._toFragmentInlineValue(successMessageJSONObject.getJSONObject("url"));
                }
            };
        }
        if (saveMappingConfiguration && successMessageJSONObject.has("layout")) {
            final JSONObject layoutJSONObject = successMessageJSONObject.getJSONObject("layout");
            return new SitePageFormSubmissionResult(){
                {
                    this.itemReference = FragmentMappedValueUtil.toLayoutClassFieldsReference(layoutJSONObject);
                }
            };
        }
        return null;
    }

    private FragmentInlineValue _toFragmentInlineValue(final JSONObject jsonObject) {
        return new FragmentInlineValue(){
            {
                this.value_i18n = LocalizedValueUtil.toLocalizedValues(jsonObject);
            }
        };
    }

    private Layout _toLayout(final FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        return new Layout(){
            {
                this.setAlign(() -> {
                    String align = formStyledLayoutStructureItem.getAlign();
                    if (Validator.isNull((String)align)) {
                        return null;
                    }
                    return Layout.Align.create((String)AlignConverter.convertToExternalValue((String)align));
                });
                this.setContentDisplay(() -> {
                    String contentDisplay = formStyledLayoutStructureItem.getContentDisplay();
                    if (Validator.isNull((String)contentDisplay)) {
                        return null;
                    }
                    return Layout.ContentDisplay.create((String)ContentDisplayConverter.convertToExternalValue((String)contentDisplay));
                });
                this.setFlexWrap(() -> {
                    String flexWrap = formStyledLayoutStructureItem.getFlexWrap();
                    if (Validator.isNull((String)flexWrap)) {
                        return null;
                    }
                    return Layout.FlexWrap.create((String)FlexWrapConverter.convertToExternalValue((String)flexWrap));
                });
                this.setJustify(() -> {
                    String justify = formStyledLayoutStructureItem.getJustify();
                    if (Validator.isNull((String)justify)) {
                        return null;
                    }
                    return Layout.Justify.create((String)JustifyConverter.convertToExternalValue((String)justify));
                });
                this.setWidthType(() -> {
                    String widthType = formStyledLayoutStructureItem.getWidthType();
                    if (Validator.isNotNull((String)widthType)) {
                        return Layout.WidthType.create((String)StringUtil.upperCaseFirstLetter((String)widthType));
                    }
                    return null;
                });
            }
        };
    }
}

