/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.document.library.util.DLURLHelper;
import com.liferay.headless.delivery.dto.v1_0.WikiPageAttachment;
import com.liferay.headless.delivery.internal.dto.v1_0.util.ContentValueUtil;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiPageAttachmentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.WikiPageAttachmentResource;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import java.io.InputStream;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-page-attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiPageAttachmentResource.class})
public class WikiPageAttachmentResourceImpl
extends BaseWikiPageAttachmentResourceImpl {
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;

    @Override
    public void deleteWikiPageAttachment(Long wikiPageAttachmentId) throws Exception {
        this._portletFileRepository.deletePortletFileEntry(wikiPageAttachmentId.longValue());
    }

    @Override
    public WikiPageAttachment getWikiPageAttachment(Long wikiPageAttachmentId) throws Exception {
        return this._toWikiPageAttachment(this._portletFileRepository.getPortletFileEntry(wikiPageAttachmentId.longValue()));
    }

    @Override
    public Page<WikiPageAttachment> getWikiPageWikiPageAttachmentsPage(Long wikiPageId) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)wikiPage, "VIEW");
        return Page.of(this.transform(wikiPage.getAttachmentsFileEntries(), this::_toWikiPageAttachment));
    }

    @Override
    public WikiPageAttachment postWikiPageWikiPageAttachment(Long wikiPageId, MultipartBody multipartBody) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.getPageByPageId(wikiPageId.longValue());
        this._wikiPageModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)wikiPage, "UPDATE");
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        Folder folder = wikiPage.addAttachmentsFolder();
        return this._toWikiPageAttachment(this._portletFileRepository.addPortletFileEntry(wikiPage.getGroupId(), this.contextUser.getUserId(), WikiPage.class.getName(), wikiPage.getResourcePrimKey(), "com.liferay.wiki", folder.getFolderId(), binaryFile.getInputStream(), binaryFile.getFileName(), binaryFile.getFileName(), false));
    }

    private WikiPageAttachment _toWikiPageAttachment(final FileEntry fileEntry) throws Exception {
        return new WikiPageAttachment(){
            {
                this.contentUrl = WikiPageAttachmentResourceImpl.this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false);
                this.contentValue = ContentValueUtil.toContentValue("contentValue", (UnsafeSupplier<InputStream, Exception>)((UnsafeSupplier)() -> ((FileEntry)fileEntry).getContentStream()), Optional.of(WikiPageAttachmentResourceImpl.this.contextUriInfo));
                this.encodingFormat = fileEntry.getMimeType();
                this.fileExtension = fileEntry.getExtension();
                this.id = fileEntry.getFileEntryId();
                this.sizeInBytes = fileEntry.getSize();
                this.title = fileEntry.getTitle();
            }
        };
    }
}

