/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.WikiNodeEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseWikiNodeResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.WikiNodeResource;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageService;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/wiki-node.properties"}, scope=ServiceScope.PROTOTYPE, service={WikiNodeResource.class})
public class WikiNodeResourceImpl
extends BaseWikiNodeResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new WikiNodeEntityModel();
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WikiNodeService _wikiNodeService;
    @Reference
    private WikiPageService _wikiPageService;

    @Override
    public void deleteWikiNode(Long wikiNodeId) throws Exception {
        this._wikiNodeService.deleteNode(wikiNodeId.longValue());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    @Override
    public Page<com.liferay.headless.delivery.dto.v1_0.WikiNode> getSiteWikiNodesPage(Long siteId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_NODE", "postSiteWikiNode", "com.liferay.wiki", siteId)).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, WikiNode.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toWikiNode(this._wikiNodeService.getNode(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode getWikiNode(Long wikiNodeId) throws Exception {
        return this._toWikiNode(this._wikiNodeService.getNode(wikiNodeId.longValue()));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode postSiteWikiNode(Long siteId, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        return this._toWikiNode(this._wikiNodeService.addNode(wikiNode.getName(), wikiNode.getDescription(), ServiceContextRequestUtil.createServiceContext((long)siteId, (HttpServletRequest)this.contextHttpServletRequest, null)));
    }

    @Override
    public com.liferay.headless.delivery.dto.v1_0.WikiNode putWikiNode(Long wikiNodeId, com.liferay.headless.delivery.dto.v1_0.WikiNode wikiNode) throws Exception {
        WikiNode serviceBuilderWikiNode = this._wikiNodeService.getNode(wikiNodeId.longValue());
        return this._toWikiNode(this._wikiNodeService.updateNode(wikiNodeId.longValue(), wikiNode.getName(), wikiNode.getDescription(), ServiceContextRequestUtil.createServiceContext((long)serviceBuilderWikiNode.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)wikiNode.getViewableByAsString())));
    }

    @Override
    public void putWikiNodeSubscribe(Long wikiNodeId) throws Exception {
        this._wikiNodeService.subscribeNode(wikiNodeId.longValue());
    }

    @Override
    public void putWikiNodeUnsubscribe(Long wikiNodeId) throws Exception {
        this._wikiNodeService.unsubscribeNode(wikiNodeId.longValue());
    }

    private com.liferay.headless.delivery.dto.v1_0.WikiNode _toWikiNode(final WikiNode wikiNode) throws Exception {
        return new com.liferay.headless.delivery.dto.v1_0.WikiNode(){
            {
                this.actions = HashMapBuilder.put((Object)"delete", WikiNodeResourceImpl.this.addAction("DELETE", (GroupedModel)wikiNode, "deleteWikiNode")).put((Object)"get", WikiNodeResourceImpl.this.addAction("VIEW", (GroupedModel)wikiNode, "getWikiNode")).put((Object)"replace", WikiNodeResourceImpl.this.addAction("UPDATE", (GroupedModel)wikiNode, "putWikiNode")).put((Object)"subscribe", WikiNodeResourceImpl.this.addAction("SUBSCRIBE", (GroupedModel)wikiNode, "putWikiNodeSubscribe")).put((Object)"unsubscribe", WikiNodeResourceImpl.this.addAction("SUBSCRIBE", (GroupedModel)wikiNode, "putWikiNodeUnsubscribe")).build();
                this.creator = CreatorUtil.toCreator(WikiNodeResourceImpl.this._portal, Optional.of(WikiNodeResourceImpl.this.contextUriInfo), WikiNodeResourceImpl.this._userLocalService.fetchUser(wikiNode.getUserId()));
                this.dateCreated = wikiNode.getCreateDate();
                this.dateModified = wikiNode.getModifiedDate();
                this.description = wikiNode.getDescription();
                this.id = wikiNode.getNodeId();
                this.name = wikiNode.getName();
                this.numberOfWikiPages = WikiNodeResourceImpl.this._wikiPageService.getPagesCount(wikiNode.getGroupId(), wikiNode.getNodeId(), true);
                this.siteId = wikiNode.getGroupId();
                this.subscribed = WikiNodeResourceImpl.this._subscriptionLocalService.isSubscribed(wikiNode.getCompanyId(), WikiNodeResourceImpl.this.contextUser.getUserId(), WikiNode.class.getName(), wikiNode.getNodeId());
            }
        };
    }
}

