/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardMessageDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardMessageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardMessageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardMessageResource;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-message.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardMessageResource.class})
public class MessageBoardMessageResourceImpl
extends BaseMessageBoardMessageResourceImpl
implements EntityModelResource {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MessageBoardMessageDTOConverter _messageBoardMessageDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.deleteMessage(messageBoardMessageId.longValue());
    }

    @Override
    public void deleteMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(messageBoardMessageId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardMessageEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(MBMessage.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public MessageBoardMessage getMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        return this._toMessageBoardMessage(this._mbMessageService.getMessage(messageBoardMessageId.longValue()));
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardMessageMessageBoardMessagesPage(Long parentMessageBoardMessageId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBMessage mbMessage = this._mbMessageService.getMessage(parentMessageBoardMessageId.longValue());
        return this._getMessageBoardMessagesPage(HashMapBuilder.put((Object)"get-child-messages", this.addAction("VIEW", mbMessage.getMessageId(), "getMessageBoardMessageMessageBoardMessagesPage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).put((Object)"reply-to-message", this.addAction("REPLY_TO_MESSAGE", mbMessage.getMessageId(), "postMessageBoardMessageMessageBoardMessage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).build(), parentMessageBoardMessageId, null, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(messageBoardMessageId);
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardThreadMessageBoardMessagesPage(Long messageBoardThreadId, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._getMessageBoardMessagesPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_MESSAGE", mbThread.getThreadId(), "postMessageBoardThreadMessageBoardMessage", mbThread.getUserId(), "com.liferay.message.boards", mbThread.getGroupId())).put((Object)"get", this.addAction("VIEW", mbThread.getThreadId(), "getMessageBoardThreadMessageBoardMessagesPage", mbThread.getUserId(), "com.liferay.message.boards", mbThread.getGroupId())).build(), mbThread.getRootMessageId(), null, false, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardMessage getSiteMessageBoardMessageByFriendlyUrlPath(Long siteId, String friendlyUrlPath) throws Exception {
        MBMessage mbMessage = this._mbMessageService.fetchMBMessageByUrlSubject(siteId.longValue(), friendlyUrlPath);
        if (mbMessage == null) {
            throw new NoSuchMessageException("No message exists with friendly URL path " + friendlyUrlPath);
        }
        return this._toMessageBoardMessage(mbMessage);
    }

    @Override
    public Page<MessageBoardMessage> getSiteMessageBoardMessagesPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getMessageBoardMessagesPage(HashMapBuilder.put((Object)"get", this.addAction("VIEW", "getSiteMessageBoardMessagesPage", "com.liferay.message.boards", siteId)).build(), null, siteId, flatten, search, aggregation, filter, pagination, sorts);
    }

    @Override
    public MessageBoardMessage postMessageBoardMessageMessageBoardMessage(Long parentMessageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return this._addMessageBoardThread(parentMessageBoardMessageId, messageBoardMessage);
    }

    @Override
    public Rating postMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    @Override
    public MessageBoardMessage postMessageBoardThreadMessageBoardMessage(Long messageBoardThreadId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._addMessageBoardThread(mbThread.getRootMessageId(), messageBoardMessage);
    }

    @Override
    public MessageBoardMessage putMessageBoardMessage(Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        if (messageBoardMessage.getArticleBody() == null && messageBoardMessage.getHeadline() == null) {
            throw new BadRequestException("Headline and article body are both null");
        }
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            MBMessage parentMBMessage = this._mbMessageService.getMessage(mbMessage.getParentMessageId());
            headline = "RE: " + parentMBMessage.getSubject();
        }
        mbMessage = this._mbMessageService.updateDiscussionMessage(mbMessage.getClassName(), mbMessage.getClassPK(), messageBoardMessageId.longValue(), headline, messageBoardMessage.getArticleBody(), this._getServiceContext(messageBoardMessage, mbMessage.getGroupId()));
        if (messageBoardMessage.getShowAsAnswer().booleanValue() != mbMessage.isAnswer()) {
            this._updateAnswer(mbMessage, messageBoardMessage);
        }
        return this._toMessageBoardMessage(mbMessage);
    }

    @Override
    public Rating putMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    @Override
    public void putMessageBoardMessageSubscribe(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.subscribeMessage(messageBoardMessageId.longValue());
    }

    @Override
    public void putMessageBoardMessageUnsubscribe(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.unsubscribeMessage(messageBoardMessageId.longValue());
    }

    private MessageBoardMessage _addMessageBoardThread(Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        String encodingFormat;
        MBMessage parentMBMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            headline = "RE: " + parentMBMessage.getSubject();
        }
        if ((encodingFormat = messageBoardMessage.getEncodingFormat()) == null) {
            encodingFormat = MBMessageConstants.DEFAULT_FORMAT;
        }
        MBMessage mbMessage = this._mbMessageService.addMessage(messageBoardMessageId.longValue(), headline, messageBoardMessage.getArticleBody(), encodingFormat, Collections.emptyList(), GetterUtil.getBoolean((Object)messageBoardMessage.getAnonymous()), 0.0, false, this._getServiceContext(messageBoardMessage, parentMBMessage.getGroupId()));
        this._updateAnswer(mbMessage, messageBoardMessage);
        return this._toMessageBoardMessage(mbMessage);
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardMessage messageBoardMessage) {
        return CustomFieldsUtil.toMap(MBMessage.class.getName(), this.contextCompany.getCompanyId(), messageBoardMessage.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<MessageBoardMessage> _getMessageBoardMessagesPage(Map<String, Map<String, String>> actions, Long messageBoardMessageId, Long siteId, Boolean flatten, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (messageBoardMessageId != null) {
            MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
            siteId = mbMessage.getGroupId();
        }
        long messageBoardMessageSiteId = siteId;
        return SearchUtil.search(actions, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (messageBoardMessageId != null) {
                booleanFilter.add((Filter)new TermFilter("entryClassPK", String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST_NOT);
                String field = "parentMessageId";
                if (GetterUtil.getBoolean((Object)flatten)) {
                    field = "treePath";
                }
                booleanFilter.add((Filter)new TermFilter(field, String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST);
            } else {
                if (!GetterUtil.getBoolean((Object)flatten)) {
                    booleanFilter.add((Filter)new TermFilter("categoryId", "0"), BooleanClauseOccur.MUST);
                }
                booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(messageBoardMessageSiteId)), BooleanClauseOccur.MUST);
            }
        }, (Filter)filter, MBMessage.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toMessageBoardMessage(this._mbMessageService.getMessage(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private ServiceContext _getServiceContext(MessageBoardMessage messageBoardMessage, long siteId) {
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardMessage), (long)siteId, (HttpServletRequest)this.contextHttpServletRequest, (String)messageBoardMessage.getViewableByAsString());
        String link = this.contextHttpServletRequest.getHeader("Link");
        if (link == null) {
            UriBuilder uriBuilder = UriInfoUtil.getBaseUriBuilder((UriInfo)this.contextUriInfo);
            link = String.valueOf(uriBuilder.replacePath("/").build(new Object[0]));
        }
        serviceContext.setAttribute("entryURL", (Serializable)((Object)link));
        if (messageBoardMessage.getId() == null) {
            serviceContext.setCommand("add");
        } else {
            serviceContext.setCommand("update");
        }
        return serviceContext;
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(MBMessage.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            MBMessage mbMessage = this._mbMessageService.getMessage(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", (GroupedModel)mbMessage, "postMessageBoardMessageMyRating")).put((Object)"delete", this.addAction("VIEW", (GroupedModel)mbMessage, "deleteMessageBoardMessageMyRating")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbMessage, "getMessageBoardMessageMyRating")).put((Object)"replace", this.addAction("VIEW", (GroupedModel)mbMessage, "putMessageBoardMessageMyRating")).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private MessageBoardMessage _toMessageBoardMessage(MBMessage mbMessage) throws Exception {
        return this._messageBoardMessageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", (GroupedModel)mbMessage, "deleteMessageBoardMessage")).put((Object)"get", this.addAction("VIEW", (GroupedModel)mbMessage, "getMessageBoardMessage")).put((Object)"replace", this.addAction("UPDATE", (GroupedModel)mbMessage, "putMessageBoardMessage")).put((Object)"reply-to-message", this.addAction("REPLY_TO_MESSAGE", mbMessage.getMessageId(), "postMessageBoardMessageMessageBoardMessage", mbMessage.getUserId(), "com.liferay.message.boards", mbMessage.getGroupId())).put((Object)"subscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbMessage, "putMessageBoardMessageSubscribe")).put((Object)"unsubscribe", this.addAction("SUBSCRIBE", (GroupedModel)mbMessage, "putMessageBoardMessageSubscribe")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)mbMessage, "patchMessageBoardMessage")).build(), this._dtoConverterRegistry, (Object)mbMessage.getPrimaryKey(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateAnswer(MBMessage mbMessage, MessageBoardMessage messageBoardMessage) throws Exception {
        Boolean showAsAnswer = messageBoardMessage.getShowAsAnswer();
        if (showAsAnswer != null) {
            this._mbMessageService.updateAnswer(mbMessage.getMessageId(), showAsAnswer.booleanValue(), false);
            mbMessage.setAnswer(showAsAnswer.booleanValue());
        }
    }
}

