/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextRequestUtil;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.DocumentType;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.DocumentDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.DDMFormValuesUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.DocumentEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseDocumentResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/document.properties"}, scope=ServiceScope.PROTOTYPE, service={DocumentResource.class})
public class DocumentResourceImpl
extends BaseDocumentResourceImpl
implements EntityModelResource {
    private static final Log _log = LogFactoryUtil.getLog(DocumentResourceImpl.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMBeanTranslator _ddmBeanTranslator;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DocumentDTOConverter _documentDTOConverter;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteDocument(Long documentId) throws Exception {
        this._dlAppService.deleteFileEntry(documentId.longValue());
    }

    @Override
    public void deleteDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(documentId);
    }

    @Override
    public Page<Document> getAssetLibraryDocumentsPage(Long assetLibraryId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", "postAssetLibraryDocument", "com.liferay.document.library", assetLibraryId)).put((Object)"get", this.addAction("VIEW", "getAssetLibraryDocumentsPage", "com.liferay.document.library", assetLibraryId)).build(), this._createDocumentsPageBooleanQueryUnsafeConsumer(assetLibraryId, flatten), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Document getDocument(Long documentId) throws Exception {
        return this._toDocument(this._dlAppService.getFileEntry(documentId.longValue()));
    }

    @Override
    public Page<Document> getDocumentFolderDocumentsPage(Long documentFolderId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", folder.getFolderId(), "postDocumentFolderDocument", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).put((Object)"get", this.addAction("VIEW", folder.getFolderId(), "getDocumentFolderDocumentsPage", folder.getUserId(), "com.liferay.document.library", folder.getGroupId())).build(), (UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            String field = "folderId";
            if (GetterUtil.getBoolean((Object)flatten)) {
                field = "treePath";
            }
            booleanFilter.add((Filter)new TermFilter(field, String.valueOf(documentFolderId)), BooleanClauseOccur.MUST);
        }), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Rating getDocumentMyRating(Long documentId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(documentId);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new DocumentEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(DLFileEntry.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public Page<Document> getSiteDocumentsPage(Long siteId, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getDocumentsPage(HashMapBuilder.put((Object)"create", this.addAction("ADD_DOCUMENT", "postSiteDocument", "com.liferay.document.library", siteId)).put((Object)"get", this.addAction("VIEW", "getSiteDocumentsPage", "com.liferay.document.library", siteId)).build(), this._createDocumentsPageBooleanQueryUnsafeConsumer(siteId, flatten), search, aggregation, filter, pagination, sorts);
    }

    @Override
    public Document patchDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        FileEntry existingFileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        BinaryFile binaryFile = Optional.ofNullable(multipartBody.getBinaryFile("file")).orElse(new BinaryFile(existingFileEntry.getMimeType(), existingFileEntry.getFileName(), existingFileEntry.getContentStream(), existingFileEntry.getSize()));
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        existingFileEntry = this._moveDocument(documentId, documentOptional, existingFileEntry);
        return this._toDocument(this._dlAppService.updateFileEntry(documentId.longValue(), binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(existingFileEntry.getTitle()), documentOptional.map(Document::getDescription).orElse(existingFileEntry.getDescription()), null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), this._getServiceContext(() -> ArrayUtil.toArray((long[])this._assetCategoryLocalService.getCategoryIds(DLFileEntry.class.getName(), documentId.longValue())), () -> this._assetTagLocalService.getTagNames(DLFileEntry.class.getName(), documentId.longValue()), existingFileEntry.getFolderId(), documentOptional, existingFileEntry.getGroupId())));
    }

    @Override
    public Document postAssetLibraryDocument(Long assetLibraryId, MultipartBody multipartBody) throws Exception {
        return this.postSiteDocument(assetLibraryId, multipartBody);
    }

    @Override
    public Document postDocumentFolderDocument(Long documentFolderId, MultipartBody multipartBody) throws Exception {
        Folder folder = this._dlAppService.getFolder(documentFolderId.longValue());
        return this._addDocument(folder.getRepositoryId(), documentFolderId, folder.getGroupId(), multipartBody);
    }

    @Override
    public Rating postDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    @Override
    public Document postSiteDocument(Long siteId, MultipartBody multipartBody) throws Exception {
        return this._addDocument(siteId, 0L, siteId, multipartBody);
    }

    @Override
    public Document putDocument(Long documentId, MultipartBody multipartBody) throws Exception {
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        if (multipartBody.getBinaryFile("file") == null && !documentOptional.isPresent()) {
            throw new BadRequestException("No document or file found in body");
        }
        FileEntry existingFileEntry = this._dlAppService.getFileEntry(documentId.longValue());
        BinaryFile binaryFile = Optional.ofNullable(multipartBody.getBinaryFile("file")).orElse(new BinaryFile(existingFileEntry.getMimeType(), existingFileEntry.getFileName(), existingFileEntry.getContentStream(), existingFileEntry.getSize()));
        existingFileEntry = this._moveDocument(documentId, documentOptional, existingFileEntry);
        return this._toDocument(this._dlAppService.updateFileEntry(documentId.longValue(), binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(existingFileEntry.getTitle()), (String)documentOptional.map(Document::getDescription).orElse(null), null, DLVersionNumberIncrease.AUTOMATIC, binaryFile.getInputStream(), binaryFile.getSize(), this._getServiceContext(() -> new Long[0], () -> new String[0], existingFileEntry.getFolderId(), documentOptional, existingFileEntry.getGroupId())));
    }

    @Override
    public Rating putDocumentMyRating(Long documentId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), documentId.longValue());
    }

    private Document _addDocument(Long repositoryId, long documentFolderId, Long groupId, MultipartBody multipartBody) throws Exception {
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null) {
            throw new BadRequestException("No file found in body");
        }
        Optional documentOptional = multipartBody.getValueAsInstanceOptional("document", Document.class);
        return this._toDocument(this._dlAppService.addFileEntry(repositoryId.longValue(), documentFolderId, binaryFile.getFileName(), binaryFile.getContentType(), documentOptional.map(Document::getTitle).orElse(binaryFile.getFileName()), (String)documentOptional.map(Document::getDescription).orElse(null), null, binaryFile.getInputStream(), binaryFile.getSize(), this._getServiceContext(() -> new Long[0], () -> new String[0], documentFolderId, documentOptional, groupId)));
    }

    private UnsafeConsumer<BooleanQuery, Exception> _createDocumentsPageBooleanQueryUnsafeConsumer(Long siteId, Boolean flatten) {
        return booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(0L)), BooleanClauseOccur.MUST);
            }
            if (siteId != null) {
                booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(siteId)), BooleanClauseOccur.MUST);
            }
        };
    }

    private Optional<DLFileEntryType> _getDLFileEntryTypeOptional(long documentFolderId, Optional<Document> documentOptional, Long groupId) {
        return documentOptional.map(Document::getDocumentType).map(DocumentType::getName).map(name -> {
            block3: {
                try {
                    for (DLFileEntryType dlFileEntryType : this._dlFileEntryTypeLocalService.getFolderFileEntryTypes(new long[]{groupId}, documentFolderId, true)) {
                        if (!name.equals(dlFileEntryType.getName(this.contextAcceptLanguage.getPreferredLocale()))) continue;
                        return dlFileEntryType;
                    }
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
            return null;
        });
    }

    private Page<Document> _getDocumentsPage(Map<String, Map<String, String>> actions, UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, String keywords, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(actions, booleanQueryUnsafeConsumer, (Filter)filter, DLFileEntry.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toDocument(this._dlAppService.getFileEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private CustomField[] _getExpandoBridgeAttributes(Optional<Document> documentOptional) {
        return documentOptional.map(Document::getCustomFields).orElse(null);
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes1(Optional<Document> documentOptional) {
        return CustomFieldsUtil.toMap(DLFileEntry.class.getName(), this.contextCompany.getCompanyId(), this._getExpandoBridgeAttributes(documentOptional), this.contextAcceptLanguage.getPreferredLocale());
    }

    private ServiceContext _getServiceContext(Supplier<Long[]> defaultCategoriesSupplier, Supplier<String[]> defaultKeywordsSupplier, Long documentFolderId, Optional<Document> documentOptional, Long groupId) throws Exception {
        ServiceContext serviceContext = ServiceContextRequestUtil.createServiceContext((Long[])documentOptional.map(Document::getTaxonomyCategoryIds).orElseGet(defaultCategoriesSupplier), (String[])documentOptional.map(Document::getKeywords).orElseGet(defaultKeywordsSupplier), this._getExpandoBridgeAttributes1(documentOptional), (Long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)documentOptional.map(Document::getViewableByAsString).orElse(Document.ViewableBy.OWNER.getValue()));
        serviceContext.setUserId(this.contextUser.getUserId());
        Optional<DLFileEntryType> dlFileEntryTypeOptional = this._getDLFileEntryTypeOptional(documentFolderId, documentOptional, groupId);
        if (dlFileEntryTypeOptional.isPresent()) {
            DLFileEntryType dlFileEntryType = dlFileEntryTypeOptional.get();
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(dlFileEntryType.getFileEntryTypeId()));
            Document document = documentOptional.get();
            List ddmStructures = dlFileEntryType.getDDMStructures();
            DocumentType documentType = document.getDocumentType();
            ContentField[] contentFields = documentType.getContentFields();
            for (DDMStructure ddmStructure : ddmStructures) {
                com.liferay.dynamic.data.mapping.model.DDMStructure modelDDMStructure = this._ddmStructureService.getStructure(ddmStructure.getStructureId());
                DDMFormValues ddmFormValues = DDMFormValuesUtil.toDDMFormValues(contentFields, modelDDMStructure.getDDMForm(), this._dlAppService, groupId, this._journalArticleService, this._layoutLocalService, this.contextAcceptLanguage.getPreferredLocale(), this.transform(ddmStructure.getRootFieldNames(), arg_0 -> ((com.liferay.dynamic.data.mapping.model.DDMStructure)modelDDMStructure).getDDMFormField(arg_0)));
                serviceContext.setAttribute(com.liferay.dynamic.data.mapping.kernel.DDMFormValues.class.getName() + "#" + ddmStructure.getStructureId(), (Serializable)this._ddmBeanTranslator.translate(ddmFormValues));
            }
        }
        return serviceContext;
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(DLFileEntry.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> {
            FileEntry fileEntry = this._dlAppService.getFileEntry(ratingsEntry.getClassPK());
            return RatingUtil.toRating(HashMapBuilder.put((Object)"create", this.addAction("VIEW", fileEntry.getPrimaryKey(), "postDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"delete", this.addAction("VIEW", fileEntry.getPrimaryKey(), "deleteDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", fileEntry.getPrimaryKey(), "getDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).put((Object)"replace", this.addAction("VIEW", fileEntry.getPrimaryKey(), "putDocumentMyRating", fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getGroupId())).build(), this._portal, ratingsEntry, this._userLocalService);
        }, this.contextUser);
    }

    private FileEntry _moveDocument(Long documentId, Optional<Document> documentOptional, FileEntry existingFileEntry) throws Exception {
        Optional<Long> folderIdOptional = documentOptional.map(Document::getDocumentFolderId).filter(folderId -> folderId.longValue() != existingFileEntry.getFolderId());
        if (folderIdOptional.isPresent()) {
            return this._dlAppService.moveFileEntry(documentId.longValue(), folderIdOptional.get().longValue(), new ServiceContext());
        }
        return existingFileEntry;
    }

    private Document _toDocument(FileEntry fileEntry) throws Exception {
        return this._documentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", this.addAction("DELETE", fileEntry.getPrimaryKey(), "deleteDocument", fileEntry.getUserId(), "com.liferay.document.library.kernel.model.DLFileEntry", fileEntry.getGroupId())).put((Object)"get", this.addAction("VIEW", fileEntry.getPrimaryKey(), "getDocument", fileEntry.getUserId(), "com.liferay.document.library.kernel.model.DLFileEntry", fileEntry.getGroupId())).put((Object)"replace", this.addAction("UPDATE", fileEntry.getPrimaryKey(), "putDocument", fileEntry.getUserId(), "com.liferay.document.library.kernel.model.DLFileEntry", fileEntry.getGroupId())).put((Object)"update", this.addAction("UPDATE", fileEntry.getPrimaryKey(), "patchDocument", fileEntry.getUserId(), "com.liferay.document.library.kernel.model.DLFileEntry", fileEntry.getGroupId())).build(), this._dtoConverterRegistry, (Object)fileEntry.getFileEntryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

