/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.WikiPage;
import com.liferay.headless.delivery.resource.v1_0.WikiPageResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseWikiPageResourceImpl
implements WikiPageResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<WikiPage> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Operation(description="Retrieves the wiki page's of a node. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiNodeId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/wiki-nodes/{wikiNodeId}/wiki-pages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public Page<WikiPage> getWikiNodeWikiPagesPage(@NotNull @Parameter(hidden=true) @PathParam(value="wikiNodeId") Long wikiNodeId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new wiki page")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiNodeId")})
    @Path(value="/wiki-nodes/{wikiNodeId}/wiki-pages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public WikiPage postWikiNodeWikiPage(@NotNull @Parameter(hidden=true) @PathParam(value="wikiNodeId") Long wikiNodeId, WikiPage wikiPage) throws Exception {
        return new WikiPage();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiNodeId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/wiki-nodes/{wikiNodeId}/wiki-pages/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="WikiPage")})
    public Response postWikiNodeWikiPageBatch(@NotNull @Parameter(hidden=true) @PathParam(value="wikiNodeId") Long wikiNodeId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(WikiPage.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Operation(description="Retrieves the child wiki page's of a wiki page.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentWikiPageId")})
    @Path(value="/wiki-pages/{parentWikiPageId}/wiki-pages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public Page<WikiPage> getWikiPageWikiPagesPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentWikiPageId") Long parentWikiPageId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a child wiki page of the parent wiki page.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentWikiPageId")})
    @Path(value="/wiki-pages/{parentWikiPageId}/wiki-pages")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public WikiPage postWikiPageWikiPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentWikiPageId") Long parentWikiPageId, WikiPage wikiPage) throws Exception {
        return new WikiPage();
    }

    @DELETE
    @Operation(description="Deletes the wiki page and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiPageId")})
    @Path(value="/wiki-pages/{wikiPageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public void deleteWikiPage(@NotNull @Parameter(hidden=true) @PathParam(value="wikiPageId") Long wikiPageId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/wiki-pages/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="WikiPage")})
    public Response deleteWikiPageBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(WikiPage.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the wiki page")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiPageId")})
    @Path(value="/wiki-pages/{wikiPageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public WikiPage getWikiPage(@NotNull @Parameter(hidden=true) @PathParam(value="wikiPageId") Long wikiPageId) throws Exception {
        return new WikiPage();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the wiki page with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiPageId")})
    @Path(value="/wiki-pages/{wikiPageId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public WikiPage putWikiPage(@NotNull @Parameter(hidden=true) @PathParam(value="wikiPageId") Long wikiPageId, WikiPage wikiPage) throws Exception {
        return new WikiPage();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/wiki-pages/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="WikiPage")})
    public Response putWikiPageBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(WikiPage.class.getName(), callbackURL, object)).build();
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiPageId")})
    @Path(value="/wiki-pages/{wikiPageId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public void putWikiPageSubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="wikiPageId") Long wikiPageId) throws Exception {
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="wikiPageId")})
    @Path(value="/wiki-pages/{wikiPageId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="WikiPage")})
    public void putWikiPageUnsubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="wikiPageId") Long wikiPageId) throws Exception {
    }

    public void create(Collection<WikiPage> wikiPages, Map<String, Serializable> parameters) throws Exception {
        for (WikiPage wikiPage : wikiPages) {
            this.postWikiNodeWikiPage(Long.valueOf((String)((Object)parameters.get("wikiNodeId"))), wikiPage);
        }
    }

    public void delete(Collection<WikiPage> wikiPages, Map<String, Serializable> parameters) throws Exception {
        for (WikiPage wikiPage : wikiPages) {
            this.deleteWikiPage(wikiPage.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<WikiPage> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getWikiNodeWikiPagesPage((Long)parameters.get("wikiNodeId"), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<WikiPage> wikiPages, Map<String, Serializable> parameters) throws Exception {
        for (WikiPage wikiPage : wikiPages) {
            this.putWikiPage(wikiPage.getId() != null ? wikiPage.getId() : (Long)parameters.get("wikiPageId"), wikiPage);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

