/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.StructuredContent;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseStructuredContentResourceImpl
implements StructuredContentResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<StructuredContent> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getAssetLibraryStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent postAssetLibraryStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/asset-libraries/{assetLibraryId}/structured-contents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Response postAssetLibraryStructuredContentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Operation(description="Retrieves a list of the content structure's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="contentStructureId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/content-structures/{contentStructureId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getContentStructureStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="contentStructureId") Long contentStructureId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @GET
    @Operation(description="Retrieves the site's structured content. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getSiteStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent postSiteStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/structured-contents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Response postSiteStructuredContentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Operation(description="Retrieves a structured content by its key (`articleKey`).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="key")})
    @Path(value="/sites/{siteId}/structured-contents/by-key/{key}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getSiteStructuredContentByKey(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="key") String key) throws Exception {
        return new StructuredContent();
    }

    @GET
    @Operation(description="Retrieves a structured content by its UUID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.PATH, name="uuid")})
    @Path(value="/sites/{siteId}/structured-contents/by-uuid/{uuid}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getSiteStructuredContentByUuid(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @NotNull @Parameter(hidden=true) @PathParam(value="uuid") String uuid) throws Exception {
        return new StructuredContent();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/sites/{siteId}/structured-contents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<Permission> getSiteStructuredContentPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)siteId, (List)this.resourceActionLocalService.getResourceActions(portletName), (String)portletName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/structured-contents/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void putSiteStructuredContentPermission(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, Permission[] permissions) throws Exception {
        String portletName = this.getPermissionCheckerPortletName(siteId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)portletName, (long)siteId, (Long)siteId);
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), siteId.longValue(), portletName, String.valueOf(siteId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)siteId, (String)portletName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @GET
    @Operation(description="Retrieves the folder's structured content. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<StructuredContent> getStructuredContentFolderStructuredContentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new structured content in the folder.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent postStructuredContentFolderStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentFolderId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/structured-content-folders/{structuredContentFolderId}/structured-contents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Response postStructuredContentFolderStructuredContentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentFolderId") Long structuredContentFolderId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(StructuredContent.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the structured content and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void deleteStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/structured-contents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Response deleteStructuredContentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(StructuredContent.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the structured content via its ID.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent getStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent patchStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        StructuredContent existingStructuredContent = this.getStructuredContent(structuredContentId);
        if (structuredContent.getActions() != null) {
            existingStructuredContent.setActions(structuredContent.getActions());
        }
        if (structuredContent.getAssetLibraryKey() != null) {
            existingStructuredContent.setAssetLibraryKey(structuredContent.getAssetLibraryKey());
        }
        if (structuredContent.getAvailableLanguages() != null) {
            existingStructuredContent.setAvailableLanguages(structuredContent.getAvailableLanguages());
        }
        if (structuredContent.getContentStructureId() != null) {
            existingStructuredContent.setContentStructureId(structuredContent.getContentStructureId());
        }
        if (structuredContent.getDateCreated() != null) {
            existingStructuredContent.setDateCreated(structuredContent.getDateCreated());
        }
        if (structuredContent.getDateModified() != null) {
            existingStructuredContent.setDateModified(structuredContent.getDateModified());
        }
        if (structuredContent.getDatePublished() != null) {
            existingStructuredContent.setDatePublished(structuredContent.getDatePublished());
        }
        if (structuredContent.getDescription() != null) {
            existingStructuredContent.setDescription(structuredContent.getDescription());
        }
        if (structuredContent.getDescription_i18n() != null) {
            existingStructuredContent.setDescription_i18n(structuredContent.getDescription_i18n());
        }
        if (structuredContent.getFriendlyUrlPath() != null) {
            existingStructuredContent.setFriendlyUrlPath(structuredContent.getFriendlyUrlPath());
        }
        if (structuredContent.getFriendlyUrlPath_i18n() != null) {
            existingStructuredContent.setFriendlyUrlPath_i18n(structuredContent.getFriendlyUrlPath_i18n());
        }
        if (structuredContent.getKey() != null) {
            existingStructuredContent.setKey(structuredContent.getKey());
        }
        if (structuredContent.getKeywords() != null) {
            existingStructuredContent.setKeywords(structuredContent.getKeywords());
        }
        if (structuredContent.getNumberOfComments() != null) {
            existingStructuredContent.setNumberOfComments(structuredContent.getNumberOfComments());
        }
        if (structuredContent.getSiteId() != null) {
            existingStructuredContent.setSiteId(structuredContent.getSiteId());
        }
        if (structuredContent.getSubscribed() != null) {
            existingStructuredContent.setSubscribed(structuredContent.getSubscribed());
        }
        if (structuredContent.getTaxonomyCategoryIds() != null) {
            existingStructuredContent.setTaxonomyCategoryIds(structuredContent.getTaxonomyCategoryIds());
        }
        if (structuredContent.getTitle() != null) {
            existingStructuredContent.setTitle(structuredContent.getTitle());
        }
        if (structuredContent.getTitle_i18n() != null) {
            existingStructuredContent.setTitle_i18n(structuredContent.getTitle_i18n());
        }
        if (structuredContent.getUuid() != null) {
            existingStructuredContent.setUuid(structuredContent.getUuid());
        }
        if (structuredContent.getViewableBy() != null) {
            existingStructuredContent.setViewableBy(structuredContent.getViewableBy());
        }
        this.preparePatch(structuredContent, existingStructuredContent);
        return this.putStructuredContent(structuredContentId, existingStructuredContent);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the structured content with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public StructuredContent putStructuredContent(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, StructuredContent structuredContent) throws Exception {
        return new StructuredContent();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/structured-contents/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Response putStructuredContentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(StructuredContent.class.getName(), callbackURL, object)).build();
    }

    @DELETE
    @Operation(description="Deletes the structured content's rating and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void deleteStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the structured content's rating.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating getStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Create a rating for the structured content.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating postStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the rating with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/my-rating")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Rating putStructuredContentMyRating(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Rating rating) throws Exception {
        return new Rating();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Path(value="/structured-contents/{structuredContentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public Page<Permission> getStructuredContentPermissionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(structuredContentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)structuredContentId, (Long)this.getPermissionCheckerGroupId(structuredContentId));
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)structuredContentId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void putStructuredContentPermission(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(structuredContentId);
        PermissionUtil.checkPermission((String)"PERMISSIONS", (GroupLocalService)this.groupLocalService, (String)resourceName, (long)structuredContentId, (Long)this.getPermissionCheckerGroupId(structuredContentId));
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), 0L, resourceName, String.valueOf(structuredContentId), ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)structuredContentId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService));
    }

    @GET
    @Operation(description="Retrieves the structured content's rendered template (the result of applying the structure's values to a template).")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId"), @Parameter(in=ParameterIn.PATH, name="contentTemplateId")})
    @Path(value="/structured-contents/{structuredContentId}/rendered-content/{contentTemplateId}")
    @Produces(value={"text/html"})
    @Tags(value={@Tag(name="StructuredContent")})
    public String getStructuredContentRenderedContentTemplate(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId, @NotNull @Parameter(hidden=true) @PathParam(value="contentTemplateId") String contentTemplateId) throws Exception {
        return "";
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void putStructuredContentSubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="structuredContentId")})
    @Path(value="/structured-contents/{structuredContentId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="StructuredContent")})
    public void putStructuredContentUnsubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="structuredContentId") Long structuredContentId) throws Exception {
    }

    public void create(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContent structuredContent : structuredContents) {
            this.postSiteStructuredContent(Long.valueOf((String)((Object)parameters.get("siteId"))), structuredContent);
        }
    }

    public void delete(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContent structuredContent : structuredContents) {
            this.deleteStructuredContent(structuredContent.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<StructuredContent> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteStructuredContentsPage((Long)parameters.get("siteId"), (Boolean)parameters.get("flatten"), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<StructuredContent> structuredContents, Map<String, Serializable> parameters) throws Exception {
        for (StructuredContent structuredContent : structuredContents) {
            this.putStructuredContent(structuredContent.getId() != null ? structuredContent.getId() : (Long)parameters.get("structuredContentId"), structuredContent);
        }
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(StructuredContent structuredContent, StructuredContent existingStructuredContent) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

