/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardSection;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardSectionResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardSectionResourceImpl
implements MessageBoardSectionResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<MessageBoardSection> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @DELETE
    @Operation(description="Deletes the message board section and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public void deleteMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/message-board-sections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public Response deleteMessageBoardSectionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(MessageBoardSection.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the message board section.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public MessageBoardSection getMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId) throws Exception {
        return new MessageBoardSection();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public MessageBoardSection patchMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        MessageBoardSection existingMessageBoardSection = this.getMessageBoardSection(messageBoardSectionId);
        if (messageBoardSection.getActions() != null) {
            existingMessageBoardSection.setActions(messageBoardSection.getActions());
        }
        if (messageBoardSection.getDateCreated() != null) {
            existingMessageBoardSection.setDateCreated(messageBoardSection.getDateCreated());
        }
        if (messageBoardSection.getDateModified() != null) {
            existingMessageBoardSection.setDateModified(messageBoardSection.getDateModified());
        }
        if (messageBoardSection.getDescription() != null) {
            existingMessageBoardSection.setDescription(messageBoardSection.getDescription());
        }
        if (messageBoardSection.getNumberOfMessageBoardSections() != null) {
            existingMessageBoardSection.setNumberOfMessageBoardSections(messageBoardSection.getNumberOfMessageBoardSections());
        }
        if (messageBoardSection.getNumberOfMessageBoardThreads() != null) {
            existingMessageBoardSection.setNumberOfMessageBoardThreads(messageBoardSection.getNumberOfMessageBoardThreads());
        }
        if (messageBoardSection.getParentMessageBoardSectionId() != null) {
            existingMessageBoardSection.setParentMessageBoardSectionId(messageBoardSection.getParentMessageBoardSectionId());
        }
        if (messageBoardSection.getSiteId() != null) {
            existingMessageBoardSection.setSiteId(messageBoardSection.getSiteId());
        }
        if (messageBoardSection.getSubscribed() != null) {
            existingMessageBoardSection.setSubscribed(messageBoardSection.getSubscribed());
        }
        if (messageBoardSection.getTitle() != null) {
            existingMessageBoardSection.setTitle(messageBoardSection.getTitle());
        }
        if (messageBoardSection.getViewableBy() != null) {
            existingMessageBoardSection.setViewableBy(messageBoardSection.getViewableBy());
        }
        this.preparePatch(messageBoardSection, existingMessageBoardSection);
        return this.putMessageBoardSection(messageBoardSectionId, existingMessageBoardSection);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the message board section with the information sent in the request body. Any missing fields are deleted, unless they are required.")
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public MessageBoardSection putMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        return new MessageBoardSection();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/message-board-sections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public Response putMessageBoardSectionBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(MessageBoardSection.class.getName(), callbackURL, object)).build();
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}/subscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public void putMessageBoardSectionSubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId) throws Exception {
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardSectionId")})
    @Path(value="/message-board-sections/{messageBoardSectionId}/unsubscribe")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public void putMessageBoardSectionUnsubscribe(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardSectionId") Long messageBoardSectionId) throws Exception {
    }

    @GET
    @Operation(description="Retrieves the parent message board section's subsections. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardSectionId"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/message-board-sections/{parentMessageBoardSectionId}/message-board-sections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public Page<MessageBoardSection> getMessageBoardSectionMessageBoardSectionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="parentMessageBoardSectionId") Long parentMessageBoardSectionId, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new message board section in the parent section.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="parentMessageBoardSectionId")})
    @Path(value="/message-board-sections/{parentMessageBoardSectionId}/message-board-sections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public MessageBoardSection postMessageBoardSectionMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="parentMessageBoardSectionId") Long parentMessageBoardSectionId, MessageBoardSection messageBoardSection) throws Exception {
        return new MessageBoardSection();
    }

    @GET
    @Operation(description="Retrieves the site's message board sections. Results can be paginated, filtered, searched, flattened, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/message-board-sections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public Page<MessageBoardSection> getSiteMessageBoardSectionsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new message board section.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Path(value="/sites/{siteId}/message-board-sections")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public MessageBoardSection postSiteMessageBoardSection(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, MessageBoardSection messageBoardSection) throws Exception {
        return new MessageBoardSection();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/sites/{siteId}/message-board-sections/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardSection")})
    public Response postSiteMessageBoardSectionBatch(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardSection.class.getName(), callbackURL, null, object)).build();
    }

    public void create(Collection<MessageBoardSection> messageBoardSections, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardSection messageBoardSection : messageBoardSections) {
            this.postSiteMessageBoardSection(Long.valueOf((String)((Object)parameters.get("siteId"))), messageBoardSection);
        }
    }

    public void delete(Collection<MessageBoardSection> messageBoardSections, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardSection messageBoardSection : messageBoardSections) {
            this.deleteMessageBoardSection(messageBoardSection.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<MessageBoardSection> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteMessageBoardSectionsPage((Long)parameters.get("siteId"), (Boolean)parameters.get("flatten"), search, null, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<MessageBoardSection> messageBoardSections, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardSection messageBoardSection : messageBoardSections) {
            this.putMessageBoardSection(messageBoardSection.getId() != null ? messageBoardSection.getId() : (Long)parameters.get("messageBoardSectionId"), messageBoardSection);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(MessageBoardSection messageBoardSection, MessageBoardSection existingMessageBoardSection) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

