/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.headless.delivery.dto.v1_0.MessageBoardAttachment;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardAttachmentResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMessageBoardAttachmentResourceImpl
implements MessageBoardAttachmentResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<MessageBoardAttachment> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @DELETE
    @Operation(description="Deletes the message board attachment and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardAttachmentId")})
    @Path(value="/message-board-attachments/{messageBoardAttachmentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public void deleteMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardAttachmentId") Long messageBoardAttachmentId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/message-board-attachments/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Response deleteMessageBoardAttachmentBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(MessageBoardAttachment.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="Retrieves the message board attachment.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardAttachmentId")})
    @Path(value="/message-board-attachments/{messageBoardAttachmentId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment getMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardAttachmentId") Long messageBoardAttachmentId) throws Exception {
        return new MessageBoardAttachment();
    }

    @GET
    @Operation(description="Retrieves the message board message's attachments.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Page<MessageBoardAttachment> getMessageBoardMessageMessageBoardAttachmentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates an attachment for the message board message. The request body must be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`MessageBoardAttachment`) with the metadata.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment postMessageBoardMessageMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MultipartBody multipartBody) throws Exception {
        return new MessageBoardAttachment();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardMessageId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/message-board-messages/{messageBoardMessageId}/message-board-attachments/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Response postMessageBoardMessageMessageBoardAttachmentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardMessageId") Long messageBoardMessageId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardAttachment.class.getName(), callbackURL, null, object)).build();
    }

    @GET
    @Operation(description="Retrieves the message board thread's attachments.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Page<MessageBoardAttachment> getMessageBoardThreadMessageBoardAttachmentsPage(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"multipart/form-data"})
    @Operation(description="Creates a new attachment for the message board thread. The request body should be `multipart/form-data` with two parts, the file's bytes (`file`), and an optional JSON string (`knowledgeBaseAttachment`) with the metadata.")
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-attachments")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public MessageBoardAttachment postMessageBoardThreadMessageBoardAttachment(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MultipartBody multipartBody) throws Exception {
        return new MessageBoardAttachment();
    }

    @Consumes(value={"application/json"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="messageBoardThreadId"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/message-board-threads/{messageBoardThreadId}/message-board-attachments/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="MessageBoardAttachment")})
    public Response postMessageBoardThreadMessageBoardAttachmentBatch(@NotNull @Parameter(hidden=true) @PathParam(value="messageBoardThreadId") Long messageBoardThreadId, MultipartBody multipartBody, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(MessageBoardAttachment.class.getName(), callbackURL, null, object)).build();
    }

    public void create(Collection<MessageBoardAttachment> messageBoardAttachments, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardAttachment messageBoardAttachment : messageBoardAttachments) {
            this.postMessageBoardMessageMessageBoardAttachment(Long.valueOf((String)((Object)parameters.get("messageBoardMessageId"))), null);
        }
    }

    public void delete(Collection<MessageBoardAttachment> messageBoardAttachments, Map<String, Serializable> parameters) throws Exception {
        for (MessageBoardAttachment messageBoardAttachment : messageBoardAttachments) {
            this.deleteMessageBoardAttachment(messageBoardAttachment.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<MessageBoardAttachment> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getMessageBoardMessageMessageBoardAttachmentsPage((Long)parameters.get("messageBoardMessageId"));
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<MessageBoardAttachment> messageBoardAttachments, Map<String, Serializable> parameters) throws Exception {
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

