/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.odata.entity.v1_0;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntityFieldsProvider.class})
public class EntityFieldsProvider {
    @Reference
    private DDMIndexer _ddmIndexer;

    public List<EntityField> provide(DDMStructure ddmStructure) throws Exception {
        ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
        List ddmFormFields = ddmStructure.getDDMFormFields(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            EntityField entityField = this._createEntityField(ddmStructure, ddmFormField);
            if (entityField == null) continue;
            entityFields.add(entityField);
        }
        return entityFields;
    }

    private EntityField _createEntityField(DDMStructure ddmStructure, DDMFormField ddmFormField) throws Exception {
        String indexType = ddmStructure.getFieldProperty(ddmFormField.getName(), "indexType");
        if (Validator.isNull((String)indexType)) {
            return null;
        }
        if (Objects.equals(ddmFormField.getType(), "checkbox")) {
            return new BooleanEntityField(ddmFormField.getName(), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"));
        }
        if (Objects.equals(ddmFormField.getDataType(), "date")) {
            return new DateEntityField(ddmFormField.getName(), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"), this::_toFieldValue);
        }
        if (Objects.equals(ddmFormField.getDataType(), "double") || Objects.equals(ddmFormField.getDataType(), "number")) {
            return new DoubleEntityField(ddmFormField.getName(), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "Number"));
        }
        if (Objects.equals(ddmFormField.getDataType(), "integer") || Objects.equals(ddmFormField.getDataType(), "long")) {
            return new IntegerEntityField(ddmFormField.getName(), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "Number"));
        }
        if (Objects.equals(ddmFormField.getDataType(), "radio") || Objects.equals(ddmFormField.getType(), "text") && Objects.equals(ddmFormField.getIndexType(), "keyword")) {
            return new StringEntityField(ddmFormField.getName(), locale -> this._toFilterableOrSortableFieldName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"));
        }
        return null;
    }

    private String _toFieldValue(Object fieldValue) {
        DateFormat indexDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        try {
            Date date = indexDateFormat.parse(String.valueOf(fieldValue));
            DateFormat searchDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
            return searchDateFormat.format(date);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    private String _toFilterableOrSortableFieldName(long ddmStructureId, String fieldName, Locale locale, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{this._ddmIndexer.encodeName(ddmStructureId, fieldName, locale), "_", type}));
    }
}

