/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorStatisticsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.message.boards.model.MBMessage"}, service={DTOConverter.class, MessageBoardMessageDTOConverter.class})
public class MessageBoardMessageDTOConverter
implements DTOConverter<MBMessage, MessageBoardMessage> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBStatsUserLocalService _mbStatsUserLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return MessageBoardMessage.class.getSimpleName();
    }

    public MessageBoardMessage toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final MBMessage mbMessage = this._mbMessageService.getMessage(((Long)dtoConverterContext.getId()).longValue());
        final User user = this._userLocalService.fetchUser(mbMessage.getUserId());
        return new MessageBoardMessage(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(MessageBoardMessageDTOConverter.this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbMessage.getMessageId()));
                this.anonymous = mbMessage.isAnonymous();
                this.articleBody = mbMessage.getBody();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), MBMessage.class.getName(), mbMessage.getMessageId(), mbMessage.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = mbMessage.getCreateDate();
                this.dateModified = mbMessage.getModifiedDate();
                this.encodingFormat = mbMessage.getFormat();
                this.friendlyUrlPath = mbMessage.getUrlSubject();
                this.headline = mbMessage.getSubject();
                this.id = mbMessage.getMessageId();
                this.keywords = (String[])ListUtil.toArray((List)MessageBoardMessageDTOConverter.this._assetTagLocalService.getTags(MBMessage.class.getName(), mbMessage.getMessageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.messageBoardSectionId = mbMessage.getCategoryId();
                this.messageBoardThreadId = mbMessage.getThreadId();
                this.numberOfMessageBoardAttachments = mbMessage.getAttachmentsFileEntriesCount();
                this.numberOfMessageBoardMessages = MessageBoardMessageDTOConverter.this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0);
                this.relatedContents = RelatedContentUtil.toRelatedContents(MessageBoardMessageDTOConverter.this._assetEntryLocalService, MessageBoardMessageDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), mbMessage.getModelClassName(), mbMessage.getMessageId(), dtoConverterContext.getLocale());
                this.showAsAnswer = mbMessage.isAnswer();
                this.siteId = mbMessage.getGroupId();
                this.subscribed = MessageBoardMessageDTOConverter.this._subscriptionLocalService.isSubscribed(mbMessage.getCompanyId(), dtoConverterContext.getUserId(), MBThread.class.getName(), mbMessage.getThreadId());
                this.setCreator(() -> {
                    if (mbMessage.isAnonymous()) {
                        return null;
                    }
                    return CreatorUtil.toCreator(MessageBoardMessageDTOConverter.this._portal, dtoConverterContext.getUriInfoOptional(), user);
                });
                this.setCreatorStatistics(() -> {
                    if (mbMessage.isAnonymous() || user == null || user.isDefaultUser()) {
                        return null;
                    }
                    Optional uriInfoOptional = dtoConverterContext.getUriInfoOptional();
                    return CreatorStatisticsUtil.toCreatorStatistics(mbMessage.getGroupId(), String.valueOf(dtoConverterContext.getLocale()), MessageBoardMessageDTOConverter.this._mbStatsUserLocalService, uriInfoOptional.orElse(null), user);
                });
                this.setParentMessageBoardMessageId(() -> {
                    if (mbMessage.getParentMessageId() == 0L) {
                        return null;
                    }
                    return mbMessage.getParentMessageId();
                });
            }
        };
    }
}

