/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0.factory;

import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseAttachmentResource;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={KnowledgeBaseAttachmentResource.Factory.class})
public class KnowledgeBaseAttachmentResourceFactoryImpl
implements KnowledgeBaseAttachmentResource.Factory {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private ComponentServiceObjects<KnowledgeBaseAttachmentResource> _componentServiceObjects;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(permission.checker.type=liberal)")
    private PermissionCheckerFactory _liberalPermissionCheckerFactory;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public KnowledgeBaseAttachmentResource.Builder create() {
        return new KnowledgeBaseAttachmentResource.Builder(){
            private boolean _checkPermissions = true;
            private HttpServletRequest _httpServletRequest;
            private HttpServletResponse _httpServletResponse;
            private Locale _preferredLocale;
            private User _user;

            public KnowledgeBaseAttachmentResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                return (KnowledgeBaseAttachmentResource)ProxyUtil.newProxyInstance((ClassLoader)KnowledgeBaseAttachmentResource.class.getClassLoader(), (Class[])new Class[]{KnowledgeBaseAttachmentResource.class}, (proxy, method, arguments) -> KnowledgeBaseAttachmentResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._httpServletRequest, this._httpServletResponse, this._preferredLocale, this._user));
            }

            public KnowledgeBaseAttachmentResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public KnowledgeBaseAttachmentResource.Builder httpServletRequest(HttpServletRequest httpServletRequest) {
                this._httpServletRequest = httpServletRequest;
                return this;
            }

            public KnowledgeBaseAttachmentResource.Builder httpServletResponse(HttpServletResponse httpServletResponse) {
                this._httpServletResponse = httpServletResponse;
                return this;
            }

            public KnowledgeBaseAttachmentResource.Builder preferredLocale(Locale preferredLocale) {
                this._preferredLocale = preferredLocale;
                return this;
            }

            public KnowledgeBaseAttachmentResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    @Activate
    protected void activate() {
        KnowledgeBaseAttachmentResource.FactoryHolder.factory = this;
    }

    @Deactivate
    protected void deactivate() {
        KnowledgeBaseAttachmentResource.FactoryHolder.factory = null;
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale preferredLocale, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._liberalPermissionCheckerFactory.create(user));
        }
        KnowledgeBaseAttachmentResource knowledgeBaseAttachmentResource = (KnowledgeBaseAttachmentResource)this._componentServiceObjects.getService();
        knowledgeBaseAttachmentResource.setContextAcceptLanguage((AcceptLanguage)new AcceptLanguageImpl(httpServletRequest, preferredLocale, user));
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        knowledgeBaseAttachmentResource.setContextCompany(company);
        knowledgeBaseAttachmentResource.setContextHttpServletRequest(httpServletRequest);
        knowledgeBaseAttachmentResource.setContextHttpServletResponse(httpServletResponse);
        knowledgeBaseAttachmentResource.setContextUser(user);
        knowledgeBaseAttachmentResource.setExpressionConvert(this._expressionConvert);
        knowledgeBaseAttachmentResource.setFilterParserProvider(this._filterParserProvider);
        knowledgeBaseAttachmentResource.setGroupLocalService(this._groupLocalService);
        knowledgeBaseAttachmentResource.setResourceActionLocalService(this._resourceActionLocalService);
        knowledgeBaseAttachmentResource.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        knowledgeBaseAttachmentResource.setRoleLocalService(this._roleLocalService);
        try {
            Object object = method.invoke((Object)knowledgeBaseAttachmentResource, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            this._componentServiceObjects.ungetService((Object)knowledgeBaseAttachmentResource);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private class AcceptLanguageImpl
    implements AcceptLanguage {
        private final HttpServletRequest _httpServletRequest;
        private final Locale _preferredLocale;
        private final User _user;

        public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Locale preferredLocale, User user) {
            this._httpServletRequest = httpServletRequest;
            this._preferredLocale = preferredLocale;
            this._user = user;
        }

        public List<Locale> getLocales() {
            return Arrays.asList(this.getPreferredLocale());
        }

        public String getPreferredLanguageId() {
            return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
        }

        public Locale getPreferredLocale() {
            Locale locale;
            if (this._preferredLocale != null) {
                return this._preferredLocale;
            }
            if (this._httpServletRequest != null && (locale = (Locale)this._httpServletRequest.getAttribute("LOCALE")) != null) {
                return locale;
            }
            return this._user.getLocale();
        }

        public boolean isAcceptAllLanguages() {
            return false;
        }
    }
}

