/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.util;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.headless.delivery.dto.v1_0.ContentDocument;
import com.liferay.headless.delivery.dto.v1_0.ContentField;
import com.liferay.headless.delivery.dto.v1_0.ContentFieldValue;
import com.liferay.headless.delivery.dto.v1_0.Geo;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentLink;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.ws.rs.BadRequestException;

public class DDMValueUtil {
    public static Value toDDMValue(ContentField contentField, DDMFormField ddmFormField, DLAppService dlAppService, long groupId, JournalArticleService journalArticleService, LayoutLocalService layoutLocalService, Locale preferredLocale) {
        ContentFieldValue contentFieldValue = contentField.getContentFieldValue();
        if (contentFieldValue == null) {
            throw new BadRequestException("No value is specified for field " + ddmFormField.getName());
        }
        if (ddmFormField.isLocalizable()) {
            Map localizedContentFieldValues = contentField.getContentFieldValue_i18n();
            if (Objects.equals("ddm-date", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, DDMValueUtil::_toLocalizedDateString, preferredLocale);
            }
            if (Objects.equals("ddm-documentlibrary", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedDocument(localizedContentFieldValue, dlAppService), preferredLocale);
            }
            if (Objects.equals("ddm-image", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedImage(localizedContentFieldValue, dlAppService), preferredLocale);
            }
            if (Objects.equals("ddm-journal-article", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedJournalArticle(localizedContentFieldValue, journalArticleService, locale), preferredLocale);
            }
            if (Objects.equals("ddm-link-to-page", ddmFormField.getType())) {
                return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> DDMValueUtil._toLocalizedLinkToPage(localizedContentFieldValue, groupId, layoutLocalService), preferredLocale);
            }
            return DDMValueUtil._toLocalizedValue(contentFieldValue, localizedContentFieldValues, (localizedContentFieldValue, locale) -> GetterUtil.getString((String)localizedContentFieldValue.getData()), preferredLocale);
        }
        if (Objects.equals("ddm-geolocation", ddmFormField.getType())) {
            Geo geo = contentFieldValue.getGeo();
            if (Objects.isNull(geo) || Objects.isNull(geo.getLatitude()) || Objects.isNull(geo.getLongitude())) {
                throw new BadRequestException("Invalid geo " + geo);
            }
            return new UnlocalizedValue(JSONUtil.put((String)"latitude", (Object)geo.getLatitude()).put("longitude", (Object)geo.getLongitude()).toString());
        }
        return new UnlocalizedValue(GetterUtil.getString((String)contentFieldValue.getData()));
    }

    private static Layout _getLayout(long groupId, LayoutLocalService layoutLocalService, String link) {
        Layout layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, false, link);
        if (layout == null) {
            layout = layoutLocalService.fetchLayoutByFriendlyURL(groupId, true, link);
        }
        if (layout == null) {
            throw new BadRequestException("No page found with friendly URL " + link);
        }
        try {
            LayoutPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        }
        catch (PortalException portalException) {
            throw new BadRequestException("No page found with friendly URL " + link, (Throwable)portalException);
        }
        return layout;
    }

    private static String _toJSON(String description, DLAppService dlAppService, long fileEntryId) {
        FileEntry fileEntry;
        try {
            fileEntry = dlAppService.getFileEntry(fileEntryId);
        }
        catch (Exception exception) {
            throw new BadRequestException("No document exists with ID " + fileEntryId, (Throwable)exception);
        }
        return JSONUtil.put((String)"alt", (Object)description).put("classPK", fileEntry.getFileEntryId()).put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("name", fileEntry.getFileName()).put("resourcePrimKey", fileEntry.getPrimaryKey()).put("title", fileEntry.getFileName()).put("type", "document").put("uuid", fileEntry.getUuid()).toString();
    }

    private static String _toLocalizedDateString(ContentFieldValue contentFieldValue, Locale locale) {
        if (Validator.isNull((String)contentFieldValue.getData())) {
            return "";
        }
        try {
            return DateUtil.getDate((Date)DateUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)contentFieldValue.getData(), (Locale)locale), (String)"yyyy-MM-dd", (Locale)locale);
        }
        catch (ParseException parseException) {
            throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)parseException);
        }
    }

    private static String _toLocalizedDocument(ContentFieldValue contentFieldValue, DLAppService dlAppService) {
        String valueString = "";
        ContentDocument contentDocument = contentFieldValue.getDocument();
        if (contentDocument != null && contentDocument.getId() != null) {
            valueString = DDMValueUtil._toJSON("", dlAppService, contentDocument.getId());
        }
        return valueString;
    }

    private static String _toLocalizedImage(ContentFieldValue contentFieldValue, DLAppService dlAppService) {
        String valueString = "";
        ContentDocument contentDocument = contentFieldValue.getImage();
        if (contentDocument != null && contentDocument.getId() != null) {
            valueString = DDMValueUtil._toJSON(contentDocument.getDescription(), dlAppService, contentDocument.getId());
        }
        return valueString;
    }

    private static String _toLocalizedJournalArticle(ContentFieldValue contentFieldValue, JournalArticleService journalArticleService, Locale locale) {
        String valueString = "";
        StructuredContentLink structuredContentLink = contentFieldValue.getStructuredContentLink();
        if (structuredContentLink != null && structuredContentLink.getId() != null) {
            JournalArticle journalArticle;
            try {
                journalArticle = journalArticleService.getLatestArticle(structuredContentLink.getId().longValue());
            }
            catch (Exception exception) {
                throw new BadRequestException("No structured content exists with ID " + structuredContentLink.getId(), (Throwable)exception);
            }
            valueString = JSONUtil.put((String)"className", (Object)JournalArticle.class.getName()).put("classPK", journalArticle.getResourcePrimKey()).put("title", journalArticle.getTitle(locale)).toString();
        }
        return valueString;
    }

    private static String _toLocalizedLinkToPage(ContentFieldValue contentFieldValue, long groupId, LayoutLocalService layoutLocalService) {
        String valueString = "";
        if (contentFieldValue.getLink() != null) {
            Layout layout = DDMValueUtil._getLayout(groupId, layoutLocalService, contentFieldValue.getLink());
            valueString = JSONUtil.put((String)"groupId", (Object)layout.getGroupId()).put("label", layout.getFriendlyURL()).put("layoutId", layout.getLayoutId()).put("privateLayout", layout.isPrivateLayout()).toString();
        }
        return valueString;
    }

    private static LocalizedValue _toLocalizedValue(ContentFieldValue contentFieldValue, Map<String, ContentFieldValue> localizedContentFieldValues, BiFunction<ContentFieldValue, Locale, String> localizedValueBiFunction, Locale preferredLocale) {
        LocalizedValue localizedValue = new LocalizedValue(preferredLocale);
        localizedValue.addString(preferredLocale, localizedValueBiFunction.apply(contentFieldValue, preferredLocale));
        Optional.ofNullable(localizedContentFieldValues).orElse(Collections.emptyMap()).forEach((languageId, localizedContentFieldValue) -> {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false);
            if (locale != null) {
                localizedValue.addString(locale, (String)localizedValueBiFunction.apply((ContentFieldValue)localizedContentFieldValue, locale));
            }
        });
        return localizedValue;
    }
}

