/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.journal.model.JournalFolder"}, service={DTOConverter.class, StructuredContentFolderDTOConverter.class})
public class StructuredContentFolderDTOConverter
implements DTOConverter<DLFolder, StructuredContentFolder> {
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return StructuredContentFolder.class.getSimpleName();
    }

    public StructuredContentFolder toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final JournalFolder journalFolder = this._journalFolderService.getFolder(((Long)dtoConverterContext.getId()).longValue());
        return new StructuredContentFolder(){
            {
                this.creator = CreatorUtil.toCreator(StructuredContentFolderDTOConverter.this._portal, dtoConverterContext.getUriInfoOptional(), StructuredContentFolderDTOConverter.this._userLocalService.fetchUser(journalFolder.getUserId()));
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), JournalFolder.class.getName(), journalFolder.getFolderId(), journalFolder.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = journalFolder.getCreateDate();
                this.dateModified = journalFolder.getModifiedDate();
                this.description = journalFolder.getDescription();
                this.id = journalFolder.getFolderId();
                this.name = journalFolder.getName();
                this.numberOfStructuredContentFolders = StructuredContentFolderDTOConverter.this._journalFolderService.getFoldersCount(journalFolder.getGroupId(), journalFolder.getFolderId());
                this.numberOfStructuredContents = StructuredContentFolderDTOConverter.this._journalArticleService.getArticlesCount(journalFolder.getGroupId(), journalFolder.getFolderId(), 0);
                this.siteId = journalFolder.getGroupId();
                this.subscribed = StructuredContentFolderDTOConverter.this._subscriptionLocalService.isSubscribed(journalFolder.getCompanyId(), dtoConverterContext.getUserId(), JournalFolder.class.getName(), journalFolder.getFolderId());
            }
        };
    }
}

