/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardThread;
import com.liferay.headless.delivery.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.headless.delivery.internal.dto.v1_0.util.AggregateRatingUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CreatorUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RelatedContentUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.message.boards.model.MBThread"}, service={DTOConverter.class, MessageBoardThreadDTOConverter.class})
public class MessageBoardThreadDTOConverter
implements DTOConverter<MBThread, MessageBoardThread> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return MessageBoardThread.class.getSimpleName();
    }

    public MessageBoardThread toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final MBThread mbThread = this._mbThreadLocalService.getThread(((Long)dtoConverterContext.getId()).longValue());
        final String languageId = LocaleUtil.toLanguageId((Locale)dtoConverterContext.getLocale());
        final MBMessage mbMessage = this._mbMessageLocalService.getMessage(mbThread.getRootMessageId());
        final User user = this._userLocalService.fetchUser(mbThread.getUserId());
        return new MessageBoardThread(){
            {
                this.actions = dtoConverterContext.getActions();
                this.aggregateRating = AggregateRatingUtil.toAggregateRating(MessageBoardThreadDTOConverter.this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbMessage.getMessageId()));
                this.articleBody = mbMessage.getBody();
                this.creator = CreatorUtil.toCreator(MessageBoardThreadDTOConverter.this._portal, dtoConverterContext.getUriInfoOptional(), user);
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), MBMessage.class.getName(), mbMessage.getMessageId(), mbThread.getCompanyId(), dtoConverterContext.getLocale());
                this.dateCreated = mbMessage.getCreateDate();
                this.dateModified = mbMessage.getModifiedDate();
                this.encodingFormat = mbMessage.getFormat();
                this.headline = mbMessage.getSubject();
                this.id = mbThread.getThreadId();
                this.keywords = (String[])ListUtil.toArray((List)MessageBoardThreadDTOConverter.this._assetTagLocalService.getTags(MBMessage.class.getName(), mbMessage.getMessageId()), (Accessor)AssetTag.NAME_ACCESSOR);
                this.numberOfMessageBoardAttachments = mbMessage.getAttachmentsFileEntriesCount();
                this.numberOfMessageBoardMessages = MessageBoardThreadDTOConverter.this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0);
                this.relatedContents = RelatedContentUtil.toRelatedContents(MessageBoardThreadDTOConverter.this._assetEntryLocalService, MessageBoardThreadDTOConverter.this._assetLinkLocalService, dtoConverterContext.getDTOConverterRegistry(), mbMessage.getModelClassName(), mbMessage.getMessageId(), dtoConverterContext.getLocale());
                this.showAsQuestion = mbThread.isQuestion();
                this.siteId = mbThread.getGroupId();
                this.subscribed = MessageBoardThreadDTOConverter.this._subscriptionLocalService.isSubscribed(mbMessage.getCompanyId(), dtoConverterContext.getUserId(), MBThread.class.getName(), mbMessage.getThreadId());
                this.taxonomyCategoryBriefs = (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)MessageBoardThreadDTOConverter.this._assetCategoryLocalService.getCategories(MBMessage.class.getName(), mbThread.getRootMessageId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                this.threadType = MessageBoardThreadDTOConverter.this._toThreadType(languageId, mbThread.getGroupId(), mbThread.getPriority());
                this.viewCount = mbThread.getViewCount();
            }
        };
    }

    private String _toThreadType(String languageId, Long siteId, double priority) throws Exception {
        String[] priorities;
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)siteId);
        for (String priorityString : priorities = mbGroupServiceSettings.getPriorities(languageId)) {
            String[] parts = StringUtil.split((String)priorityString, (String)"|");
            if (priority != GetterUtil.getDouble((String)parts[2])) continue;
            return parts[0];
        }
        return null;
    }
}

