/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.MessageBoardMessage;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.MessageBoardMessageDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.MessageBoardMessageEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseMessageBoardMessageResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.MessageBoardMessageResource;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/message-board-message.properties"}, scope=ServiceScope.PROTOTYPE, service={MessageBoardMessageResource.class})
public class MessageBoardMessageResourceImpl
extends BaseMessageBoardMessageResourceImpl
implements EntityModelResource {
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MessageBoardMessageDTOConverter _messageBoardMessageDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        this._mbMessageService.deleteMessage(messageBoardMessageId.longValue());
    }

    @Override
    public void deleteMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(messageBoardMessageId);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new MessageBoardMessageEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(MBMessage.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public MessageBoardMessage getMessageBoardMessage(Long messageBoardMessageId) throws Exception {
        return this._toMessageBoardMessage(this._mbMessageService.getMessage(messageBoardMessageId.longValue()));
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardMessageMessageBoardMessagesPage(Long parentMessageBoardMessageId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getMessageBoardMessagesPage(parentMessageBoardMessageId, search, filter, pagination, sorts);
    }

    @Override
    public Rating getMessageBoardMessageMyRating(Long messageBoardMessageId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(messageBoardMessageId);
    }

    @Override
    public Page<MessageBoardMessage> getMessageBoardThreadMessageBoardMessagesPage(Long messageBoardThreadId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._getMessageBoardMessagesPage(mbThread.getRootMessageId(), search, filter, pagination, sorts);
    }

    @Override
    public MessageBoardMessage postMessageBoardMessageMessageBoardMessage(Long parentMessageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        return this._addMessageBoardThread(parentMessageBoardMessageId, messageBoardMessage);
    }

    @Override
    public Rating postMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    @Override
    public MessageBoardMessage postMessageBoardThreadMessageBoardMessage(Long messageBoardThreadId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBThread mbThread = this._mbThreadLocalService.getMBThread(messageBoardThreadId.longValue());
        return this._addMessageBoardThread(mbThread.getRootMessageId(), messageBoardMessage);
    }

    @Override
    public MessageBoardMessage putMessageBoardMessage(Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        if (messageBoardMessage.getArticleBody() == null && messageBoardMessage.getHeadline() == null) {
            throw new BadRequestException("Headline and article body are both null");
        }
        MBMessage mbMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            MBMessage parentMBMessage = this._mbMessageService.getMessage(mbMessage.getParentMessageId());
            headline = "RE: " + parentMBMessage.getSubject();
        }
        mbMessage = this._mbMessageService.updateDiscussionMessage(mbMessage.getClassName(), mbMessage.getClassPK(), messageBoardMessageId.longValue(), headline, messageBoardMessage.getArticleBody(), ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardMessage), (long)mbMessage.getGroupId(), (String)messageBoardMessage.getViewableByAsString()));
        this._updateAnswer(mbMessage, messageBoardMessage);
        return this._toMessageBoardMessage(mbMessage);
    }

    @Override
    public Rating putMessageBoardMessageMyRating(Long messageBoardMessageId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), messageBoardMessageId.longValue());
    }

    private MessageBoardMessage _addMessageBoardThread(Long messageBoardMessageId, MessageBoardMessage messageBoardMessage) throws Exception {
        MBMessage parentMBMessage = this._mbMessageService.getMessage(messageBoardMessageId.longValue());
        String headline = messageBoardMessage.getHeadline();
        if (headline == null) {
            headline = "RE: " + parentMBMessage.getSubject();
        }
        MBMessage mbMessage = this._mbMessageService.addMessage(messageBoardMessageId.longValue(), headline, messageBoardMessage.getArticleBody(), MBMessageConstants.DEFAULT_FORMAT, Collections.emptyList(), GetterUtil.getBoolean((Object)messageBoardMessage.getAnonymous()), 0.0, false, ServiceContextUtil.createServiceContext(this._getExpandoBridgeAttributes(messageBoardMessage), (long)parentMBMessage.getGroupId(), (String)messageBoardMessage.getViewableByAsString()));
        this._updateAnswer(mbMessage, messageBoardMessage);
        return this._toMessageBoardMessage(mbMessage);
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(MessageBoardMessage messageBoardMessage) {
        return CustomFieldsUtil.toMap(MBMessage.class.getName(), this.contextCompany.getCompanyId(), messageBoardMessage.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private Page<MessageBoardMessage> _getMessageBoardMessagesPage(Long messageBoardMessageId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("entryClassPK", String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST_NOT);
            booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(messageBoardMessageId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, MBMessage.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toMessageBoardMessage(this._mbMessageService.getMessage(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(MBMessage.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private MessageBoardMessage _toMessageBoardMessage(MBMessage mbMessage) throws Exception {
        return this._messageBoardMessageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(null, mbMessage.getPrimaryKey()));
    }

    private void _updateAnswer(MBMessage mbMessage, MessageBoardMessage messageBoardMessage) throws Exception {
        Boolean showAsAnswer = messageBoardMessage.getShowAsAnswer();
        if (showAsAnswer != null) {
            this._mbMessageService.updateAnswer(mbMessage.getMessageId(), showAsAnswer.booleanValue(), false);
            mbMessage.setAnswer(showAsAnswer.booleanValue());
        }
    }
}

