/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.common.spi.resource.SPIRatingResource;
import com.liferay.headless.common.spi.service.context.ServiceContextUtil;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.Rating;
import com.liferay.headless.delivery.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.delivery.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.delivery.internal.dto.v1_0.converter.KnowledgeBaseArticleDTOConverter;
import com.liferay.headless.delivery.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.EntityFieldsUtil;
import com.liferay.headless.delivery.internal.dto.v1_0.util.RatingUtil;
import com.liferay.headless.delivery.internal.odata.entity.v1_0.KnowledgeBaseArticleEntityModel;
import com.liferay.headless.delivery.internal.resource.v1_0.BaseKnowledgeBaseArticleResourceImpl;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/knowledge-base-article.properties"}, scope=ServiceScope.PROTOTYPE, service={KnowledgeBaseArticleResource.class})
public class KnowledgeBaseArticleResourceImpl
extends BaseKnowledgeBaseArticleResourceImpl
implements EntityModelResource {
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderService _kbFolderService;
    @Reference
    private KnowledgeBaseArticleDTOConverter _knowledgeBaseArticleDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Context
    private User _user;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteKnowledgeBaseArticle(Long knowledgeBaseArticleId) throws Exception {
        this._kbArticleService.deleteKBArticle(knowledgeBaseArticleId.longValue());
    }

    @Override
    public void deleteKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        spiRatingResource.deleteRating(knowledgeBaseArticleId);
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return new KnowledgeBaseArticleEntityModel(EntityFieldsUtil.getEntityFields(this._portal.getClassNameId(KBArticle.class.getName()), this.contextCompany.getCompanyId(), this._expandoColumnLocalService, this._expandoTableLocalService));
    }

    @Override
    public KnowledgeBaseArticle getKnowledgeBaseArticle(Long knowledgeBaseArticleId) throws Exception {
        return this._toKBArticle(this._kbArticleService.getLatestKBArticle(knowledgeBaseArticleId.longValue(), 0));
    }

    @Override
    public Page<KnowledgeBaseArticle> getKnowledgeBaseArticleKnowledgeBaseArticlesPage(Long parentKnowledgeBaseArticleId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(parentKnowledgeBaseArticleId.longValue(), 0);
        return this._getKnowledgeBaseArticlesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(kbArticle.getResourcePrimKey())), BooleanClauseOccur.MUST);
        }), kbArticle.getGroupId(), search, filter, pagination, sorts);
    }

    @Override
    public Rating getKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.getRating(knowledgeBaseArticleId);
    }

    @Override
    public Page<KnowledgeBaseArticle> getKnowledgeBaseFolderKnowledgeBaseArticlesPage(Long knowledgeBaseFolderId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue());
        return this._getKnowledgeBaseArticlesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("folderId", String.valueOf(kbFolder.getKbFolderId())), BooleanClauseOccur.MUST);
            if (!GetterUtil.getBoolean((Object)flatten)) {
                booleanFilter.add((Filter)new TermFilter("parentMessageId", String.valueOf(kbFolder.getKbFolderId())), BooleanClauseOccur.MUST);
            }
        }), kbFolder.getGroupId(), search, filter, pagination, sorts);
    }

    @Override
    public Page<KnowledgeBaseArticle> getSiteKnowledgeBaseArticlesPage(Long siteId, Boolean flatten, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getKnowledgeBaseArticlesPage((UnsafeConsumer<BooleanQuery, Exception>)((UnsafeConsumer)booleanQuery -> {
            if (!GetterUtil.getBoolean((Object)flatten)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                booleanFilter.add((Filter)new TermFilter("folderId", "0"), BooleanClauseOccur.MUST);
                booleanFilter.add((Filter)new TermFilter("parentMessageId", "0"), BooleanClauseOccur.MUST);
            }
        }), siteId, search, filter, pagination, sorts);
    }

    @Override
    public KnowledgeBaseArticle postKnowledgeBaseArticleKnowledgeBaseArticle(Long parentKnowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KBArticle kbArticle = this._kbArticleService.getLatestKBArticle(parentKnowledgeBaseArticleId.longValue(), 0);
        return this._getKnowledgeBaseArticle(kbArticle.getGroupId(), this._portal.getClassNameId(KBArticle.class.getName()), parentKnowledgeBaseArticleId, knowledgeBaseArticle);
    }

    @Override
    public Rating postKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), knowledgeBaseArticleId.longValue());
    }

    @Override
    public KnowledgeBaseArticle postKnowledgeBaseFolderKnowledgeBaseArticle(Long knowledgeBaseFolderId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        KBFolder kbFolder = this._kbFolderService.getKBFolder(knowledgeBaseFolderId.longValue());
        return this._getKnowledgeBaseArticle(kbFolder.getGroupId(), this._portal.getClassNameId(KBFolder.class.getName()), knowledgeBaseFolderId, knowledgeBaseArticle);
    }

    @Override
    public KnowledgeBaseArticle postSiteKnowledgeBaseArticle(Long siteId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._getKnowledgeBaseArticle(siteId, this._portal.getClassNameId(KBFolder.class.getName()), 0L, knowledgeBaseArticle);
    }

    @Override
    public KnowledgeBaseArticle putKnowledgeBaseArticle(Long knowledgeBaseArticleId, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._toKBArticle(this._kbArticleService.updateKBArticle(knowledgeBaseArticleId.longValue(), knowledgeBaseArticle.getTitle(), knowledgeBaseArticle.getArticleBody(), knowledgeBaseArticle.getDescription(), null, null, null, null, ServiceContextUtil.createServiceContext((Long[])Optional.ofNullable(knowledgeBaseArticle.getTaxonomyCategoryIds()).orElse(new Long[0]), (String[])Optional.ofNullable(knowledgeBaseArticle.getKeywords()).orElse(new String[0]), this._getExpandoBridgeAttributes(knowledgeBaseArticle), (Long)knowledgeBaseArticle.getSiteId(), (String)knowledgeBaseArticle.getViewableByAsString())));
    }

    @Override
    public Rating putKnowledgeBaseArticleMyRating(Long knowledgeBaseArticleId, Rating rating) throws Exception {
        SPIRatingResource<Rating> spiRatingResource = this._getSPIRatingResource();
        return (Rating)spiRatingResource.addOrUpdateRating((Number)rating.getRatingValue(), knowledgeBaseArticleId.longValue());
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(KnowledgeBaseArticle knowledgeBaseArticle) {
        return CustomFieldsUtil.toMap(KBArticle.class.getName(), this.contextCompany.getCompanyId(), knowledgeBaseArticle.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
    }

    private KnowledgeBaseArticle _getKnowledgeBaseArticle(Long siteId, long parentResourceClassNameId, Long parentResourcePrimaryKey, KnowledgeBaseArticle knowledgeBaseArticle) throws Exception {
        return this._toKBArticle(this._kbArticleService.addKBArticle("com_liferay_knowledge_base_web_portlet_DisplayPortlet", parentResourceClassNameId, parentResourcePrimaryKey.longValue(), knowledgeBaseArticle.getTitle(), knowledgeBaseArticle.getFriendlyUrlPath(), knowledgeBaseArticle.getArticleBody(), knowledgeBaseArticle.getDescription(), null, null, null, ServiceContextUtil.createServiceContext((Long[])knowledgeBaseArticle.getTaxonomyCategoryIds(), (String[])knowledgeBaseArticle.getKeywords(), this._getExpandoBridgeAttributes(knowledgeBaseArticle), (Long)siteId, (String)knowledgeBaseArticle.getViewableByAsString())));
    }

    private Page<KnowledgeBaseArticle> _getKnowledgeBaseArticlesPage(UnsafeConsumer<BooleanQuery, Exception> booleanQueryUnsafeConsumer, Long siteId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQueryUnsafeConsumer, (Filter)filter, KBArticle.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
            if (search == null) {
                searchContext.setKeywords("");
            }
        }, document -> this._toKBArticle(GetterUtil.getLong((String)document.get("entryClassPK"))), (Sort[])sorts);
    }

    private SPIRatingResource<Rating> _getSPIRatingResource() {
        return new SPIRatingResource(KBArticle.class.getName(), this._ratingsEntryLocalService, ratingsEntry -> RatingUtil.toRating(this._portal, ratingsEntry, this._userLocalService), this._user);
    }

    private KnowledgeBaseArticle _toKBArticle(KBArticle kbArticle) throws Exception {
        if (kbArticle == null) {
            return null;
        }
        return this._toKBArticle(kbArticle.getResourcePrimKey());
    }

    private KnowledgeBaseArticle _toKBArticle(long knowledgeBaseArticleResourcePrimKey) throws Exception {
        return this._knowledgeBaseArticleDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), knowledgeBaseArticleResourcePrimKey));
    }
}

